/*
 * Decompiled with CFR 0.152.
 */
package org.h2.log;

import java.io.IOException;
import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.log.LogSystem;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.store.Record;
import org.h2.store.Storage;
import org.h2.util.ByteUtils;
import org.h2.util.FileUtils;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;

public class LogFile {
    public static final int BLOCK_SIZE = 16;
    private static final int BUFFER_SIZE = 8192;
    private LogSystem logSystem;
    private Database database;
    private int id;
    private String fileNamePrefix;
    private String fileName;
    private FileStore file;
    private int bufferPos;
    private byte[] buffer;
    private ObjectArray unwritten;
    private DataPage rowBuff;
    private int pos = -1;
    private int firstUncommittedPos = -1;
    private int firstUnwrittenPos = -1;

    LogFile(LogSystem logSystem, int n, String string) throws SQLException {
        this.logSystem = logSystem;
        this.database = logSystem.getDatabase();
        this.id = n;
        this.fileNamePrefix = string;
        this.fileName = this.getFileName();
        this.file = logSystem.getDatabase().openFile(this.fileName, logSystem.getAccessMode(), false);
        this.rowBuff = logSystem.getRowBuffer();
        this.buffer = new byte[8192];
        this.unwritten = new ObjectArray();
        try {
            this.readHeader();
            if (!logSystem.getDatabase().getReadOnly()) {
                this.writeHeader();
            }
            this.firstUncommittedPos = this.pos = this.getBlock();
        }
        catch (SQLException sQLException) {
            this.close(false);
            throw sQLException;
        }
    }

    static LogFile openIfLogFile(LogSystem logSystem, String string, String string2) throws SQLException {
        int n;
        if (!string2.endsWith(".log.db")) {
            return null;
        }
        if (!FileUtils.fileStartsWith(string2, string + ".")) {
            return null;
        }
        String string3 = string2.substring(string.length() + 1, string2.length() - ".log.db".length());
        for (n = 0; n < string3.length(); ++n) {
            if (Character.isDigit(string3.charAt(n))) continue;
            return null;
        }
        n = Integer.parseInt(string3);
        if (!FileUtils.exists(string2)) {
            return null;
        }
        return new LogFile(logSystem, n, string);
    }

    public String getFileName() {
        return this.fileNamePrefix + "." + this.id + ".log.db";
    }

    int getId() {
        return this.id;
    }

    private int getBlock() throws SQLException {
        if (this.file == null) {
            throw Message.getSQLException(90098);
        }
        return (int)(this.file.getFilePointer() / 16L);
    }

    private void writeBuffer(DataPage dataPage, Record record) throws SQLException {
        if (this.file == null) {
            throw Message.getSQLException(90098);
        }
        int n = MathUtils.roundUp(dataPage.length() + 2, 16);
        int n2 = n / 16;
        dataPage.fill(n);
        dataPage.setInt(0, n2);
        dataPage.updateChecksum();
        if (record != null) {
            this.unwritten.add(record);
        }
        if (dataPage.length() + this.bufferPos > this.buffer.length) {
            this.flush();
        }
        if (dataPage.length() >= this.buffer.length) {
            this.file.write(dataPage.getBytes(), 0, dataPage.length());
            this.pos = this.getBlock();
            return;
        }
        System.arraycopy(dataPage.getBytes(), 0, this.buffer, this.bufferPos, dataPage.length());
        this.bufferPos += dataPage.length();
        this.pos = this.getBlock() + this.bufferPos / 16;
    }

    void commit(Session session) throws SQLException {
        DataPage dataPage = this.rowBuff;
        dataPage.reset();
        dataPage.writeInt(0);
        dataPage.writeByte((byte)67);
        dataPage.writeInt(session.getId());
        this.writeBuffer(dataPage, null);
        if (this.logSystem.getFlushOnEachCommit()) {
            this.flush();
        }
    }

    void prepareCommit(Session session, String string) throws SQLException {
        DataPage dataPage = this.rowBuff;
        dataPage.reset();
        dataPage.writeInt(0);
        dataPage.writeByte((byte)80);
        dataPage.writeInt(session.getId());
        dataPage.writeString(string);
        this.writeBuffer(dataPage, null);
        if (this.logSystem.getFlushOnEachCommit()) {
            this.flush();
        }
    }

    private DataPage readPage() throws SQLException {
        byte[] byArray = new byte[16];
        this.file.readFully(byArray, 0, 16);
        DataPage dataPage = DataPage.create((DataHandler)this.database, byArray);
        int n = Math.abs(dataPage.readInt());
        if (n <= 0) {
            dataPage.reset();
        } else {
            byte[] byArray2 = ByteUtils.newBytes(n * 16);
            System.arraycopy(byArray, 0, byArray2, 0, 16);
            byArray = byArray2;
            this.file.readFully(byArray, 16, n * 16 - 16);
            dataPage = DataPage.create((DataHandler)this.database, byArray);
            dataPage.check(n * 16);
        }
        return dataPage;
    }

    private boolean redoOrUndo(boolean bl, boolean bl2) throws SQLException {
        int n = this.getBlock();
        DataPage dataPage = this.readPage();
        int n2 = dataPage.readInt();
        if (n2 < 0) {
            return true;
        }
        if (n2 == 0 && !this.database.getReadOnly()) {
            this.truncate(n);
            return false;
        }
        char c = (char)dataPage.readByte();
        int n3 = dataPage.readInt();
        if (c == 'P') {
            if (bl) {
                Message.throwInternalError("can't undo prepare commit");
            }
            String string = dataPage.readString();
            this.logSystem.setPreparedCommitForSession(this, n3, n, string, n2);
            return true;
        }
        if (c == 'C') {
            if (bl) {
                Message.throwInternalError("can't undo commit");
            }
            this.logSystem.setLastCommitForSession(n3, this.id, n);
            return true;
        }
        if (c == 'R') {
            if (bl) {
                Message.throwInternalError("can't undo rollback");
            }
            return true;
        }
        if (c == 'S' && bl) {
            Message.throwInternalError("can't undo summary");
        }
        if (bl2 && c != 'S') {
            return true;
        }
        if (bl) {
            if (this.logSystem.isSessionCommitted(n3, this.id, n)) {
                this.logSystem.removeSession(n3);
                return true;
            }
        } else if (c != 'S' && !bl2) {
            this.logSystem.addUndoLogRecord(this, n, n3);
        }
        int n4 = dataPage.readInt();
        Storage storage = this.logSystem.getStorageForRecovery(n4);
        DataPage dataPage2 = null;
        int n5 = dataPage.readInt();
        int n6 = dataPage.readInt();
        if (c != 'T') {
            dataPage2 = dataPage.readDataPageNoSize();
        }
        switch (c) {
            case 'S': {
                boolean bl3;
                int n7 = dataPage.readByte();
                if (n7 == 68) {
                    bl3 = true;
                } else {
                    if (n7 != 73) break;
                    bl3 = false;
                }
                int n8 = dataPage.readInt();
                byte[] byArray = ByteUtils.newBytes(n8);
                if (n8 > 0) {
                    dataPage.read(byArray, 0, n8);
                }
                if (bl3) {
                    this.database.getDataFile().initFromSummary(byArray);
                    break;
                }
                this.database.getIndexFile().initFromSummary(byArray);
                break;
            }
            case 'T': {
                if (bl) {
                    Message.throwInternalError("cannot undo truncate");
                }
                this.logSystem.addRedoLog(storage, n5, n6, null);
                storage.setRecordCount(0);
                storage.getDiskFile().setPageOwner(n5 / 64, -1);
                this.logSystem.setLastCommitForSession(n3, this.id, n);
                break;
            }
            case 'I': {
                if (bl) {
                    this.logSystem.addRedoLog(storage, n5, n6, null);
                    storage.setRecordCount(storage.getRecordCount() - 1);
                    break;
                }
                this.logSystem.getOrAddSessionState(n3);
                this.logSystem.addRedoLog(storage, n5, n6, dataPage2);
                storage.setRecordCount(storage.getRecordCount() + 1);
                break;
            }
            case 'D': {
                if (bl) {
                    this.logSystem.addRedoLog(storage, n5, n6, dataPage2);
                    storage.setRecordCount(storage.getRecordCount() + 1);
                    break;
                }
                this.logSystem.getOrAddSessionState(n3);
                this.logSystem.addRedoLog(storage, n5, n6, null);
                storage.setRecordCount(storage.getRecordCount() - 1);
                break;
            }
            default: {
                Message.throwInternalError("type=" + c);
            }
        }
        return true;
    }

    void redoAllGoEnd() throws SQLException {
        boolean bl = this.logSystem.getDatabase().getReadOnly();
        long l = this.file.length();
        if (l <= 48L) {
            return;
        }
        try {
            boolean bl2;
            int n = (int)(l / 16L);
            do {
                this.pos = this.getBlock();
                this.database.setProgress(2, this.fileName, this.pos, n);
            } while ((long)this.pos * 16L < l && (bl2 = this.redoOrUndo(false, bl)));
            this.database.setProgress(2, this.fileName, n, n);
        }
        catch (SQLException sQLException) {
            this.database.getTrace("log").debug("Stop reading log file: " + sQLException.getMessage(), sQLException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.logSystem.setReadOnly(true);
            throw Message.convert(outOfMemoryError);
        }
        catch (Throwable throwable) {
            this.database.getTrace("log").error("Error reading log file (non-fatal)", throwable);
        }
        this.go(this.pos);
    }

    void go(int n) throws SQLException {
        this.file.seek((long)n * 16L);
    }

    void undo(int n) throws SQLException {
        this.go(n);
        this.redoOrUndo(true, false);
    }

    void flush() throws SQLException {
        if (this.bufferPos > 0) {
            if (this.file == null) {
                throw Message.getSQLException(90098);
            }
            this.file.write(this.buffer, 0, this.bufferPos);
            this.pos = this.getBlock();
            for (int i = 0; i < this.unwritten.size(); ++i) {
                Record record = (Record)this.unwritten.get(i);
                record.setLogWritten(this.id, this.pos);
            }
            this.unwritten.clear();
            this.bufferPos = 0;
            long l = (long)this.pos * 16L;
            l = MathUtils.scaleUp50Percent(131072L, l, 8192L, 0x2000000L);
            if (l > this.file.length()) {
                this.file.setLength(l);
            }
        }
    }

    void close(boolean bl) throws SQLException {
        SQLException sQLException = null;
        try {
            this.flush();
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
        }
        if (this.file != null) {
            block9: {
                try {
                    this.file.close();
                    this.file = null;
                    if (bl) {
                        try {
                            this.database.deleteLogFileLater(this.fileName);
                        }
                        catch (SQLException sQLException3) {}
                    }
                }
                catch (IOException iOException) {
                    if (sQLException != null) break block9;
                    sQLException = Message.convertIOException(iOException, this.fileName);
                }
            }
            this.file = null;
            this.fileNamePrefix = null;
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    void addSummary(boolean bl, byte[] byArray) throws SQLException {
        DataPage dataPage = DataPage.create((DataHandler)this.database, 256);
        dataPage.writeInt(0);
        dataPage.writeByte((byte)83);
        dataPage.writeInt(0);
        dataPage.writeInt(0);
        dataPage.writeInt(0);
        dataPage.writeInt(0);
        dataPage.writeByte((byte)(bl ? 68 : 73));
        if (byArray == null) {
            dataPage.writeInt(0);
        } else {
            dataPage.checkCapacity(byArray.length);
            dataPage.writeInt(byArray.length);
            dataPage.write(byArray, 0, byArray.length);
        }
        this.writeBuffer(dataPage, null);
    }

    void addTruncate(Session session, int n, int n2, int n3) throws SQLException {
        DataPage dataPage = this.rowBuff;
        dataPage.reset();
        dataPage.writeInt(0);
        dataPage.writeByte((byte)84);
        dataPage.writeInt(session.getId());
        dataPage.writeInt(n);
        dataPage.writeInt(n2);
        dataPage.writeInt(n3);
        this.writeBuffer(dataPage, null);
    }

    void add(Session session, int n, Record record) throws SQLException {
        record.prepareWrite();
        DataPage dataPage = this.rowBuff;
        dataPage.reset();
        dataPage.writeInt(0);
        if (record.getDeleted()) {
            dataPage.writeByte((byte)68);
        } else {
            dataPage.writeByte((byte)73);
        }
        dataPage.writeInt(session.getId());
        dataPage.writeInt(n);
        dataPage.writeInt(record.getPos());
        int n2 = record.getBlockCount();
        dataPage.writeInt(n2);
        dataPage.checkCapacity(128 * n2);
        record.write(dataPage);
        this.writeBuffer(dataPage, record);
    }

    void setFirstUncommittedPos(int n) throws SQLException {
        this.firstUncommittedPos = n;
        int n2 = this.getBlock();
        this.writeHeader();
        this.go(n2);
    }

    int getFirstUncommittedPos() {
        return this.firstUncommittedPos;
    }

    private void writeHeader() throws SQLException {
        this.file.seek(48L);
        DataPage dataPage = this.getHeader();
        this.file.write(dataPage.getBytes(), 0, dataPage.length());
    }

    private void truncate(int n) throws SQLException {
        this.go(n);
        this.file.setLength((long)n * 16L);
    }

    private DataPage getHeader() {
        DataPage dataPage = this.rowBuff;
        dataPage.reset();
        dataPage.writeInt(this.id);
        dataPage.writeInt(this.firstUncommittedPos);
        dataPage.writeInt(this.firstUnwrittenPos);
        dataPage.fill(48);
        return dataPage;
    }

    private void readHeader() throws SQLException {
        DataPage dataPage = this.getHeader();
        int n = dataPage.length();
        dataPage.reset();
        if (this.file.length() < (long)(48 + n)) {
            return;
        }
        this.file.readFully(dataPage.getBytes(), 0, n);
        this.id = dataPage.readInt();
        this.firstUncommittedPos = dataPage.readInt();
        this.firstUnwrittenPos = dataPage.readInt();
    }

    int getPos() {
        return this.pos;
    }

    long getFileSize() throws SQLException {
        return this.file.getFilePointer();
    }

    void sync() {
        if (this.file != null) {
            this.file.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePreparedCommit(boolean bl, int n, int n2, int n3) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            int n4 = this.getBlock();
            DataPage dataPage = this.rowBuff;
            dataPage.reset();
            dataPage.writeInt(n3);
            if (bl) {
                dataPage.writeByte((byte)67);
            } else {
                dataPage.writeByte((byte)82);
            }
            dataPage.writeInt(n2);
            dataPage.fill(n3 * 16);
            dataPage.updateChecksum();
            this.go(n);
            this.file.write(dataPage.getBytes(), 0, 16 * n3);
            this.go(n4);
        }
    }
}

