/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueArray
extends Value {
    private final Value[] values;
    private int hash;

    private ValueArray(Value[] valueArray) {
        this.values = valueArray;
    }

    public static ValueArray get(Value[] valueArray) {
        return new ValueArray(valueArray);
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int n = 1;
        int n2 = 0;
        while (n2 < this.values.length) {
            n = n * 31 + this.values[n2++].hashCode();
        }
        this.hash = n;
        return n;
    }

    public Value[] getList() {
        return this.values;
    }

    public int getType() {
        return 17;
    }

    public long getPrecision() {
        return 0L;
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.values[i].getString());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    protected int compareSecure(Value value, CompareMode compareMode) throws SQLException {
        ValueArray valueArray = (ValueArray)value;
        if (this.values == valueArray.values) {
            return 0;
        }
        int n = this.values.length;
        int n2 = valueArray.values.length;
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            Value value2 = this.values[i];
            Value value3 = valueArray.values[i];
            int n4 = value2.compareTo(value3, compareMode);
            if (n4 == 0) continue;
            return n4;
        }
        return n > n2 ? 1 : (n == n2 ? 0 : -1);
    }

    public Object getObject() {
        Object[] objectArray = new Object[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            objectArray[i] = this.values[i].getObject();
        }
        return objectArray;
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        throw this.throwUnsupportedExceptionForType();
    }

    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.values[i].getSQL());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public String getTraceSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.values[i].getTraceSQL());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public int getDisplaySize() {
        long l = 0L;
        for (int i = 0; i < this.values.length; ++i) {
            l += (long)this.values[i].getDisplaySize();
        }
        return MathUtils.convertLongToInt(l);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ValueArray)) {
            return false;
        }
        ValueArray valueArray = (ValueArray)object;
        if (this.values == valueArray.values) {
            return true;
        }
        if (this.values.length != valueArray.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].equals(valueArray.values[i])) continue;
            return false;
        }
        return true;
    }

    public int getMemory() {
        int n = 0;
        for (int i = 0; i < this.values.length; ++i) {
            n += this.values[i].getMemory();
        }
        return n;
    }
}

