/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileObjectDiskChannel;
import org.h2.store.fs.FileObjectDiskMapped;
import org.h2.store.fs.FileSystemDisk;

public class FileSystemDiskNio
extends FileSystemDisk {
    private static final FileSystemDiskNio INSTANCE = new FileSystemDiskNio();

    public static FileSystemDisk getInstance() {
        return INSTANCE;
    }

    public String createTempFile(String string, String string2, boolean bl, boolean bl2) throws IOException {
        String string3 = super.createTempFile(string, string2, bl, bl2);
        return this.getPrefix() + string3;
    }

    protected String translateFileName(String string) {
        if (string.startsWith(this.getPrefix())) {
            string = string.substring(this.getPrefix().length());
        }
        return super.translateFileName(string);
    }

    public InputStream openFileInputStream(String string) throws IOException {
        return super.openFileInputStream(this.translateFileName(string));
    }

    public String normalize(String string) throws SQLException {
        return this.getPrefix() + super.normalize(string);
    }

    public String[] listFiles(String string) throws SQLException {
        String[] stringArray = super.listFiles(string);
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            stringArray[i] = this.getPrefix() + stringArray[i];
        }
        return stringArray;
    }

    public String getParent(String string) {
        return this.getPrefix() + super.getParent(string);
    }

    public String getAbsolutePath(String string) {
        return this.getPrefix() + super.getAbsolutePath(string);
    }

    public FileObject openFileObject(String string, String string2) throws IOException {
        FileObjectDiskMapped fileObjectDiskMapped;
        string = this.translateFileName(string);
        try {
            fileObjectDiskMapped = new FileObjectDiskMapped(string, string2);
            this.trace("openRandomAccessFile", string, fileObjectDiskMapped);
        }
        catch (IOException iOException) {
            this.freeMemoryAndFinalize();
            try {
                fileObjectDiskMapped = new FileObjectDiskMapped(string, string2);
            }
            catch (IOException iOException2) {
                iOException2.initCause(iOException);
                throw iOException2;
            }
        }
        return fileObjectDiskMapped;
    }

    protected String getPrefix() {
        return "nio:";
    }

    protected FileObject open(String string, String string2) throws IOException {
        return new FileObjectDiskChannel(string, string2);
    }
}

