/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.command.dml.Select;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionList;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Function;
import org.h2.expression.TableFunction;
import org.h2.expression.ValueExpression;
import org.h2.index.Index;
import org.h2.index.IndexCondition;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.FunctionTable;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionIn
extends Condition {
    private final Database database;
    private Expression left;
    private final ObjectArray values;
    private Value min;
    private Value max;
    private int queryLevel;

    public ConditionIn(Database database, Expression expression, ObjectArray objectArray) {
        this.database = database;
        this.left = expression;
        this.values = objectArray;
    }

    public Value getValue(Session session) throws SQLException {
        Value value = this.left.getValue(session);
        if (this.values.size() == 0) {
            return ValueBoolean.get(false);
        }
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.values.size(); ++i) {
            Expression expression = (Expression)this.values.get(i);
            Value value2 = expression.getValue(session);
            if (value2 == ValueNull.INSTANCE) {
                bl2 = true;
                continue;
            }
            bl = Comparison.compareNotNull(this.database, value, value2, 0);
            if (bl) break;
        }
        if (!bl && bl2) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(bl);
    }

    public void mapColumns(ColumnResolver columnResolver, int n) throws SQLException {
        this.left.mapColumns(columnResolver, n);
        for (int i = 0; i < this.values.size(); ++i) {
            Expression expression = (Expression)this.values.get(i);
            expression.mapColumns(columnResolver, n);
        }
        this.queryLevel = Math.max(n, this.queryLevel);
    }

    public Expression optimize(Session session) throws SQLException {
        Object object;
        int n;
        if (this.values.size() == 0) {
            return ValueExpression.get(ValueBoolean.get(false));
        }
        this.left = this.left.optimize(session);
        boolean bl = this.left.isConstant();
        if (bl && this.left == ValueExpression.getNull()) {
            return this.left;
        }
        boolean bl2 = true;
        for (n = 0; n < this.values.size(); ++n) {
            object = (Expression)this.values.get(n);
            object = ((Expression)object).optimize(session);
            if (bl2 && !((Expression)object).isConstant()) {
                bl2 = false;
            }
            this.values.set(n, object);
        }
        if (bl && bl2) {
            return ValueExpression.get(this.getValue(session));
        }
        if (this.values.size() == 1) {
            Expression expression = (Expression)this.values.get(0);
            object = new Comparison(session, 0, this.left, expression);
            object = ((Expression)object).optimize(session);
            return object;
        }
        if (SysProperties.OPTIMIZE_IN) {
            n = this.left.getType();
            object = ExpressionVisitor.get(0);
            ((ExpressionVisitor)object).setQueryLevel(this.queryLevel);
            if (this.areAllValues((ExpressionVisitor)object) && this.left instanceof ExpressionColumn) {
                Column column = ((ExpressionColumn)this.left).getColumn();
                boolean bl3 = column.getNullable();
                CompareMode compareMode = session.getDatabase().getCompareMode();
                for (int i = 0; i < this.values.size(); ++i) {
                    Expression expression = (Expression)this.values.get(i);
                    Value value = expression.getValue(session);
                    value = value.convertTo(n);
                    this.values.set(i, ValueExpression.get(value));
                    if (!(this.min != null && this.min.compareTo(value, compareMode) <= 0 || value == ValueNull.INSTANCE && !bl3)) {
                        this.min = value;
                    }
                    if (this.max != null && this.max.compareTo(value, compareMode) >= 0) continue;
                    this.max = value;
                }
            }
        }
        return this;
    }

    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (!SysProperties.OPTIMIZE_IN) {
            return;
        }
        if (this.min == null && this.max == null) {
            return;
        }
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        tableFilter.addIndexCondition(new IndexCondition(1, expressionColumn, ValueExpression.get(this.min)));
        tableFilter.addIndexCondition(new IndexCondition(3, expressionColumn, ValueExpression.get(this.max)));
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        for (int i = 0; i < this.values.size(); ++i) {
            Expression expression = (Expression)this.values.get(i);
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.left.getSQL());
        stringBuffer.append(" IN(");
        for (int i = 0; i < this.values.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            Expression expression = (Expression)this.values.get(i);
            stringBuffer.append(expression.getSQL());
        }
        stringBuffer.append("))");
        return stringBuffer.toString();
    }

    public void updateAggregate(Session session) throws SQLException {
        this.left.updateAggregate(session);
        for (int i = 0; i < this.values.size(); ++i) {
            Expression expression = (Expression)this.values.get(i);
            expression.updateAggregate(session);
        }
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (!this.left.isEverything(expressionVisitor)) {
            return false;
        }
        return this.areAllValues(expressionVisitor);
    }

    private boolean areAllValues(ExpressionVisitor expressionVisitor) {
        for (int i = 0; i < this.values.size(); ++i) {
            Expression expression = (Expression)this.values.get(i);
            if (expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return true;
    }

    public int getCost() {
        int n = this.left.getCost();
        for (int i = 0; i < this.values.size(); ++i) {
            Expression expression = (Expression)this.values.get(i);
            n += expression.getCost();
        }
        return n;
    }

    public Expression optimizeInJoin(Session session, Select select) throws SQLException {
        Object object;
        if (!this.areAllValues(ExpressionVisitor.get(3))) {
            return this;
        }
        if (!(this.left instanceof ExpressionColumn)) {
            return this;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        Index index = expressionColumn.getTableFilter().getTable().getIndexForColumn(expressionColumn.getColumn(), false);
        if (index == null) {
            return this;
        }
        Database database = session.getDatabase();
        Schema schema = database.getSchema("PUBLIC");
        int n = this.values.size();
        TableFunction tableFunction = new TableFunction(this.database, Function.getFunctionInfo("TABLE_DISTINCT"), n);
        Expression[] expressionArray = new Expression[n];
        for (int i = 0; i < n; ++i) {
            object = (Expression)this.values.get(i);
            expressionArray[i] = object;
        }
        ExpressionList expressionList = new ExpressionList(expressionArray);
        tableFunction.setParameter(0, expressionList);
        tableFunction.doneWithParameters();
        object = new ObjectArray();
        int n2 = this.left.getType();
        String string = session.getNextSystemIdentifier(select.getSQL());
        Column column = new Column(string, n2);
        ((ObjectArray)object).add(column);
        tableFunction.setColumns((ObjectArray)object);
        FunctionTable functionTable = new FunctionTable(schema, session, tableFunction, tableFunction);
        String string2 = session.getNextSystemIdentifier(select.getSQL());
        TableFilter tableFilter = new TableFilter(session, functionTable, string2, false, select);
        select.addTableFilter(tableFilter, true);
        ExpressionColumn expressionColumn2 = new ExpressionColumn(database, null, string2, string);
        Expression expression = new Comparison(session, 0, this.left, expressionColumn2);
        ((Expression)expression).mapColumns(tableFilter, 0);
        expression = ((Expression)expression).optimize(session);
        return new ConditionAndOr(0, this, expression);
    }
}

