/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.Driver;
import org.h2.message.Message;
import org.h2.util.ClassUtils;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.ScriptReader;
import org.h2.util.StringUtils;
import org.h2.util.Tool;

public class RunScript
extends Tool {
    private boolean showResults;
    private boolean checkResults;

    private void showUsage() {
        this.out.println("Runs a SQL script.");
        this.out.println("java " + this.getClass().getName() + "\n" + " -url <url>         The database URL\n" + " -user <user>       The user name\n" + " [-password <pwd>]  The password\n" + " [-script <file>]   The script file to run (default: backup.sql)\n" + " [-driver <class>]  The JDBC driver class to use (not required in most cases)\n" + " [-showResults]     Show the statements and the results of queries\n" + " [-checkResults]    Check if the query results match the expected results\n" + " [-options ...]     The list of options (only for H2 embedded mode)");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public static void main(String[] stringArray) throws SQLException {
        new RunScript().run(stringArray);
    }

    public void run(String[] stringArray) throws SQLException {
        String string = null;
        String string2 = null;
        String string3 = "";
        String string4 = "backup.sql";
        String string5 = null;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            CharSequence charSequence;
            String string6 = stringArray[i];
            if (string6.equals("-url")) {
                string = stringArray[++i];
                continue;
            }
            if (string6.equals("-user")) {
                string2 = stringArray[++i];
                continue;
            }
            if (string6.equals("-password")) {
                string3 = stringArray[++i];
                continue;
            }
            if (string6.equals("-continueOnError")) {
                bl = true;
                continue;
            }
            if (string6.equals("-checkResults")) {
                this.checkResults = true;
                continue;
            }
            if (string6.equals("-showResults")) {
                this.showResults = true;
                continue;
            }
            if (string6.equals("-script")) {
                string4 = stringArray[++i];
                continue;
            }
            if (string6.equals("-time")) {
                bl2 = true;
                continue;
            }
            if (string6.equals("-driver")) {
                charSequence = stringArray[++i];
                ClassUtils.loadUserClass((String)charSequence);
                continue;
            }
            if (string6.equals("-options")) {
                charSequence = new StringBuffer();
                ++i;
                while (i < stringArray.length) {
                    ((StringBuffer)charSequence).append(' ');
                    ((StringBuffer)charSequence).append(stringArray[i]);
                    ++i;
                }
                string5 = ((StringBuffer)charSequence).toString();
                continue;
            }
            if (string6.equals("-help") || string6.equals("-?")) {
                this.showUsage();
                return;
            }
            this.out.println("Unsupported option: " + string6);
            this.showUsage();
            return;
        }
        if (string == null || string2 == null || string3 == null || string4 == null) {
            this.showUsage();
            return;
        }
        long l = System.currentTimeMillis();
        if (string5 != null) {
            RunScript.processRunscript(string, string2, string3, string4, string5);
        } else {
            this.process(string, string2, string3, string4, null, bl);
        }
        if (bl2) {
            l = System.currentTimeMillis() - l;
            this.out.println("Done in " + l + " ms");
        }
    }

    public static ResultSet execute(Connection connection, Reader reader) throws SQLException {
        return new RunScript().process(connection, reader);
    }

    private ResultSet process(Connection connection, Reader reader) throws SQLException {
        String string;
        reader = new BufferedReader(reader);
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        ScriptReader scriptReader = new ScriptReader(reader);
        while ((string = scriptReader.readStatement()) != null) {
            boolean bl = statement.execute(string);
            if (!bl) continue;
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            resultSet = statement.getResultSet();
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Connection connection, String string, boolean bl, String string2) throws SQLException, IOException {
        InputStream inputStream = FileUtils.openFileInputStream(string);
        String string3 = FileUtils.getParent(string);
        try {
            inputStream = new BufferedInputStream(inputStream, 4096);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string2);
            this.process(connection, bl, string3, inputStreamReader, string2);
        }
        finally {
            IOUtils.closeSilently(inputStream);
        }
    }

    private void process(Connection connection, boolean bl, String string, Reader reader, String string2) throws SQLException, IOException {
        String string3;
        Statement statement = connection.createStatement();
        ScriptReader scriptReader = new ScriptReader(new BufferedReader(reader));
        while ((string3 = scriptReader.readStatement()) != null) {
            String string4 = string3.trim();
            if (string4.startsWith("@") && StringUtils.toUpperEnglish(string4).startsWith("@INCLUDE")) {
                string3 = string4;
                if (!FileUtils.isAbsolute(string3 = string3.substring("@INCLUDE".length()).trim())) {
                    string3 = string + File.separator + string3;
                }
                this.process(connection, string3, bl, string2);
                continue;
            }
            try {
                if (string4.length() <= 0) continue;
                if (this.showResults && !string4.startsWith("-->")) {
                    this.out.print(string3 + ";");
                }
                if (this.showResults || this.checkResults) {
                    String string5;
                    boolean bl2 = statement.execute(string3);
                    if (!bl2) continue;
                    ResultSet resultSet = statement.getResultSet();
                    int n = resultSet.getMetaData().getColumnCount();
                    StringBuffer stringBuffer = new StringBuffer();
                    while (resultSet.next()) {
                        stringBuffer.append("\n-->");
                        for (int i = 0; i < n; ++i) {
                            string5 = resultSet.getString(i + 1);
                            if (string5 != null) {
                                string5 = StringUtils.replaceAll(string5, "\r\n", "\n");
                                string5 = StringUtils.replaceAll(string5, "\n", "\n-->    ");
                                string5 = StringUtils.replaceAll(string5, "\r", "\r-->    ");
                            }
                            stringBuffer.append(' ');
                            stringBuffer.append(string5);
                        }
                    }
                    stringBuffer.append("\n;");
                    String string6 = stringBuffer.toString();
                    if (this.showResults) {
                        this.out.print(string6);
                    }
                    if (!this.checkResults) continue;
                    string5 = scriptReader.readStatement() + ";";
                    string5 = StringUtils.replaceAll(string5, "\r\n", "\n");
                    if ((string5 = StringUtils.replaceAll(string5, "\r", "\n")).equals(string6)) continue;
                    string5 = StringUtils.replaceAll(string5, " ", "+");
                    string6 = StringUtils.replaceAll(string6, " ", "+");
                    throw new SQLException("Unexpected output for:\n" + string3.trim() + "\nGot:\n" + string6 + "\nExpected:\n" + string5);
                }
                statement.execute(string3);
            }
            catch (SQLException sQLException) {
                if (bl) {
                    sQLException.printStackTrace(this.out);
                    continue;
                }
                throw sQLException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processRunscript(String string, String string2, String string3, String string4, String string5) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            Driver.load();
            connection = DriverManager.getConnection(string, string2, string3);
            statement = connection.createStatement();
            String string6 = "RUNSCRIPT FROM '" + string4 + "' " + string5;
            statement.execute(string6);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(statement);
            JdbcUtils.closeSilently(connection);
            throw throwable;
        }
        JdbcUtils.closeSilently(statement);
        JdbcUtils.closeSilently(connection);
    }

    public static void execute(String string, String string2, String string3, String string4, String string5, boolean bl) throws SQLException {
        new RunScript().process(string, string2, string3, string4, string5, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process(String string, String string2, String string3, String string4, String string5, boolean bl) throws SQLException {
        try {
            Driver.load();
            Connection connection = DriverManager.getConnection(string, string2, string3);
            if (string5 == null) {
                string5 = "UTF8";
            }
            try {
                this.process(connection, string4, bl, string5);
            }
            finally {
                connection.close();
            }
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, string4);
        }
    }

    public void setShowResults(boolean bl) {
        this.showResults = bl;
    }

    public void setCheckResults(boolean bl) {
        this.checkResults = bl;
    }
}

