/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public abstract class BaseIndex
extends SchemaObjectBase
implements Index {
    protected IndexColumn[] indexColumns;
    protected Column[] columns;
    protected int[] columnIds;
    protected Table table;
    protected IndexType indexType;
    protected boolean isMultiVersion;

    void initBaseIndex(Table table, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initSchemaObjectBase(table.getSchema(), n, string, "index");
        this.indexType = indexType;
        this.table = table;
        if (indexColumnArray != null) {
            this.indexColumns = indexColumnArray;
            this.columns = new Column[indexColumnArray.length];
            this.columnIds = new int[this.columns.length];
            for (int i = 0; i < this.columns.length; ++i) {
                Column column;
                this.columns[i] = column = indexColumnArray[i].column;
                this.columnIds[i] = column.getColumnId();
            }
        }
    }

    public abstract void close(Session var1) throws SQLException;

    public abstract void add(Session var1, Row var2) throws SQLException;

    public abstract void remove(Session var1, Row var2) throws SQLException;

    public abstract Cursor find(Session var1, SearchRow var2, SearchRow var3) throws SQLException;

    public abstract double getCost(Session var1, int[] var2) throws SQLException;

    public abstract void remove(Session var1) throws SQLException;

    public abstract void truncate(Session var1) throws SQLException;

    public abstract boolean canGetFirstOrLast();

    public abstract Cursor findFirstOrLast(Session var1, boolean var2) throws SQLException;

    public abstract boolean needRebuild();

    public String getDropSQL() {
        return null;
    }

    public SQLException getDuplicateKeyException() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        stringBuffer.append(" ");
        stringBuffer.append(" ON ");
        stringBuffer.append(this.table.getSQL());
        stringBuffer.append("(");
        stringBuffer.append(this.getColumnListSQL());
        stringBuffer.append(")");
        return Message.getSQLException(23001, stringBuffer.toString());
    }

    public String getPlanSQL() {
        return this.getSQL();
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        this.table.removeIndex(this);
        this.remove(session);
        this.database.removeMeta(session, this.getId());
    }

    public boolean canFindNext() {
        return false;
    }

    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        throw Message.throwInternalError();
    }

    public int getLookupCost(long l) {
        return 2;
    }

    public long getCostRangeIndex(int[] nArray, long l) {
        long l2 = l += 1000L;
        long l3 = l;
        int n = 0;
        for (int i = 0; nArray != null && i < this.columns.length; ++i) {
            long l4;
            Column column = this.columns[i];
            int n2 = column.getColumnId();
            int n3 = nArray[n2];
            if ((n3 & 1) == 1) {
                if (i == this.columns.length - 1 && this.getIndexType().getUnique()) {
                    l2 = this.getLookupCost(l) + 1;
                    break;
                }
                l4 = l * (long)(n = 100 - (100 - n) * (100 - column.getSelectivity()) / 100) / 100L;
                if (l4 <= 0L) {
                    l4 = 1L;
                }
            } else {
                if ((n3 & 6) == 6) {
                    l2 = (long)this.getLookupCost(l) + l3 / 4L;
                    break;
                }
                if ((n3 & 2) == 2) {
                    l2 = (long)this.getLookupCost(l) + l3 / 3L;
                    break;
                }
                if ((n3 & 4) != 4) break;
                l2 = l3 / 3L;
                break;
            }
            l3 = Math.max(l / l4, 1L);
            l2 = (long)this.getLookupCost(l) + l3;
        }
        return l2;
    }

    public int compareRows(SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        for (int i = 0; i < this.indexColumns.length; ++i) {
            int n = this.columnIds[i];
            Value value = searchRow2.getValue(n);
            if (value == null) {
                return 0;
            }
            int n2 = this.compareValues(searchRow.getValue(n), value, this.indexColumns[i].sortType);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    public boolean containsNullAndAllowMultipleNull(Session session, Row row) {
        Mode mode = session.getDatabase().getMode();
        if (mode.uniqueIndexSingleNull) {
            return false;
        }
        if (mode.uniqueIndexSingleNullExceptAllColumnsAreNull) {
            for (int i = 0; i < this.columns.length; ++i) {
                int n = this.columnIds[i];
                Value value = row.getValue(n);
                if (value == ValueNull.INSTANCE) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.columns.length; ++i) {
            int n = this.columnIds[i];
            Value value = row.getValue(n);
            if (value != ValueNull.INSTANCE) continue;
            return true;
        }
        return false;
    }

    public int compareKeys(SearchRow searchRow, SearchRow searchRow2) {
        int n;
        int n2 = searchRow.getPos();
        if (n2 == (n = searchRow2.getPos())) {
            if (this.isMultiVersion) {
                int n3;
                int n4 = searchRow.getVersion();
                return n4 == (n3 = searchRow2.getVersion()) ? 0 : (n4 < n3 ? 1 : -1);
            }
            return 0;
        }
        return n2 > n ? 1 : -1;
    }

    private int compareValues(Value value, Value value2, int n) throws SQLException {
        boolean bl;
        boolean bl2 = value == null;
        boolean bl3 = bl = value2 == null;
        if (bl2 || bl) {
            if (bl2 == bl) {
                return 0;
            }
            return SortOrder.compareNull(bl2, bl, n);
        }
        int n2 = this.database.compareTypeSave(value, value2);
        if ((n & 1) != 0) {
            n2 = -n2;
        }
        return n2;
    }

    public int getColumnIndex(Column column) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] != column) continue;
            return i;
        }
        return -1;
    }

    public String getColumnListSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.indexColumns.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.indexColumns[i].getSQL());
        }
        return stringBuffer.toString();
    }

    public String getCreateSQLForCopy(Table table, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE ");
        stringBuffer.append(this.indexType.getSQL());
        if (!this.indexType.getPrimaryKey()) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        stringBuffer.append(" ON ");
        stringBuffer.append(table.getSQL());
        if (this.comment != null) {
            stringBuffer.append(" COMMENT ");
            stringBuffer.append(StringUtils.quoteStringSQL(this.comment));
        }
        stringBuffer.append("(");
        stringBuffer.append(this.getColumnListSQL());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public IndexColumn[] getIndexColumns() {
        return this.indexColumns;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public int getType() {
        return 1;
    }

    public Table getTable() {
        return this.table;
    }

    public void commit(int n, Row row) {
    }

    void setMultiVersion(boolean bl) {
        this.isMultiVersion = bl;
    }
}

