/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.PageData;
import org.h2.index.PageDataNode;
import org.h2.index.PageScanCursor;
import org.h2.index.PageScanIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.store.DataPageBinary;

class PageDataLeaf
extends PageData {
    int[] offsets;
    Row[] rows;
    int overflowPageId;
    int start;

    PageDataLeaf(PageScanIndex pageScanIndex, int n, int n2, DataPageBinary dataPageBinary) {
        super(pageScanIndex, n, n2, dataPageBinary);
    }

    void read() throws SQLException {
        this.data.setPos(4);
        int n = this.data.readByte();
        this.entryCount = this.data.readShortInt();
        this.offsets = new int[this.entryCount];
        this.keys = new int[this.entryCount];
        this.rows = new Row[this.entryCount];
        if (n == 3) {
            this.overflowPageId = this.data.readInt();
        }
        for (int i = 0; i < this.entryCount; ++i) {
            this.keys[i] = this.data.readInt();
            this.offsets[i] = this.data.readShortInt();
        }
        this.start = this.data.length();
    }

    void write() throws SQLException {
        int n;
        int n2;
        for (n2 = 0; n2 < this.entryCount; ++n2) {
            this.getRowAt(n2);
        }
        this.data.reset();
        this.data.writeInt(this.parentPageId);
        n2 = this.overflowPageId == 0 ? 2 : 3;
        this.data.writeByte((byte)n2);
        this.data.writeShortInt(this.entryCount);
        if (this.overflowPageId != 0) {
            this.data.writeInt(this.overflowPageId);
        }
        for (n = 0; n < this.entryCount; ++n) {
            this.data.writeInt(this.keys[n]);
            this.data.writeShortInt(this.offsets[n]);
        }
        for (n = 0; n < this.entryCount; ++n) {
            this.data.setPos(this.offsets[n]);
            this.rows[n].write(this.data);
        }
        n = this.index.getPageStore().getPageSize();
        if (this.data.length() > n ? this.overflowPageId == 0 : this.overflowPageId != 0) {
            throw Message.getInternalError();
        }
        this.index.getPageStore().writePage(this.pageId, this.data);
    }

    int addRow(Row row) throws SQLException {
        int n;
        int n2 = row.getByteCount(this.data);
        int n3 = this.entryCount == 0 ? this.index.getPageStore().getPageSize() : this.offsets[this.entryCount - 1];
        int n4 = n3 - n2;
        int[] nArray = new int[this.entryCount + 1];
        int[] nArray2 = new int[this.entryCount + 1];
        Row[] rowArray = new Row[this.entryCount + 1];
        if (this.entryCount == 0) {
            n = 0;
        } else {
            n = this.find(row.getPos());
            System.arraycopy(this.offsets, 0, nArray, 0, n);
            System.arraycopy(this.keys, 0, nArray2, 0, n);
            System.arraycopy(this.rows, 0, rowArray, 0, n);
            if (n < this.entryCount) {
                System.arraycopy(this.offsets, n, nArray, n + 1, this.entryCount - n);
                System.arraycopy(this.keys, n, nArray2, n + 1, this.entryCount - n);
                System.arraycopy(this.rows, n, rowArray, n + 1, this.entryCount - n);
            }
        }
        ++this.entryCount;
        this.start += 6;
        nArray[n] = n4;
        nArray2[n] = row.getPos();
        rowArray[n] = row;
        this.offsets = nArray;
        this.keys = nArray2;
        this.rows = rowArray;
        if (n4 < this.start) {
            if (this.entryCount > 0) {
                return this.entryCount / 2;
            }
            n4 = this.start + 6;
            this.overflowPageId = this.index.getPageStore().allocatePage();
        }
        this.write();
        return 0;
    }

    private void removeRow(int n) throws SQLException {
        --this.entryCount;
        if (this.entryCount <= 0) {
            Message.getInternalError();
        }
        int[] nArray = new int[this.entryCount];
        int[] nArray2 = new int[this.entryCount];
        Row[] rowArray = new Row[this.entryCount];
        System.arraycopy(this.offsets, 0, nArray, 0, n);
        System.arraycopy(this.keys, 0, nArray2, 0, n);
        System.arraycopy(this.rows, 0, rowArray, 0, n);
        System.arraycopy(this.offsets, n + 1, nArray, n, this.entryCount - n);
        System.arraycopy(this.keys, n + 1, nArray2, n, this.entryCount - n);
        System.arraycopy(this.rows, n + 1, rowArray, n, this.entryCount - n);
        this.start -= 6;
        this.offsets = nArray;
        this.keys = nArray2;
        this.rows = rowArray;
    }

    Cursor find() {
        return new PageScanCursor(this, 0);
    }

    Row getRowAt(int n) throws SQLException {
        Row row = this.rows[n];
        if (row == null) {
            this.data.setPos(this.offsets[n]);
            row = this.index.readRow(this.data);
            row.setPos(this.keys[n]);
            this.rows[n] = row;
        }
        return row;
    }

    int getEntryCount() {
        return this.entryCount;
    }

    PageData split(int n) throws SQLException {
        int n2 = this.index.getPageStore().allocatePage();
        PageDataLeaf pageDataLeaf = new PageDataLeaf(this.index, n2, this.parentPageId, this.index.getPageStore().createDataPage());
        int n3 = n;
        while (n3 < this.entryCount) {
            pageDataLeaf.addRow(this.getRowAt(n));
            this.removeRow(n);
        }
        return pageDataLeaf;
    }

    int getLastKey() throws SQLException {
        return this.getRowAt(this.entryCount - 1).getPos();
    }

    public PageDataLeaf getNextPage() throws SQLException {
        if (this.parentPageId == 0) {
            return null;
        }
        PageDataNode pageDataNode = (PageDataNode)this.index.getPage(this.parentPageId);
        return pageDataNode.getNextPage(this.keys[this.entryCount - 1]);
    }

    PageDataLeaf getFirstLeaf() {
        return this;
    }

    protected void remapChildren() throws SQLException {
    }

    boolean remove(int n) throws SQLException {
        int n2 = this.find(n);
        if (this.keys[n2] != n) {
            throw Message.getSQLException(90112, this.index.getSQL());
        }
        if (this.entryCount == 1) {
            return true;
        }
        this.removeRow(n2);
        this.write();
        return false;
    }

    Row getRow(Session session, int n) throws SQLException {
        int n2 = this.find(n);
        if (n2 >= this.keys.length) {
            System.out.println("stop");
        }
        return this.getRowAt(n2);
    }
}

