/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileObjectDisk;
import org.h2.store.fs.FileSystem;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;

public class FileSystemDisk
extends FileSystem {
    private static final FileSystemDisk INSTANCE = new FileSystemDisk();
    private static final boolean IS_FILE_SYSTEM_CASE_INSENSITIVE = File.separatorChar == '\\';

    protected FileSystemDisk() {
    }

    public static FileSystemDisk getInstance() {
        return INSTANCE;
    }

    public long length(String string) {
        string = this.translateFileName(string);
        return new File(string).length();
    }

    private String translateFileName(String string) {
        if (string != null && string.startsWith("~")) {
            String string2 = SysProperties.USER_HOME;
            string = string2 + string.substring(1);
        }
        return string;
    }

    public void rename(String string, String string2) throws SQLException {
        string = this.translateFileName(string);
        string2 = this.translateFileName(string2);
        File file = new File(string);
        File file2 = new File(string2);
        if (file.getAbsolutePath().equals(file2.getAbsolutePath())) {
            throw Message.getInternalError("rename file old=new");
        }
        if (!file.exists()) {
            throw Message.getSQLException(90024, new String[]{string + " (not found)", string2});
        }
        if (file2.exists()) {
            throw Message.getSQLException(90024, new String[]{string, string2 + " (exists)"});
        }
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            this.trace("rename", string + " >" + string2, null);
            boolean bl = file.renameTo(file2);
            if (bl) {
                return;
            }
            FileSystemDisk.wait(i);
        }
        throw Message.getSQLException(90024, new String[]{string, string2});
    }

    void trace(String string, String string2, Object object) {
        if (SysProperties.TRACE_IO) {
            System.out.println("FileSystem." + string + " " + string2 + " " + object);
        }
    }

    private static void wait(int n) {
        if (n > 8) {
            System.gc();
        }
        try {
            long l = Math.min(256, n * n);
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean createNewFile(String string) {
        string = this.translateFileName(string);
        File file = new File(string);
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            try {
                return file.createNewFile();
            }
            catch (IOException iOException) {
                FileSystemDisk.wait(i);
                continue;
            }
        }
        return false;
    }

    public boolean exists(String string) {
        string = this.translateFileName(string);
        return new File(string).exists();
    }

    public void delete(String string) throws SQLException {
        File file = new File(string = this.translateFileName(string));
        if (file.exists()) {
            for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
                this.trace("delete", string, null);
                boolean bl = file.delete();
                if (bl) {
                    return;
                }
                FileSystemDisk.wait(i);
            }
            throw Message.getSQLException(90025, string);
        }
    }

    public boolean tryDelete(String string) {
        string = this.translateFileName(string);
        this.trace("tryDelete", string, null);
        return new File(string).delete();
    }

    public String createTempFile(String string, String string2, boolean bl, boolean bl2) throws IOException {
        File file;
        string = this.translateFileName(string);
        string = string + ".";
        String string3 = new File(string).getName();
        if (bl2) {
            file = null;
        } else {
            file = new File(string).getAbsoluteFile().getParentFile();
            file.mkdirs();
        }
        File file2 = File.createTempFile(string3, string2, file);
        if (bl) {
            try {
                file2.deleteOnExit();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return file2.getCanonicalPath();
    }

    public String[] listFiles(String string) throws SQLException {
        string = this.translateFileName(string);
        File file = new File(string);
        try {
            String[] stringArray = file.list();
            if (stringArray == null) {
                return new String[0];
            }
            String string2 = file.getCanonicalPath();
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = string2 + stringArray[i];
            }
            return stringArray;
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, string);
        }
    }

    public void deleteRecursive(String string) throws SQLException {
        if (FileUtils.isDirectory(string = this.translateFileName(string))) {
            String[] stringArray = this.listFiles(string);
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                this.deleteRecursive(stringArray[i]);
            }
        }
        this.delete(string);
    }

    public boolean isReadOnly(String string) {
        File file = new File(string = this.translateFileName(string));
        return file.exists() && !file.canWrite();
    }

    public String normalize(String string) throws SQLException {
        string = this.translateFileName(string);
        File file = new File(string);
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, string);
        }
    }

    public String getParent(String string) {
        string = this.translateFileName(string);
        return new File(string).getParent();
    }

    public boolean isDirectory(String string) {
        string = this.translateFileName(string);
        return new File(string).isDirectory();
    }

    public boolean isAbsolute(String string) {
        string = this.translateFileName(string);
        File file = new File(string);
        return file.isAbsolute();
    }

    public String getAbsolutePath(String string) {
        string = this.translateFileName(string);
        File file = new File(string).getAbsoluteFile();
        return file.getAbsolutePath();
    }

    public long getLastModified(String string) {
        string = this.translateFileName(string);
        return new File(string).lastModified();
    }

    public boolean canWrite(String string) {
        string = this.translateFileName(string);
        return new File(string).canWrite();
    }

    public void copy(String string, String string2) throws SQLException {
        string = this.translateFileName(string);
        string2 = this.translateFileName(string2);
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            int n;
            outputStream = FileUtils.openFileOutputStream(string2, false);
            inputStream = FileUtils.openFileInputStream(string);
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.close();
        }
        catch (IOException iOException) {
            try {
                throw Message.convertIOException(iOException, "original: " + string + " copy: " + string2);
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(inputStream);
                IOUtils.closeSilently(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeSilently(inputStream);
        IOUtils.closeSilently(outputStream);
    }

    public void createDirs(String string) throws SQLException {
        File file = new File(string = this.translateFileName(string));
        if (!file.exists()) {
            String string2 = file.getParent();
            if (string2 == null) {
                return;
            }
            File file2 = new File(string2);
            for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
                if (file2.exists() || file2.mkdirs()) {
                    return;
                }
                FileSystemDisk.wait(i);
            }
            throw Message.getSQLException(90062, string2);
        }
    }

    public String getFileName(String string) throws SQLException {
        String string2;
        string = this.translateFileName(string);
        String string3 = SysProperties.FILE_SEPARATOR;
        String string4 = this.getParent(string);
        if (!string4.endsWith(string3)) {
            string4 = string4 + string3;
        }
        if (!(string2 = this.normalize(string)).startsWith(string4)) {
            throw Message.getInternalError("file utils error: " + string2 + " does not start with " + string4);
        }
        String string5 = string2.substring(string4.length());
        return string5;
    }

    public boolean fileStartsWith(String string, String string2) {
        string = this.translateFileName(string);
        if (IS_FILE_SYSTEM_CASE_INSENSITIVE) {
            string = StringUtils.toUpperEnglish(string);
            string2 = StringUtils.toUpperEnglish(string2);
        }
        return string.startsWith(string2);
    }

    public OutputStream openFileOutputStream(String string, boolean bl) throws SQLException {
        string = this.translateFileName(string);
        try {
            File file = new File(string);
            this.createDirs(file.getAbsolutePath());
            FileOutputStream fileOutputStream = new FileOutputStream(string, bl);
            this.trace("openFileOutputStream", string, fileOutputStream);
            return fileOutputStream;
        }
        catch (IOException iOException) {
            this.freeMemoryAndFinalize();
            try {
                return new FileOutputStream(string);
            }
            catch (IOException iOException2) {
                throw Message.convertIOException(iOException, string);
            }
        }
    }

    public InputStream openFileInputStream(String string) throws IOException {
        if (string.indexOf(58) > 1) {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            return inputStream;
        }
        string = this.translateFileName(string);
        FileInputStream fileInputStream = new FileInputStream(string);
        this.trace("openFileInputStream", string, fileInputStream);
        return fileInputStream;
    }

    private void freeMemoryAndFinalize() {
        this.trace("freeMemoryAndFinalize", null, null);
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        for (int i = 0; i < 16; ++i) {
            runtime.gc();
            long l2 = runtime.freeMemory();
            runtime.runFinalization();
            if (l2 == l) break;
            l = l2;
        }
    }

    public FileObject openFileObject(String string, String string2) throws IOException {
        FileObjectDisk fileObjectDisk;
        string = this.translateFileName(string);
        try {
            fileObjectDisk = new FileObjectDisk(string, string2);
            this.trace("openRandomAccessFile", string, fileObjectDisk);
        }
        catch (IOException iOException) {
            this.freeMemoryAndFinalize();
            try {
                fileObjectDisk = new FileObjectDisk(string, string2);
            }
            catch (IOException iOException2) {
                iOException2.initCause(iOException);
                throw iOException2;
            }
        }
        return fileObjectDisk;
    }
}

