/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.BtreeCursor;
import org.h2.index.BtreeIndex;
import org.h2.index.BtreePage;
import org.h2.index.BtreePosition;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.DataPage;
import org.h2.table.Column;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

public class BtreeLeaf
extends BtreePage {
    private boolean writePos;
    private int cachedRealByteCount;

    BtreeLeaf(BtreeIndex btreeIndex, Session session, DataPage dataPage) throws SQLException {
        super(btreeIndex);
        boolean bl = this.writePos = dataPage.readByte() == 80;
        if (this.writePos) {
            int n = dataPage.readInt();
            this.pageData = new ObjectArray(n);
            for (int i = 0; i < n; ++i) {
                Row row = btreeIndex.getRow(session, dataPage.readInt());
                this.pageData.add(row);
            }
        } else {
            this.pageData = btreeIndex.readRowArray(dataPage);
        }
    }

    BtreeLeaf(BtreeIndex btreeIndex, ObjectArray objectArray) {
        super(btreeIndex);
        this.pageData = objectArray;
    }

    int add(Row row, Session session) throws SQLException {
        int n;
        SearchRow searchRow;
        int n2;
        int n3 = 0;
        int n4 = this.pageData.size();
        while (n3 < n4) {
            n2 = n3 + n4 >>> 1;
            searchRow = (SearchRow)this.pageData.get(n2);
            n = this.index.compareRows(searchRow, row);
            if (n == 0) {
                if (this.index.indexType.isUnique() && !this.index.isNull(row)) {
                    throw this.index.getDuplicateKeyException();
                }
                n = this.index.compareKeys(searchRow, row);
            }
            if (n > 0) {
                n4 = n2;
                continue;
            }
            n3 = n2 + 1;
        }
        this.index.deletePage(session, this);
        n2 = n3;
        searchRow = this.index.getSearchRow(row);
        this.pageData.add(n2, searchRow);
        this.updateRealByteCount(true, row);
        n = this.getSplitPoint();
        if (n == 0) {
            this.index.updatePage(session, this);
        }
        return n;
    }

    SearchRow remove(Session session, Row row) throws SQLException {
        int n = 0;
        int n2 = this.pageData.size();
        if (n2 == 0) {
            // empty if block
        }
        while (n < n2) {
            int n3 = n + n2 >>> 1;
            SearchRow searchRow = (SearchRow)this.pageData.get(n3);
            if (SysProperties.CHECK && searchRow == null) {
                throw Message.getInternalError("btree corrupt");
            }
            int n4 = this.index.compareRows(searchRow, row);
            if (n4 == 0) {
                n4 = this.index.compareKeys(searchRow, row);
            }
            if (n4 == 0) {
                this.index.deletePage(session, this);
                if (this.pageData.size() == 1 && !this.root) {
                    return row;
                }
                this.pageData.remove(n3);
                this.updateRealByteCount(false, searchRow);
                this.index.updatePage(session, this);
                if (n3 > 0) {
                    return null;
                }
                if (this.pageData.size() == 0) {
                    return null;
                }
                return this.getData(0);
            }
            if (n4 > 0) {
                n2 = n3;
                continue;
            }
            n = n3 + 1;
        }
        throw Message.getSQLException(90112, this.index.getSQL());
    }

    BtreePage split(Session session, int n) throws SQLException {
        ObjectArray objectArray = new ObjectArray();
        int n2 = this.pageData.size();
        for (int i = n; i < n2; ++i) {
            objectArray.add(this.getData(n));
            this.pageData.remove(n);
        }
        this.cachedRealByteCount = 0;
        BtreeLeaf btreeLeaf = new BtreeLeaf(this.index, objectArray);
        this.index.updatePage(session, this);
        this.index.addPage(session, btreeLeaf);
        return btreeLeaf;
    }

    boolean findFirst(BtreeCursor btreeCursor, SearchRow searchRow, boolean bl) throws SQLException {
        int n = 0;
        int n2 = this.pageData.size();
        if (n2 == 0) {
            // empty if block
        }
        while (n < n2) {
            int n3 = n + n2 >>> 1;
            SearchRow searchRow2 = (SearchRow)this.pageData.get(n3);
            int n4 = this.index.compareRows(searchRow2, searchRow);
            if (n4 > 0 || !bl && n4 == 0) {
                n2 = n3;
                continue;
            }
            n = n3 + 1;
        }
        if (n >= this.pageData.size()) {
            return false;
        }
        btreeCursor.push(this, n);
        SearchRow searchRow3 = (SearchRow)this.pageData.get(n);
        btreeCursor.setCurrentRow(searchRow3);
        return true;
    }

    void next(BtreeCursor btreeCursor, int n) throws SQLException {
        if (++n < this.pageData.size()) {
            SearchRow searchRow = (SearchRow)this.pageData.get(n);
            btreeCursor.setCurrentRow(searchRow);
            btreeCursor.setStackPosition(n);
            return;
        }
        btreeCursor.pop();
        this.nextUpper(btreeCursor);
    }

    void previous(BtreeCursor btreeCursor, int n) throws SQLException {
        if (--n >= 0) {
            SearchRow searchRow = (SearchRow)this.pageData.get(n);
            btreeCursor.setCurrentRow(searchRow);
            btreeCursor.setStackPosition(n);
            return;
        }
        btreeCursor.pop();
        this.previousUpper(btreeCursor);
    }

    void first(BtreeCursor btreeCursor) throws SQLException {
        if (this.pageData.size() == 0) {
            this.nextUpper(btreeCursor);
            return;
        }
        btreeCursor.push(this, 0);
        SearchRow searchRow = (SearchRow)this.pageData.get(0);
        btreeCursor.setCurrentRow(searchRow);
    }

    void last(BtreeCursor btreeCursor) throws SQLException {
        int n = this.pageData.size() - 1;
        if (n < 0) {
            this.previousUpper(btreeCursor);
            return;
        }
        btreeCursor.push(this, n);
        SearchRow searchRow = (SearchRow)this.pageData.get(n);
        btreeCursor.setCurrentRow(searchRow);
    }

    private void nextUpper(BtreeCursor btreeCursor) throws SQLException {
        BtreePosition btreePosition = btreeCursor.pop();
        if (btreePosition == null) {
            btreeCursor.setCurrentRow(null);
        } else {
            btreeCursor.push(btreePosition.page, btreePosition.position);
            btreePosition.page.next(btreeCursor, btreePosition.position);
        }
    }

    private void previousUpper(BtreeCursor btreeCursor) throws SQLException {
        BtreePosition btreePosition = btreeCursor.pop();
        if (btreePosition == null) {
            btreeCursor.setCurrentRow(null);
        } else {
            btreeCursor.push(btreePosition.page, btreePosition.position);
            btreePosition.page.previous(btreeCursor, btreePosition.position);
        }
    }

    public void prepareWrite() throws SQLException {
        this.writePos = this.getRealByteCount() >= 1024;
    }

    public void write(DataPage dataPage) throws SQLException {
        dataPage.writeByte((byte)76);
        int n = this.pageData.size();
        if (this.writePos) {
            dataPage.writeByte((byte)80);
        } else {
            dataPage.writeByte((byte)68);
        }
        dataPage.writeInt(n);
        Column[] columnArray = this.index.getColumns();
        for (int i = 0; i < n; ++i) {
            SearchRow searchRow = (SearchRow)this.pageData.get(i);
            dataPage.writeInt(searchRow.getPos());
            if (this.writePos) continue;
            for (int j = 0; j < columnArray.length; ++j) {
                Value value = searchRow.getValue(columnArray[j].getColumnId());
                dataPage.writeValue(value);
            }
        }
    }

    private void updateRealByteCount(boolean bl, SearchRow searchRow) throws SQLException {
        if (this.cachedRealByteCount == 0) {
            return;
        }
        DataPage dataPage = this.index.getDatabase().getDataPage();
        int n = this.getRowSize(dataPage, searchRow) + dataPage.getIntLen();
        this.cachedRealByteCount += bl ? n : -n;
        if (this.cachedRealByteCount + this.index.getRecordOverhead() >= 1024) {
            this.cachedRealByteCount = 0;
        }
    }

    int getRealByteCount() throws SQLException {
        DataPage dataPage = this.index.getDatabase().getDataPage();
        int n = this.pageData.size();
        int n2 = 2 + dataPage.getIntLen() * (n + 1);
        for (int i = 0; i < n; ++i) {
            SearchRow searchRow = (SearchRow)this.pageData.get(i);
            n2 += this.getRowSize(dataPage, searchRow);
        }
        this.cachedRealByteCount = n2 += this.index.getRecordOverhead();
        return n2;
    }

    SearchRow getFirst(Session session) {
        if (this.pageData.size() == 0) {
            return null;
        }
        return (SearchRow)this.pageData.get(0);
    }
}

