/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.FunctionCall;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;

public class JavaFunction
extends Expression
implements FunctionCall {
    private FunctionAlias functionAlias;
    private Expression[] args;

    public JavaFunction(FunctionAlias functionAlias, Expression[] expressionArray) {
        this.functionAlias = functionAlias;
        this.args = expressionArray;
    }

    public Value getValue(Session session) throws SQLException {
        return this.functionAlias.getValue(session, this.args, false);
    }

    public int getType() {
        return this.functionAlias.getDataType();
    }

    public void mapColumns(ColumnResolver columnResolver, int n) throws SQLException {
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i].mapColumns(columnResolver, n);
        }
    }

    public Expression optimize(Session session) throws SQLException {
        for (int i = 0; i < this.args.length; ++i) {
            Expression expression;
            this.args[i] = expression = this.args[i].optimize(session);
        }
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (int i = 0; i < this.args.length; ++i) {
            Expression expression = this.args[i];
            if (expression == null) continue;
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    public int getScale() {
        return 0;
    }

    public long getPrecision() {
        return Integer.MAX_VALUE;
    }

    public int getDisplaySize() {
        return Integer.MAX_VALUE;
    }

    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Parser.quoteIdentifier(this.functionAlias.getName()));
        stringBuffer.append('(');
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            Expression expression = this.args[i];
            stringBuffer.append(expression.getSQL());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public void updateAggregate(Session session) throws SQLException {
        for (int i = 0; i < this.args.length; ++i) {
            Expression expression = this.args[i];
            if (expression == null) continue;
            expression.updateAggregate(session);
        }
    }

    public String getName() {
        return this.functionAlias.getName();
    }

    public int getParameterCount() throws SQLException {
        return this.functionAlias.getParameterCount();
    }

    public ValueResultSet getValueForColumnList(Session session, Expression[] expressionArray) throws SQLException {
        Value value = this.functionAlias.getValue(session, expressionArray, true);
        return value == ValueNull.INSTANCE ? null : (ValueResultSet)value;
    }

    public Expression[] getArgs() {
        return this.args;
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 2: {
                return false;
            }
            case 7: {
                expressionVisitor.addDependency(this.functionAlias);
                break;
            }
        }
        for (int i = 0; i < this.args.length; ++i) {
            Expression expression = this.args[i];
            if (expression == null || expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return true;
    }

    public int getCost() {
        int n = this.functionAlias.hasConnectionParam() ? 25 : 5;
        for (int i = 0; i < this.args.length; ++i) {
            n += this.args[i].getCost();
        }
        return n;
    }
}

