/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueArray;

public class ExpressionList
extends Expression {
    private Expression[] list;

    public ExpressionList(Expression[] expressionArray) {
        this.list = expressionArray;
    }

    public Value getValue(Session session) throws SQLException {
        Value[] valueArray = new Value[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            valueArray[i] = this.list[i].getValue(session);
        }
        return ValueArray.get(valueArray);
    }

    public int getType() {
        return 17;
    }

    public void mapColumns(ColumnResolver columnResolver, int n) throws SQLException {
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i].mapColumns(columnResolver, n);
        }
    }

    public Expression optimize(Session session) throws SQLException {
        boolean bl = true;
        for (int i = 0; i < this.list.length; ++i) {
            Expression expression = this.list[i].optimize(session);
            if (!expression.isConstant()) {
                bl = false;
            }
            this.list[i] = expression;
        }
        if (bl) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i].setEvaluatable(tableFilter, bl);
        }
    }

    public int getScale() {
        return 0;
    }

    public long getPrecision() {
        return Integer.MAX_VALUE;
    }

    public int getDisplaySize() {
        return Integer.MAX_VALUE;
    }

    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i < this.list.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.list[i].getSQL());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public void updateAggregate(Session session) throws SQLException {
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i].updateAggregate(session);
        }
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i].isEverything(expressionVisitor)) continue;
            return false;
        }
        return true;
    }

    public int getCost() {
        int n = 1;
        for (int i = 0; i < this.list.length; ++i) {
            n += this.list[i].getCost();
        }
        return n;
    }
}

