/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.h2.Driver;
import org.h2.engine.Constants;
import org.h2.server.web.ConnectionInfo;
import org.h2.util.ClassUtils;
import org.h2.util.FileUtils;
import org.h2.util.JdbcDriverUtils;
import org.h2.util.JdbcUtils;

public class Shell {
    private Connection conn;
    private Statement stat;
    private PrintStream out = System.out;
    private boolean listMode;
    private int maxColumnSize = 100;
    private char boxVertical = (char)124;
    static /* synthetic */ Class class$java$lang$System;

    public static void main(String[] stringArray) throws SQLException {
        new Shell().run(stringArray);
    }

    private void showUsage() {
        this.out.println("An interactive command line database tool.");
        this.out.println("java " + this.getClass().getName() + "\n" + " [-url <url>]       The database URL\n" + " [-user <user>]     The user name\n" + " [-password <pwd>]  The password\n" + " [-driver <class>]  The JDBC driver class to use (not required in most cases)");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    private void run(String[] stringArray) throws SQLException {
        String string = null;
        String string2 = "";
        String string3 = "";
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (stringArray[i].equals("-url")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-user")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-password")) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-driver")) {
                String string4 = stringArray[++i];
                ClassUtils.loadUserClass(string4);
                continue;
            }
            this.out.println("Unsupported option: " + stringArray[i]);
            this.showUsage();
            return;
        }
        if (string != null) {
            Driver.load();
            this.conn = DriverManager.getConnection(string, string2, string3);
            this.stat = this.conn.createStatement();
        }
        this.promptLoop();
    }

    private void showHelp() {
        this.out.println("Commands are case insensitive; SQL statements end with ';'");
        this.out.println("help or ?      Display this help");
        this.out.println("list           Toggle result list mode");
        this.out.println("maxwidth       Set maximum column width (default is 100)");
        this.out.println("show           List all tables");
        this.out.println("describe       Describe a table");
        this.out.println("quit or exit   Close the connection and exit");
        this.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promptLoop() {
        this.out.println();
        this.out.println("Welcome to H2 Shell " + Constants.getFullVersion());
        this.out.println("Exit with Ctrl+C");
        if (this.conn != null) {
            this.showHelp();
        }
        String string = null;
        block17: while (true) {
            try {
                while (true) {
                    Object object;
                    String string2;
                    if (this.conn == null) {
                        this.connect();
                        this.showHelp();
                    }
                    if (string == null) {
                        this.out.print("sql> ");
                    } else {
                        this.out.print("...> ");
                    }
                    String string3 = this.readLine();
                    if (string3 == null) break block17;
                    if ((string3 = string3.trim()).length() == 0) continue;
                    boolean bl = string3.endsWith(";");
                    if (bl) {
                        string3 = string3.substring(0, string3.length() - 1).trim();
                    }
                    if ("EXIT".equals(string2 = string3.toUpperCase()) || "QUIT".equals(string2)) break block17;
                    if ("HELP".equals(string2) || "?".equals(string2)) {
                        this.showHelp();
                        continue;
                    }
                    if ("LIST".equals(string2)) {
                        this.listMode = !this.listMode;
                        this.out.println("Result list mode is now " + (this.listMode ? "on" : "off"));
                        continue;
                    }
                    if (string2.startsWith("DESCRIBE")) {
                        object = string2.substring("DESCRIBE".length()).trim();
                        if (((String)object).length() == 0) {
                            this.out.println("Usage: describe [<schema name>.]<table name>");
                            continue;
                        }
                        String string4 = null;
                        int n = ((String)object).indexOf(46);
                        if (n >= 0) {
                            string4 = ((String)object).substring(0, n);
                            object = ((String)object).substring(n + 1);
                        }
                        PreparedStatement preparedStatement = null;
                        ResultSet resultSet = null;
                        try {
                            String string5 = "SELECT CAST(COLUMN_NAME AS VARCHAR(32)) \"Column Name\", CAST(TYPE_NAME AS VARCHAR(14)) \"Type\", NUMERIC_PRECISION \"Precision\", CAST(IS_NULLABLE AS VARCHAR(8)) \"Nullable\", CAST(COLUMN_DEFAULT AS VARCHAR(20)) \"Default\" FROM INFORMATION_SCHEMA.COLUMNS WHERE UPPER(TABLE_NAME)=?";
                            if (string4 != null) {
                                string5 = string5 + " AND UPPER(TABLE_SCHEMA)=?";
                            }
                            string5 = string5 + " ORDER BY ORDINAL_POSITION";
                            preparedStatement = this.conn.prepareStatement(string5);
                            preparedStatement.setString(1, ((String)object).toUpperCase());
                            if (string4 != null) {
                                preparedStatement.setString(2, string4.toUpperCase());
                            }
                            resultSet = preparedStatement.executeQuery();
                            this.printResult(resultSet, false);
                        }
                        catch (SQLException sQLException) {
                            try {
                                this.out.println("Exception: " + sQLException.toString());
                                sQLException.printStackTrace();
                            }
                            catch (Throwable throwable) {
                                JdbcUtils.closeSilently(resultSet);
                                JdbcUtils.closeSilently(preparedStatement);
                                throw throwable;
                            }
                            JdbcUtils.closeSilently(resultSet);
                            JdbcUtils.closeSilently(preparedStatement);
                            continue;
                        }
                        JdbcUtils.closeSilently(resultSet);
                        JdbcUtils.closeSilently(preparedStatement);
                        continue;
                    }
                    if (string2.startsWith("SHOW")) {
                        object = null;
                        try {
                            object = this.stat.executeQuery("SELECT CAST(TABLE_SCHEMA AS VARCHAR(32)) \"Schema\", TABLE_NAME \"Table Name\" FROM INFORMATION_SCHEMA.TABLES ORDER BY TABLE_SCHEMA, TABLE_NAME");
                            this.printResult((ResultSet)object, false);
                        }
                        catch (SQLException sQLException) {
                            this.out.println("Exception: " + sQLException.toString());
                            sQLException.printStackTrace();
                        }
                        finally {
                            JdbcUtils.closeSilently((ResultSet)object);
                        }
                        continue;
                    }
                    if (string2.startsWith("MAXWIDTH")) {
                        string2 = string2.substring("MAXWIDTH".length()).trim();
                        try {
                            this.maxColumnSize = Integer.parseInt(string2);
                        }
                        catch (Exception exception) {
                            this.out.println("Usage: maxwidth <integer value>");
                        }
                        this.out.println("Maximum column width is now " + this.maxColumnSize);
                        continue;
                    }
                    string = string == null ? string3 : string + " " + string3;
                    if (!bl) continue;
                    this.execute(string, this.listMode);
                    string = null;
                }
            }
            catch (SQLException sQLException) {
                this.out.println("SQL Exception: " + sQLException.getMessage());
                string = null;
                continue;
            }
            catch (IOException iOException) {
                this.out.println(iOException.getMessage());
            }
            catch (Exception exception) {
                this.out.println("Exception: " + exception.toString());
                exception.printStackTrace();
            }
            break;
        }
        if (this.conn != null) {
            try {
                this.conn.close();
                this.out.println("Connection closed");
            }
            catch (SQLException sQLException) {
                this.out.println("SQL Exception:");
                sQLException.printStackTrace();
            }
        }
    }

    private void connect() throws IOException, SQLException {
        Object object;
        String string = FileUtils.getFileInUserHome(".h2.server.properties");
        String string2 = "jdbc:h2:~/test";
        String string3 = "sa";
        String string4 = null;
        try {
            String string5;
            object = FileUtils.loadProperties(string);
            String string6 = null;
            int n = 0;
            while ((string5 = ((Properties)object).getProperty(String.valueOf(n))) != null) {
                string6 = string5;
                ++n;
            }
            if (string6 != null) {
                ConnectionInfo connectionInfo = new ConnectionInfo(string6);
                string2 = connectionInfo.url;
                string3 = connectionInfo.user;
                string4 = connectionInfo.driver;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.out.println("[Enter]   " + string2);
        this.out.print("URL       ");
        string2 = this.readLine(string2);
        if (string4 == null) {
            string4 = JdbcDriverUtils.getDriver(string2);
        }
        if (string4 != null) {
            this.out.println("[Enter]   " + string4);
        }
        this.out.print("Driver    ");
        string4 = this.readLine(string4);
        this.out.println("[Enter]   " + string3);
        this.out.print("User      ");
        string3 = this.readLine(string3);
        this.out.println("[Enter]   Hide");
        this.out.print("Password  ");
        object = this.readLine();
        if (((String)object).length() == 0) {
            object = this.readPassword();
        }
        this.conn = JdbcUtils.getConnection(string4, string2, string3, (String)object);
        this.stat = this.conn.createStatement();
        this.out.println("Connected");
    }

    private String readPassword() throws IOException {
        try {
            Method method = (class$java$lang$System == null ? (class$java$lang$System = Shell.class$("java.lang.System")) : class$java$lang$System).getMethod("console", new Class[0]);
            Object object = method.invoke(null, (Object[])null);
            Method method2 = object.getClass().getMethod("readPassword", new Class[0]);
            System.out.print("Password  ");
            char[] cArray = (char[])method2.invoke(object, (Object[])null);
            return cArray == null ? null : new String(cArray);
        }
        catch (Throwable throwable) {
            class PasswordHider
            extends Thread {
                volatile boolean stop;

                PasswordHider() {
                }

                public void run() {
                    while (!this.stop) {
                        Shell.this.out.print("\b\b><");
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            PasswordHider passwordHider = new PasswordHider();
            passwordHider.start();
            this.out.print("Password  > ");
            String string = this.readLine();
            passwordHider.stop = true;
            try {
                passwordHider.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.out.print("\b\b");
            return string;
        }
    }

    private String readLine(String string) throws IOException {
        String string2 = this.readLine();
        return string2.length() == 0 ? string : string2;
    }

    private String readLine() throws IOException {
        String string = new BufferedReader(new InputStreamReader(System.in)).readLine();
        if (string == null) {
            throw new IOException("Aborted");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String string, boolean bl) throws SQLException {
        ResultSet resultSet;
        block7: {
            boolean bl2;
            long l = System.currentTimeMillis();
            try {
                bl2 = this.stat.execute(string);
            }
            catch (SQLException sQLException) {
                this.out.println("Error: " + sQLException.toString());
                return;
            }
            resultSet = null;
            try {
                if (bl2) {
                    resultSet = this.stat.getResultSet();
                    int n = this.printResult(resultSet, bl);
                    l = System.currentTimeMillis() - l;
                    this.out.println("(" + n + (n == 1 ? " row, " : " rows, ") + l + " ms)");
                    break block7;
                }
                int n = this.stat.getUpdateCount();
                l = System.currentTimeMillis() - l;
                this.out.println("(Update count: " + n + ", " + l + " ms)");
            }
            catch (SQLException sQLException) {
                try {
                    this.out.println("Error: " + sQLException.toString());
                    sQLException.printStackTrace();
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeSilently(resultSet);
                    throw throwable;
                }
                JdbcUtils.closeSilently(resultSet);
            }
        }
        JdbcUtils.closeSilently(resultSet);
    }

    private int printResult(ResultSet resultSet, boolean bl) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = 0;
        int n2 = resultSetMetaData.getColumnCount();
        String[] stringArray = new String[n2];
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            String string = resultSetMetaData.getColumnLabel(i + 1);
            int n4 = string.length();
            if (!bl) {
                n4 = Math.max(n4, resultSetMetaData.getColumnDisplaySize(i + 1));
                n4 = Math.min(this.maxColumnSize, n4);
            }
            if (string.length() > n4) {
                string = string.substring(0, n4);
            }
            stringArray[i] = string;
            nArray[i] = n4;
            n = Math.max(n, n4);
            n3 += n4;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            for (int i = 0; i < n2; ++i) {
                if (i > 0) {
                    stringBuffer.append(this.boxVertical);
                }
                String string = stringArray[i];
                stringBuffer.append(string);
                if (i >= n2 - 1) continue;
                for (int j = string.length(); j < nArray[i]; ++j) {
                    stringBuffer.append(' ');
                }
            }
            this.out.println(stringBuffer.toString());
        }
        int n5 = 0;
        while (resultSet.next()) {
            int n6;
            int n7;
            ++n5;
            stringBuffer.setLength(0);
            if (bl) {
                if (n5 > 1) {
                    this.out.println();
                }
                for (n7 = 0; n7 < n2; ++n7) {
                    if (n7 > 0) {
                        stringBuffer.append('\n');
                    }
                    String string = stringArray[n7];
                    stringBuffer.append(string);
                    for (n6 = string.length(); n6 < n; ++n6) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(": ");
                    stringBuffer.append(resultSet.getString(n7 + 1));
                }
            } else {
                for (n7 = 0; n7 < n2; ++n7) {
                    String string;
                    if (n7 > 0) {
                        stringBuffer.append(this.boxVertical);
                    }
                    if ((string = resultSet.getString(n7 + 1)) == null) {
                        string = "null";
                    }
                    n6 = nArray[n7];
                    if (!bl && string.length() > n6) {
                        string = string.substring(0, n6);
                    }
                    stringBuffer.append(string);
                    if (n7 >= n2 - 1) continue;
                    for (int i = string.length(); i < n6; ++i) {
                        stringBuffer.append(' ');
                    }
                }
            }
            this.out.println(stringBuffer.toString());
        }
        if (n5 == 0 && bl) {
            for (int i = 0; i < n2; ++i) {
                String string = stringArray[i];
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
            this.out.println(stringBuffer.toString());
        }
        return n5;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

