/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.h2.Driver;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbcx.JdbcDataSourceFactory;
import org.h2.jdbcx.JdbcXAConnection;
import org.h2.message.TraceObject;

public class JdbcDataSource
extends TraceObject
implements XADataSource,
DataSource,
ConnectionPoolDataSource,
Serializable,
Referenceable {
    private static final long serialVersionUID = 1288136338451857771L;
    private transient JdbcDataSourceFactory factory;
    private transient PrintWriter logWriter;
    private int loginTimeout;
    private String user = "";
    private String password = "";
    private String url = "";
    static /* synthetic */ Class class$org$h2$jdbcx$JdbcDataSourceFactory;

    public JdbcDataSource() {
        this.initFactory();
        int n = this.getNextId(12);
        this.setTrace(this.factory.getTrace(), 12, n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.initFactory();
        objectInputStream.defaultReadObject();
    }

    private void initFactory() {
        this.factory = new JdbcDataSourceFactory();
    }

    public int getLoginTimeout() throws SQLException {
        this.debugCodeCall("getLoginTimeout");
        return this.loginTimeout;
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.debugCodeCall("setLoginTimeout", n);
        this.loginTimeout = n;
    }

    public PrintWriter getLogWriter() throws SQLException {
        this.debugCodeCall("getLogWriter");
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.debugCodeCall("setLogWriter(out)");
        this.logWriter = printWriter;
    }

    public Connection getConnection() throws SQLException {
        this.debugCodeCall("getConnection");
        return this.getJdbcConnection(this.user, this.password);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("getConnection(" + this.quote(string) + ", " + this.quote(string2) + ");");
        }
        return this.getJdbcConnection(string, string2);
    }

    private JdbcConnection getJdbcConnection(String string, String string2) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("getJdbcConnection(" + this.quote(string) + ", " + this.quote(string2) + ");");
        }
        Properties properties = new Properties();
        properties.setProperty("user", string);
        properties.setProperty("password", string2);
        return new JdbcConnection(this.url, properties);
    }

    public String getURL() {
        this.debugCodeCall("getURL");
        return this.url;
    }

    public void setURL(String string) {
        this.debugCodeCall("setURL", string);
        this.url = string;
    }

    public void setPassword(String string) {
        this.debugCodeCall("setPassword", string);
        this.password = string;
    }

    public String getPassword() {
        this.debugCodeCall("getPassword");
        return this.password;
    }

    public String getUser() {
        this.debugCodeCall("getUser");
        return this.user;
    }

    public void setUser(String string) {
        this.debugCodeCall("setUser", string);
        this.user = string;
    }

    public Reference getReference() throws NamingException {
        this.debugCodeCall("getReference");
        String string = (class$org$h2$jdbcx$JdbcDataSourceFactory == null ? (class$org$h2$jdbcx$JdbcDataSourceFactory = JdbcDataSource.class$("org.h2.jdbcx.JdbcDataSourceFactory")) : class$org$h2$jdbcx$JdbcDataSourceFactory).getName();
        Reference reference = new Reference(this.getClass().getName(), string, null);
        reference.add(new StringRefAddr("url", this.url));
        reference.add(new StringRefAddr("user", this.user));
        reference.add(new StringRefAddr("password", this.password));
        reference.add(new StringRefAddr("loginTimeout", String.valueOf(this.loginTimeout)));
        return reference;
    }

    public XAConnection getXAConnection() throws SQLException {
        this.debugCodeCall("getXAConnection");
        int n = this.getNextId(13);
        return new JdbcXAConnection(this.factory, n, this.url, this.user, this.password);
    }

    public XAConnection getXAConnection(String string, String string2) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("getXAConnection(" + this.quote(string) + ", " + this.quote(string2) + ");");
        }
        int n = this.getNextId(13);
        return new JdbcXAConnection(this.factory, n, this.url, string, string2);
    }

    public PooledConnection getPooledConnection() throws SQLException {
        this.debugCodeCall("getPooledConnection");
        return this.getXAConnection();
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("getPooledConnection(" + this.quote(string) + ", " + this.quote(string2) + ");");
        }
        return this.getXAConnection(string, string2);
    }

    public String toString() {
        return this.getTraceObjectName() + ": url=" + this.url + " user=" + this.user;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Driver.load();
    }
}

