/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.h2.command.CommandInterface;
import org.h2.constant.SysProperties;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcResultSet;
import org.h2.message.Message;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.util.ObjectArray;

public class JdbcStatement
extends TraceObject
implements Statement {
    protected JdbcConnection conn;
    protected SessionInterface session;
    protected JdbcResultSet resultSet;
    protected int maxRows;
    protected boolean escapeProcessing = true;
    protected int fetchSize = SysProperties.SERVER_RESULT_SET_FETCH_SIZE;
    protected int updateCount;
    private CommandInterface executingCommand;
    private ObjectArray batchCommands;
    protected int resultSetType;
    protected boolean closedByResultSet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String string) throws SQLException {
        try {
            int n = this.getNextId(4);
            if (this.debug()) {
                this.debugCodeAssign("ResultSet", 4, n, "executeQuery(" + this.quote(string) + ")");
            }
            this.checkClosed();
            this.closeOld();
            if (this.escapeProcessing) {
                string = this.conn.translateSQL(string);
            }
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                ResultInterface resultInterface;
                CommandInterface commandInterface = this.conn.prepareCommand(string, this.fetchSize);
                boolean bl = this.resultSetType != 1003;
                this.setExecutingStatement(commandInterface);
                try {
                    resultInterface = commandInterface.executeQuery(this.maxRows, bl);
                }
                finally {
                    this.setExecutingStatement(null);
                }
                commandInterface.close();
                this.resultSet = new JdbcResultSet(this.session, this.conn, this, resultInterface, n, this.closedByResultSet, bl);
            }
            return this.resultSet;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string) throws SQLException {
        try {
            this.debugCodeCall("executeUpdate", string);
            this.checkClosed();
            this.closeOld();
            if (this.escapeProcessing) {
                string = this.conn.translateSQL(string);
            }
            CommandInterface commandInterface = this.conn.prepareCommand(string, this.fetchSize);
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                this.setExecutingStatement(commandInterface);
                try {
                    this.updateCount = commandInterface.executeUpdate();
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            commandInterface.close();
            return this.updateCount;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string) throws SQLException {
        try {
            boolean bl;
            int n = this.getNextId(4);
            if (this.debug()) {
                this.debugCodeCall("execute", string);
            }
            this.checkClosed();
            this.closeOld();
            if (this.escapeProcessing) {
                string = this.conn.translateSQL(string);
            }
            CommandInterface commandInterface = this.conn.prepareCommand(string, this.fetchSize);
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                this.setExecutingStatement(commandInterface);
                try {
                    if (commandInterface.isQuery()) {
                        bl = true;
                        boolean bl2 = this.resultSetType != 1003;
                        ResultInterface resultInterface = commandInterface.executeQuery(this.maxRows, bl2);
                        this.resultSet = new JdbcResultSet(this.session, this.conn, this, resultInterface, n, this.closedByResultSet, bl2);
                    } else {
                        bl = false;
                        this.updateCount = commandInterface.executeUpdate();
                    }
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            commandInterface.close();
            return bl;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            this.checkClosed();
            if (this.resultSet != null) {
                int n = this.resultSet.getTraceId();
                this.debugCodeAssign("ResultSet", 4, n, "getResultSet()");
            } else {
                this.debugCodeCall("getResultSet");
            }
            return this.resultSet;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int getUpdateCount() throws SQLException {
        try {
            this.debugCodeCall("getUpdateCount");
            this.checkClosed();
            return this.updateCount;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            this.closeOld();
            if (this.conn != null) {
                this.conn = null;
            }
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            this.debugCodeCall("getConnection");
            this.checkClosed();
            return this.conn;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public boolean getMoreResults() throws SQLException {
        try {
            this.debugCodeCall("getMoreResults");
            this.checkClosed();
            this.closeOld();
            return false;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setCursorName(String string) throws SQLException {
        try {
            this.debugCodeCall("setCursorName", string);
            this.checkClosed();
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        try {
            this.debugCodeCall("setFetchDirection", n);
            this.checkClosed();
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            this.debugCodeCall("getFetchDirection");
            this.checkClosed();
            return 1000;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            this.debugCodeCall("getMaxRows");
            this.checkClosed();
            return this.maxRows;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setMaxRows(int n) throws SQLException {
        try {
            this.debugCodeCall("setMaxRows", n);
            this.checkClosed();
            if (n < 0) {
                throw Message.getInvalidValueException("" + n, "maxRows");
            }
            this.maxRows = n;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setFetchSize(int n) throws SQLException {
        try {
            this.debugCodeCall("setFetchSize", n);
            this.checkClosed();
            if (n < 0 || n > 0 && this.maxRows > 0 && n > this.maxRows) {
                throw Message.getInvalidValueException("" + n, "rows");
            }
            if (n == 0) {
                n = SysProperties.SERVER_RESULT_SET_FETCH_SIZE;
            }
            this.fetchSize = n;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            this.debugCodeCall("getFetchSize");
            this.checkClosed();
            return this.fetchSize;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            this.debugCodeCall("getResultSetConcurrency");
            this.checkClosed();
            return 1008;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            this.debugCodeCall("getResultSetType");
            this.checkClosed();
            return this.resultSetType;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            this.debugCodeCall("getMaxFieldSize");
            this.checkClosed();
            return 0;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setMaxFieldSize(int n) throws SQLException {
        try {
            this.debugCodeCall("setMaxFieldSize", n);
            this.checkClosed();
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setEscapeProcessing(" + bl + ");");
            }
            this.checkClosed();
            this.escapeProcessing = bl;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws SQLException {
        try {
            this.debugCodeCall("cancel");
            this.checkClosed();
            CommandInterface commandInterface = this.executingCommand;
            try {
                if (commandInterface != null) {
                    commandInterface.cancel();
                }
            }
            finally {
                this.setExecutingStatement(null);
            }
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            this.debugCodeCall("getQueryTimeout");
            this.checkClosed();
            return this.conn.getQueryTimeout();
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        try {
            this.debugCodeCall("setQueryTimeout", n);
            this.checkClosed();
            if (n < 0) {
                throw Message.getInvalidValueException("" + n, "seconds");
            }
            this.conn.setQueryTimeout(n);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void addBatch(String string) throws SQLException {
        try {
            this.debugCodeCall("addBatch", string);
            this.checkClosed();
            if (this.escapeProcessing) {
                string = this.conn.translateSQL(string);
            }
            if (this.batchCommands == null) {
                this.batchCommands = new ObjectArray();
            }
            this.batchCommands.add(string);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void clearBatch() throws SQLException {
        try {
            this.debugCodeCall("clearBatch");
            this.checkClosed();
            this.batchCommands = null;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            this.debugCodeCall("executeBatch");
            this.checkClosed();
            if (this.batchCommands == null) {
                this.batchCommands = new ObjectArray();
            }
            int[] nArray = new int[this.batchCommands.size()];
            boolean bl = false;
            for (int i = 0; i < this.batchCommands.size(); ++i) {
                String string = (String)this.batchCommands.get(i);
                try {
                    nArray[i] = this.executeUpdate(string);
                    continue;
                }
                catch (SQLException sQLException) {
                    this.logAndConvert(sQLException);
                    nArray[i] = -3;
                    bl = true;
                }
            }
            this.batchCommands = null;
            if (bl) {
                throw new BatchUpdateException(nArray);
            }
            return nArray;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            int n = this.getNextId(4);
            if (this.debug()) {
                this.debugCodeAssign("ResultSet", 4, n, "getGeneratedKeys()");
            }
            this.checkClosed();
            ResultInterface resultInterface = this.conn.getGeneratedKeys(this, n);
            JdbcResultSet jdbcResultSet = new JdbcResultSet(this.session, this.conn, this, resultInterface, n, false, true);
            return jdbcResultSet;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public boolean getMoreResults(int n) throws SQLException {
        try {
            this.debugCodeCall("getMoreResults");
            throw Message.getUnsupportedException();
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int executeUpdate(String string, int n) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("executeUpdate(" + this.quote(string) + ", " + n + ");");
            }
            return this.executeUpdate(string);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("executeUpdate(" + this.quote(string) + ", " + this.quoteIntArray(nArray) + ");");
            }
            return this.executeUpdate(string);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("executeUpdate(" + this.quote(string) + ", " + this.quoteArray(stringArray) + ");");
            }
            return this.executeUpdate(string);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public boolean execute(String string, int n) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("execute(" + this.quote(string) + ", " + n + ");");
            }
            return this.execute(string);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("execute(" + this.quote(string) + ", " + this.quoteIntArray(nArray) + ");");
            }
            return this.execute(string);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("execute(" + this.quote(string) + ", " + this.quoteArray(stringArray) + ");");
            }
            return this.execute(string);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int getResultSetHoldability() throws SQLException {
        try {
            this.debugCodeCall("getResultSetHoldability");
            this.checkClosed();
            return 1;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    JdbcStatement(SessionInterface sessionInterface, JdbcConnection jdbcConnection, int n, int n2, boolean bl) {
        this.setTrace(sessionInterface.getTrace(), 8, n2);
        this.session = sessionInterface;
        this.conn = jdbcConnection;
        this.resultSetType = n;
        this.closedByResultSet = bl;
    }

    void checkClosed() throws SQLException {
        if (this.conn == null) {
            throw Message.getSQLException(90007);
        }
        this.conn.checkClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeOld() throws SQLException {
        try {
            if (!this.closedByResultSet && this.resultSet != null) {
                this.resultSet.closeInternal();
            }
        }
        finally {
            this.resultSet = null;
            this.updateCount = -1;
        }
    }

    protected void setExecutingStatement(CommandInterface commandInterface) {
        this.conn.setExecutingStatement(commandInterface == null ? null : this);
        this.executingCommand = commandInterface;
    }

    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.conn == null;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public boolean isPoolable() throws SQLException {
        this.debugCodeCall("isPoolable");
        return false;
    }

    public void setPoolable(boolean bl) throws SQLException {
        if (this.debug()) {
            this.debugCode("setPoolable(" + bl + ");");
        }
    }

    public String toString() {
        return this.getTraceObjectName();
    }
}

