/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Comment;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.table.Table;

public class SetComment
extends DefineCommand {
    private String schemaName;
    private String objectName;
    private boolean column;
    private String columnName;
    private int objectType;
    private Expression expr;

    public SetComment(Session session) {
        super(session);
    }

    public int update() throws SQLException {
        DbObjectBase dbObjectBase;
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkAdmin();
        DbObject dbObject = null;
        int n = 50000;
        if (this.schemaName == null) {
            this.schemaName = this.session.getCurrentSchemaName();
        }
        switch (this.objectType) {
            case 11: {
                dbObject = database.getSchema(this.schemaName).getConstant(this.session, this.objectName);
                break;
            }
            case 5: {
                dbObject = database.getSchema(this.schemaName).getConstraint(this.objectName);
                break;
            }
            case 9: {
                this.schemaName = null;
                dbObject = database.findFunctionAlias(this.objectName);
                n = 90077;
                break;
            }
            case 1: {
                dbObject = database.getSchema(this.schemaName).getIndex(this.objectName);
                break;
            }
            case 7: {
                this.schemaName = null;
                dbObject = database.findRole(this.objectName);
                n = 90070;
                break;
            }
            case 10: {
                this.schemaName = null;
                dbObject = database.findSchema(this.objectName);
                n = 90079;
                break;
            }
            case 3: {
                dbObject = database.getSchema(this.schemaName).getSequence(this.objectName);
                break;
            }
            case 0: {
                dbObject = database.getSchema(this.schemaName).getTableOrView(this.session, this.objectName);
                break;
            }
            case 4: {
                dbObject = database.getSchema(this.schemaName).findTrigger(this.objectName);
                n = 90042;
                break;
            }
            case 2: {
                this.schemaName = null;
                dbObject = database.getUser(this.objectName);
                break;
            }
            case 12: {
                this.schemaName = null;
                dbObject = database.findUserDataType(this.objectName);
                n = 90119;
                break;
            }
        }
        if (dbObject == null) {
            throw Message.getSQLException(n, this.objectName);
        }
        String string = this.expr.getValue(this.session).getString();
        if (this.column) {
            dbObjectBase = (Table)dbObject;
            ((Table)dbObjectBase).getColumn(this.columnName).setComment(string);
        } else {
            dbObject.setComment(string);
        }
        if (this.column || this.objectType == 0 || this.objectType == 2 || this.objectType == 1 || this.objectType == 5) {
            database.update(this.session, dbObject);
        } else {
            dbObjectBase = database.findComment(dbObject);
            if (dbObjectBase == null) {
                if (string != null) {
                    int n2 = this.getObjectId(false, false);
                    dbObjectBase = new Comment(database, n2, dbObject);
                    ((Comment)dbObjectBase).setCommentText(string);
                    database.addDatabaseObject(this.session, dbObjectBase);
                }
            } else if (string == null) {
                database.removeDatabaseObject(this.session, dbObjectBase);
            } else {
                ((Comment)dbObjectBase).setCommentText(string);
                database.update(this.session, dbObjectBase);
            }
        }
        return 0;
    }

    public void setCommentExpression(Expression expression) {
        this.expr = expression;
    }

    public void setObjectName(String string) {
        this.objectName = string;
    }

    public void setObjectType(int n) {
        this.objectType = n;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public void setColumn(boolean bl) {
        this.column = bl;
    }
}

