/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2.command.dml.BackupCommand;
import org.h2.message.Message;
import org.h2.store.FileLister;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;

public class Backup {
    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " [-file <filename>] [-dir <dir>] [-db <database>] [-quiet]");
        System.out.println("See also http://h2database.com/javadoc/org/h2/tools/Backup.html");
    }

    public static void main(String[] args) throws SQLException {
        new Backup().run(args);
    }

    private void run(String[] args) throws SQLException {
        String zipFileName = "backup.zip";
        String dir = ".";
        String db = null;
        boolean quiet = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equals("-dir")) {
                dir = args[++i];
                continue;
            }
            if (args[i].equals("-db")) {
                db = args[++i];
                continue;
            }
            if (args[i].equals("-quiet")) {
                quiet = true;
                continue;
            }
            if (args[i].equals("-file")) {
                zipFileName = args[++i];
                continue;
            }
            this.showUsage();
            return;
        }
        Backup.execute(zipFileName, dir, db, quiet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String zipFileName, String directory, String db, boolean quiet) throws SQLException {
        ArrayList list = FileLister.getDatabaseFiles(directory, db, true);
        if (list.size() == 0) {
            if (!quiet) {
                System.out.println("No database files found");
            }
            return;
        }
        if (FileUtils.exists(zipFileName = FileUtils.normalize(zipFileName))) {
            FileUtils.delete(zipFileName);
        }
        OutputStream out = null;
        try {
            String fileName;
            int i;
            out = FileUtils.openFileOutputStream(zipFileName, false);
            ZipOutputStream zipOut = new ZipOutputStream(out);
            String base = "";
            for (i = 0; i < list.size(); ++i) {
                fileName = (String)list.get(i);
                if (!fileName.endsWith(".data.db")) continue;
                base = FileUtils.getParent(fileName);
            }
            for (i = 0; i < list.size(); ++i) {
                fileName = (String)list.get(i);
                String f = FileUtils.getAbsolutePath(fileName);
                if (!f.startsWith(base)) {
                    throw Message.getInternalError(f + " does not start with " + base);
                }
                f = f.substring(base.length());
                f = BackupCommand.correctFileName(f);
                ZipEntry entry = new ZipEntry(f);
                zipOut.putNextEntry(entry);
                InputStream in = null;
                try {
                    in = FileUtils.openFileInputStream(fileName);
                    IOUtils.copyAndCloseInput(in, zipOut);
                }
                catch (FileNotFoundException e) {
                }
                finally {
                    IOUtils.closeSilently(in);
                }
                zipOut.closeEntry();
                if (quiet) continue;
                System.out.println("processed: " + fileName);
            }
            zipOut.closeEntry();
            zipOut.close();
        }
        catch (IOException e) {
            throw Message.convertIOException(e, zipFileName);
        }
        finally {
            IOUtils.closeSilently(out);
        }
    }
}

