/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.FileUtils;

public class TempFileDeleter {
    private static final ReferenceQueue QUEUE = new ReferenceQueue();
    private static final HashMap REF_MAP = new HashMap();

    public static synchronized Reference addFile(String fileName, Object file) {
        FileUtils.trace("TempFileDeleter.addFile", fileName, file);
        PhantomReference<Object> ref = new PhantomReference<Object>(file, QUEUE);
        REF_MAP.put(ref, fileName);
        TempFileDeleter.deleteUnused();
        return ref;
    }

    public static synchronized void deleteFile(Reference ref, String fileName) {
        if (ref != null) {
            String f2 = (String)REF_MAP.remove(ref);
            if (SysProperties.CHECK && f2 != null && fileName != null && !f2.equals(fileName)) {
                throw Message.getInternalError("f2:" + f2 + " f:" + fileName);
            }
        }
        if (fileName != null && FileUtils.exists(fileName)) {
            try {
                FileUtils.trace("TempFileDeleter.deleteFile", fileName, null);
                FileUtils.delete(fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            TempFileDeleter.deleteUnused();
        }
    }

    public static void deleteUnused() {
        Reference ref;
        while (QUEUE != null && (ref = QUEUE.poll()) != null) {
            TempFileDeleter.deleteFile(ref, null);
        }
    }

    public static void stopAutoDelete(Reference ref, String fileName) {
        FileUtils.trace("TempFileDeleter.stopAutoDelete", fileName, ref);
        if (ref != null) {
            String f2 = (String)REF_MAP.remove(ref);
            if (SysProperties.CHECK && (f2 == null || !f2.equals(fileName))) {
                throw Message.getInternalError("f2:" + f2 + " f:" + fileName);
            }
        }
        TempFileDeleter.deleteUnused();
    }
}

