/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.io.IOException;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.SessionRemote;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.result.ResultColumn;
import org.h2.result.ResultInterface;
import org.h2.util.ObjectArray;
import org.h2.value.Transfer;
import org.h2.value.Value;

public class ResultRemote
implements ResultInterface {
    private final int fetchSize;
    private SessionRemote session;
    private Transfer transfer;
    private int id;
    private ResultColumn[] columns;
    private Value[] currentRow;
    private int rowId;
    private int rowCount;
    private int rowOffset;
    private ObjectArray result;
    private ObjectArray lobValues;

    public boolean isUpdateCount() {
        return false;
    }

    public int getUpdateCount() {
        return 0;
    }

    public ResultRemote(SessionRemote session, Transfer transfer, int id, int columnCount, int fetchSize) throws IOException, SQLException {
        this.session = session;
        this.transfer = transfer;
        this.id = id;
        this.columns = new ResultColumn[columnCount];
        this.rowCount = transfer.readInt();
        for (int i = 0; i < columnCount; ++i) {
            this.columns[i] = new ResultColumn(transfer);
        }
        this.rowId = -1;
        this.result = new ObjectArray();
        this.fetchSize = fetchSize;
        this.fetchRows(false);
    }

    public String getAlias(int i) {
        return this.columns[i].alias;
    }

    public String getSchemaName(int i) {
        return this.columns[i].schemaName;
    }

    public String getTableName(int i) {
        return this.columns[i].tableName;
    }

    public String getColumnName(int i) {
        return this.columns[i].columnName;
    }

    public int getColumnType(int i) {
        return this.columns[i].columnType;
    }

    public long getColumnPrecision(int i) {
        return this.columns[i].precision;
    }

    public int getColumnScale(int i) {
        return this.columns[i].scale;
    }

    public int getDisplaySize(int i) {
        return this.columns[i].displaySize;
    }

    public boolean isAutoIncrement(int i) {
        return this.columns[i].autoIncrement;
    }

    public int getNullable(int i) {
        return this.columns[i].nullable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SQLException {
        this.rowId = -1;
        this.currentRow = null;
        if (this.session == null) {
            return;
        }
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            this.session.checkClosed();
            try {
                this.session.traceOperation("RESULT_RESET", this.id);
                this.transfer.writeInt(6).writeInt(this.id).flush();
            }
            catch (IOException e) {
                throw Message.convertIOException(e, null);
            }
        }
    }

    public Value[] currentRow() {
        return this.currentRow;
    }

    public boolean next() throws SQLException {
        if (this.rowId < this.rowCount) {
            ++this.rowId;
            this.remapIfOld();
            if (this.rowId < this.rowCount) {
                if (this.rowId - this.rowOffset >= this.result.size()) {
                    this.fetchRows(true);
                }
                this.currentRow = (Value[])this.result.get(this.rowId - this.rowOffset);
                return true;
            }
            this.currentRow = null;
        }
        return false;
    }

    public int getRowId() {
        return this.rowId;
    }

    public int getVisibleColumnCount() {
        return this.columns.length;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendClose() {
        if (this.session == null) {
            return;
        }
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            try {
                this.session.traceOperation("RESULT_CLOSE", this.id);
                this.transfer.writeInt(7).writeInt(this.id);
            }
            catch (IOException e) {
                this.session.getTrace().error("close", e);
            }
            finally {
                this.transfer = null;
                this.session = null;
            }
        }
    }

    public void close() {
        if (this.session == null) {
            return;
        }
        this.result = null;
        Trace trace = this.session.getTrace();
        this.sendClose();
        if (this.lobValues != null) {
            for (int i = 0; i < this.lobValues.size(); ++i) {
                Value v = (Value)this.lobValues.get(i);
                try {
                    v.close();
                    continue;
                }
                catch (SQLException e) {
                    trace.error("delete lob " + v.getSQL(), e);
                }
            }
            this.lobValues = null;
        }
    }

    private void remapIfOld() throws SQLException {
        if (this.session == null) {
            return;
        }
        try {
            if (this.id <= this.session.getCurrentId() - SysProperties.SERVER_CACHED_OBJECTS / 2) {
                int newId = this.session.getNextId();
                this.session.traceOperation("CHANGE_ID", this.id);
                this.transfer.writeInt(9).writeInt(this.id).writeInt(newId);
                this.id = newId;
            }
        }
        catch (IOException e) {
            throw Message.convertIOException(e, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchRows(boolean sendFetch) throws SQLException {
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            this.session.checkClosed();
            try {
                boolean row;
                this.rowOffset += this.result.size();
                this.result.clear();
                int fetch = Math.min(this.fetchSize, this.rowCount - this.rowOffset);
                if (sendFetch) {
                    this.session.traceOperation("RESULT_FETCH_ROWS", this.id);
                    this.transfer.writeInt(5).writeInt(this.id).writeInt(fetch);
                    this.session.done(this.transfer);
                }
                for (int r = 0; r < fetch && (row = this.transfer.readBoolean()); ++r) {
                    int len = this.columns.length;
                    Value[] values = new Value[len];
                    for (int i = 0; i < len; ++i) {
                        Value v;
                        values[i] = v = this.transfer.readValue();
                        if (!v.isFileBased()) continue;
                        if (this.lobValues == null) {
                            this.lobValues = new ObjectArray();
                        }
                        this.lobValues.add(v);
                    }
                    this.result.add(values);
                }
                if (this.rowOffset + this.result.size() >= this.rowCount) {
                    this.sendClose();
                }
            }
            catch (IOException e) {
                throw Message.convertIOException(e, null);
            }
        }
    }

    public String toString() {
        return "columns: " + this.columns.length + " rows: " + this.rowCount + " pos: " + this.rowId;
    }
}

