/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.h2.command.CommandInterface;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.message.Message;
import org.h2.message.TraceObject;

public class JdbcParameterMetaData
extends TraceObject
implements ParameterMetaData {
    private JdbcPreparedStatement prep;
    private int paramCount;
    static /* synthetic */ Class class$java$lang$String;

    public int getParameterCount() throws SQLException {
        try {
            this.debugCodeCall("getParameterCount");
            this.checkClosed();
            return this.paramCount;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getParameterMode(int param) throws SQLException {
        try {
            this.debugCodeCall("getParameterMode", param);
            this.checkParameterIndex(param);
            return 1;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getParameterType(int param) throws SQLException {
        try {
            this.debugCodeCall("getParameterType", param);
            this.checkParameterIndex(param);
            return 12;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getPrecision(int param) throws SQLException {
        try {
            this.debugCodeCall("getPrecision", param);
            this.checkParameterIndex(param);
            return 0;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getScale(int param) throws SQLException {
        try {
            this.debugCodeCall("getScale", param);
            this.checkParameterIndex(param);
            return 0;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int isNullable(int param) throws SQLException {
        try {
            this.debugCodeCall("isNullable", param);
            this.checkParameterIndex(param);
            return 2;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isSigned(int param) throws SQLException {
        try {
            this.debugCodeCall("isSigned", param);
            this.checkParameterIndex(param);
            return true;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getParameterClassName(int param) throws SQLException {
        try {
            this.debugCodeCall("getParameterClassName", param);
            this.checkParameterIndex(param);
            return (class$java$lang$String == null ? (class$java$lang$String = JdbcParameterMetaData.class$("java.lang.String")) : class$java$lang$String).getName();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getParameterTypeName(int param) throws SQLException {
        try {
            this.debugCodeCall("getParameterTypeName", param);
            this.checkParameterIndex(param);
            return "VARCHAR";
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    JdbcParameterMetaData(SessionInterface session, JdbcPreparedStatement prep, CommandInterface command, int id) {
        this.setTrace(session.getTrace(), 11, id);
        this.prep = prep;
        this.paramCount = command.getParameters().size();
    }

    void checkParameterIndex(int param) throws SQLException {
        this.checkClosed();
        if (param < 1 || param > this.paramCount) {
            throw Message.getInvalidValueException("" + param, "param");
        }
    }

    void checkClosed() throws SQLException {
        this.prep.checkClosed();
    }

    public String toString() {
        return this.getTraceObjectName() + ": parameterCount=" + this.paramCount;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

