/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools.i18n;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.h2.server.web.PageParser;
import org.h2.tools.doc.XMLParser;
import org.h2.tools.i18n.PropertiesToUTF8;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.SortedProperties;
import org.h2.util.StringUtils;

public class PrepareTranslation {
    private static final String MAIN_LANGUAGE = "en";
    private static final String DELETED_PREFIX = "~";
    private static final boolean AUTO_TRANSLATE = false;

    public static void main(String[] args) throws Exception {
        new PrepareTranslation().run(args);
    }

    private void run(String[] args) throws Exception {
        String baseDir = "src/docsrc/textbase";
        this.prepare(baseDir, "src/main/org/h2/res");
        this.prepare(baseDir, "src/main/org/h2/server/web/res");
        PropertiesToUTF8.textUTF8ToProperties("src/docsrc/text/_docs_de.utf8.txt", "src/docsrc/text/_docs_de.properties");
        PropertiesToUTF8.textUTF8ToProperties("src/docsrc/text/_docs_ja.utf8.txt", "src/docsrc/text/_docs_ja.properties");
        PrepareTranslation.extractFromHtml("src/docsrc/html", "src/docsrc/text", MAIN_LANGUAGE);
        this.prepare(baseDir, "src/docsrc/text");
        PrepareTranslation.buildHtml("src/docsrc/text", "docs/html", MAIN_LANGUAGE);
        PrepareTranslation.buildHtml("src/docsrc/text", "docs/html", "ja");
        PropertiesToUTF8.propertiesToTextUTF8("src/docsrc/text/_docs_en.properties", "src/docsrc/text/_docs_en.utf8.txt");
        PropertiesToUTF8.propertiesToTextUTF8("src/docsrc/text/_docs_de.properties", "src/docsrc/text/_docs_de.utf8.txt");
        PropertiesToUTF8.propertiesToTextUTF8("src/docsrc/text/_docs_ja.properties", "src/docsrc/text/_docs_ja.utf8.txt");
        File[] list = new File("src/docsrc/text").listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].getName().endsWith(".utf8.txt")) continue;
            list[i].delete();
        }
    }

    private static void buildHtml(String templateDir, String targetDir, String language) throws IOException {
        String name;
        int i;
        String t;
        String key;
        File[] list = new File(templateDir).listFiles();
        new File(targetDir).mkdirs();
        String propName = templateDir + "/_docs_" + MAIN_LANGUAGE + ".properties";
        Properties prop = FileUtils.loadProperties(propName);
        propName = templateDir + "/_docs_" + language + ".properties";
        if (!new File(propName).exists()) {
            throw new IOException("Translation not found: " + propName);
        }
        Properties transProp = FileUtils.loadProperties(propName);
        Iterator<Object> it = transProp.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            t = transProp.getProperty(key);
            if (t.startsWith("##")) {
                prop.put(key, t.substring(2));
                continue;
            }
            if (t.startsWith("#")) continue;
            prop.put(key, t);
        }
        it = prop.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            t = prop.getProperty(key);
            prop.put(key, " " + t + " ");
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        for (i = 0; i < list.length; ++i) {
            name = list[i].getName();
            if (!name.endsWith(".jsp")) continue;
            name = name.substring(0, name.length() - 4);
            fileNames.add(name);
        }
        for (i = 0; i < list.length; ++i) {
            name = list[i].getName();
            if (!name.endsWith(".jsp")) continue;
            name = name.substring(0, name.length() - 4);
            String template = IOUtils.readStringAndClose(new FileReader(templateDir + "/" + name + ".jsp"), -1);
            String html = PageParser.parse(null, template, prop);
            html = StringUtils.replaceAll(html, "lang=\"en\"", "lang=\"" + language + "\"");
            for (int j = 0; j < fileNames.size(); ++j) {
                String n = (String)fileNames.get(j);
                if ("frame".equals(n)) continue;
                html = StringUtils.replaceAll(html, n + ".html\"", n + "_" + language + ".html\"");
            }
            html = StringUtils.replaceAll(html, "_en.html\"", ".html\"");
            String target = language.equals(MAIN_LANGUAGE) ? targetDir + "/" + name + ".html" : targetDir + "/" + name + "_" + language + ".html";
            FileOutputStream out = new FileOutputStream(target);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
            writer.write(html);
            writer.close();
        }
    }

    private static void extractFromHtml(String dir, String target, String language) throws Exception {
        File[] list = new File(dir).listFiles();
        for (int i = 0; i < list.length; ++i) {
            File f = list[i];
            String name = f.getName();
            if (!name.endsWith(".html") || (name = name.substring(0, name.length() - 5)).indexOf(95) >= 0) continue;
            String template = PrepareTranslation.extract(name, f, target);
            FileWriter writer = new FileWriter(target + "/" + name + ".jsp");
            writer.write(template);
            writer.close();
        }
    }

    private static String getSpace(String s, boolean start) {
        if (start) {
            for (int i = 0; i < s.length(); ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                if (i == 0) {
                    return "";
                }
                return s.substring(0, i);
            }
            return s;
        }
        for (int i = s.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            if (i == s.length() - 1) {
                return "";
            }
            return s.substring(i + 1, s.length());
        }
        return "";
    }

    private static String extract(String documentName, File f, String target) throws Exception {
        int event;
        String xml = IOUtils.readStringAndClose(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"), -1);
        StringBuffer template = new StringBuffer(xml.length());
        int id = 0;
        SortedProperties prop = new SortedProperties();
        XMLParser parser = new XMLParser(xml);
        StringBuffer buff = new StringBuffer();
        Stack<String> stack = new Stack<String>();
        String tag = "";
        boolean ignoreEnd = false;
        String nextKey = "";
        boolean templateIsCopy = false;
        while ((event = parser.next()) != 8) {
            String name;
            if (event == 4) {
                String s = parser.getText();
                String trim = s.trim();
                if (trim.length() == 0) {
                    if (buff.length() > 0) {
                        buff.append(s);
                        continue;
                    }
                    template.append(s);
                    continue;
                }
                if ("p".equals(tag) || "li".equals(tag) || "a".equals(tag) || "td".equals(tag) || "th".equals(tag) || "h1".equals(tag) || "h2".equals(tag) || "h3".equals(tag) || "h4".equals(tag) || "body".equals(tag) || "b".equals(tag) || "code".equals(tag) || "form".equals(tag) || "span".equals(tag) || "em".equals(tag)) {
                    if (buff.length() == 0) {
                        nextKey = documentName + "_" + (1000 + id++) + "_" + tag;
                        template.append(PrepareTranslation.getSpace(s, true));
                    } else if (templateIsCopy) {
                        buff.append(PrepareTranslation.getSpace(s, true));
                    }
                    if (templateIsCopy) {
                        buff.append(trim);
                        buff.append(PrepareTranslation.getSpace(s, false));
                        continue;
                    }
                    buff.append(PrepareTranslation.clean(trim));
                    continue;
                }
                if ("pre".equals(tag) || "title".equals(tag)) {
                    template.append(s);
                    continue;
                }
                System.out.println(f.getName() + " invalid wrapper tag for text: " + tag + " text: " + s);
                System.out.println(parser.getRemaining());
                throw new Exception();
            }
            if (event == 1) {
                stack.add(tag);
                name = parser.getName();
                if ("code".equals(name) || "a".equals(name) || "b".equals(name) || "span".equals(name)) {
                    if (buff.length() > 0) {
                        buff.append(' ');
                        buff.append(parser.getToken().trim());
                        ignoreEnd = false;
                    } else {
                        ignoreEnd = true;
                        template.append(parser.getToken());
                    }
                } else if ("p".equals(tag) || "li".equals(tag) || "td".equals(tag) || "th".equals(tag) || "h1".equals(tag) || "h2".equals(tag) || "h3".equals(tag) || "h4".equals(tag) || "body".equals(tag) || "form".equals(tag)) {
                    if (buff.length() > 0) {
                        if (templateIsCopy) {
                            template.append(buff.toString());
                        } else {
                            template.append("${" + nextKey + "}");
                        }
                        PrepareTranslation.add(prop, nextKey, buff);
                    }
                    template.append(parser.getToken());
                } else {
                    template.append(parser.getToken());
                }
                tag = name;
                continue;
            }
            if (event == 2) {
                name = parser.getName();
                if ("code".equals(name) || "a".equals(name) || "b".equals(name) || "span".equals(name) || "em".equals(name)) {
                    if (ignoreEnd) {
                        if (buff.length() > 0) {
                            if (templateIsCopy) {
                                template.append(buff.toString());
                            } else {
                                template.append("${" + nextKey + "}");
                            }
                            PrepareTranslation.add(prop, nextKey, buff);
                        }
                        template.append(parser.getToken());
                    } else if (buff.length() > 0) {
                        buff.append(parser.getToken());
                        buff.append(' ');
                    }
                } else {
                    if (buff.length() > 0) {
                        if (templateIsCopy) {
                            template.append(buff.toString());
                        } else {
                            template.append("${" + nextKey + "}");
                        }
                        PrepareTranslation.add(prop, nextKey, buff);
                    }
                    template.append(parser.getToken());
                }
                tag = (String)stack.pop();
                continue;
            }
            if (event == 11) {
                template.append(parser.getToken());
                continue;
            }
            if (event == 5) {
                template.append(parser.getToken());
                continue;
            }
            int eventType = parser.getEventType();
            throw new Exception("Unexpected event " + eventType + " at " + parser.getRemaining());
        }
        new File(target).mkdirs();
        String propFileName = target + "/_docs_" + MAIN_LANGUAGE + ".properties";
        Properties old = FileUtils.loadProperties(propFileName);
        prop.putAll((Map<?, ?>)old);
        PropertiesToUTF8.storeProperties(prop, propFileName);
        String t = template.toString();
        if (templateIsCopy && !t.equals(xml)) {
            for (int i = 0; i < Math.min(t.length(), xml.length()); ++i) {
                if (t.charAt(i) == xml.charAt(i)) continue;
                int start = Math.max(0, i - 30);
                int end = Math.min(i + 30, xml.length());
                t = t.substring(start, end);
                xml = xml.substring(start, end);
            }
            System.out.println("xml--------------------------------------------------: ");
            System.out.println(xml);
            System.out.println("t---------------------------------------------------: ");
            System.out.println(t);
            System.exit(1);
        }
        return t;
    }

    private static String clean(String text) {
        if (text.indexOf(13) < 0 && text.indexOf(10) < 0) {
            return text;
        }
        text = text.replace('\r', ' ');
        text = text.replace('\n', ' ');
        text = StringUtils.replaceAll(text, "  ", " ");
        text = StringUtils.replaceAll(text, "  ", " ");
        return text;
    }

    private static void add(Properties prop, String document, StringBuffer text) {
        String s = text.toString().trim();
        text.setLength(0);
        prop.setProperty(document, s);
    }

    private void prepare(String baseDir, String path) throws IOException {
        File dir = new File(path);
        File[] list = dir.listFiles();
        File main = null;
        ArrayList<File> translations = new ArrayList<File>();
        for (int i = 0; list != null && i < list.length; ++i) {
            File f = list[i];
            if (!f.getName().endsWith(".properties")) continue;
            if (f.getName().endsWith("_en.properties")) {
                main = f;
                continue;
            }
            translations.add(f);
        }
        Properties p = FileUtils.loadProperties(main.getAbsolutePath());
        Properties base = FileUtils.loadProperties(baseDir + "/" + main.getName());
        PropertiesToUTF8.storeProperties(p, main.getAbsolutePath());
        for (int i = 0; i < translations.size(); ++i) {
            File trans = (File)translations.get(i);
            String language = trans.getName();
            language = language.substring(language.lastIndexOf(95) + 1, language.lastIndexOf(46));
            this.prepare(p, base, trans, language);
        }
        PropertiesToUTF8.storeProperties(p, baseDir + "/" + main.getName());
    }

    private void prepare(Properties main, Properties base, File trans, String language) throws IOException {
        String key;
        Properties p = FileUtils.loadProperties(trans.getAbsolutePath());
        Properties oldTranslations = new Properties();
        Iterator<Object> it = base.keySet().iterator();
        while (it.hasNext()) {
            String key2 = (String)it.next();
            String m = base.getProperty(key2);
            String t = p.getProperty(key2);
            if (t == null || t.startsWith("#")) continue;
            oldTranslations.setProperty(m, t);
        }
        HashSet toTranslate = new HashSet();
        Iterator<Object> it2 = main.keySet().iterator();
        while (it2.hasNext()) {
            String t;
            String key3 = (String)it2.next();
            String now = main.getProperty(key3);
            if (!p.containsKey(key3)) {
                t = oldTranslations.getProperty(now);
                if (t == null) {
                    System.out.println(trans.getName() + ": key " + key3 + " not found in translation file; added dummy # 'translation'");
                    t = "#" + now;
                    p.put(key3, t);
                    continue;
                }
                p.put(key3, t);
                continue;
            }
            t = p.getProperty(key3);
            String last = base.getProperty(key3);
            if (t.startsWith("#") && !t.startsWith("##")) {
                t = oldTranslations.getProperty(now);
                if (t == null) {
                    t = "#" + now;
                }
                p.put(key3, t);
                continue;
            }
            if (last == null || last.equals(now)) continue;
            t = oldTranslations.getProperty(now);
            if (t == null) {
                System.out.println(trans.getName() + ": key " + key3 + " changed, please review; last=" + last + " now=" + now);
                String old = p.getProperty(key3);
                t = "#" + now + " #" + old;
                p.put(key3, t);
                continue;
            }
            p.put(key3, t);
        }
        HashMap autoTranslated = new HashMap();
        it2 = toTranslate.iterator();
        while (it2.hasNext()) {
            key = (String)it2.next();
            String now = main.getProperty(key);
            System.out.println(trans.getName() + ": key " + key + " not found in translation file; added dummy # 'translation'");
            String t = "#" + now;
            p.put(key, t);
        }
        it2 = new ArrayList<Object>(p.keySet()).iterator();
        while (it2.hasNext()) {
            key = (String)it2.next();
            if (main.containsKey(key) || key.startsWith(DELETED_PREFIX)) continue;
            String newKey = key;
            while (p.containsKey(newKey = DELETED_PREFIX + newKey)) {
            }
            System.out.println(trans.getName() + ": key " + key + " not found in main file; renamed to " + newKey);
            p.put(newKey, p.getProperty(key));
            p.remove(key);
        }
        PropertiesToUTF8.storeProperties(p, trans.getAbsolutePath());
    }

    private Map autoTranslate(Set toTranslate, String sourceLanguage, String targetLanguage) {
        HashMap results = new HashMap();
        if (toTranslate.size() == 0) {
            return results;
        }
        int maxLength = 1500;
        int minSeparator = 100000;
        HashMap<Integer, String> keyMap = new HashMap<Integer, String>(toTranslate.size());
        StringBuffer buff = new StringBuffer(maxLength);
        int separator = minSeparator;
        Iterator it = toTranslate.iterator();
        while (it.hasNext()) {
            String original = (String)it.next();
            if (original == null) continue;
            original = original.trim();
            if (buff.length() + original.length() > maxLength) {
                System.out.println("remaining: " + (toTranslate.size() - separator + minSeparator));
                this.translateChunk(buff, separator, sourceLanguage, targetLanguage, keyMap, results);
            }
            keyMap.put(new Integer(separator), original);
            buff.append(separator);
            buff.append(' ');
            buff.append(original);
            buff.append(' ');
            ++separator;
        }
        this.translateChunk(buff, separator, sourceLanguage, targetLanguage, keyMap, results);
        return results;
    }

    private void translateChunk(StringBuffer buff, int separator, String source, String target, HashMap keyMap, HashMap results) {
        buff.append(separator);
        String original = buff.toString();
        String translation = "";
        try {
            translation = this.translate(original, source, target);
            System.out.println("original: " + original);
            System.out.println("translation: " + translation);
        }
        catch (Throwable e) {
            System.out.println("Exception translating [" + original + "]: " + e);
            e.printStackTrace();
        }
        Iterator it = keyMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            separator = (Integer)entry.getKey();
            String o = (String)entry.getValue();
            String startSeparator = String.valueOf(separator);
            int start = translation.indexOf(startSeparator);
            int end = translation.indexOf(String.valueOf(separator + 1));
            if (start < 0 || end < 0) {
                System.out.println("No translation for " + o);
                results.put(o, "#" + o);
                continue;
            }
            String t = translation.substring(start + startSeparator.length(), end);
            t = t.trim();
            results.put(o, t);
        }
        keyMap.clear();
        buff.setLength(0);
    }

    String translate(String text, String sourceLanguage, String targetLanguage) throws Exception {
        Thread.sleep(4000L);
        String url = "http://translate.google.com/translate_t?langpair=" + sourceLanguage + "|" + targetLanguage + "&text=" + URLEncoder.encode(text, "UTF-8");
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (compatible; Java)");
        String result = IOUtils.readStringAndClose(IOUtils.getReader(conn.getInputStream()), -1);
        int start = result.indexOf("<div id=result_box");
        start = result.indexOf(62, start) + 1;
        int end = result.indexOf("</div>", start);
        return result.substring(start, end);
    }
}

