/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.h2.Driver;
import org.h2.constant.SysProperties;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;

public class JdbcDataSourceFactory
implements ObjectFactory {
    private static TraceSystem traceSystem;
    private Trace trace = traceSystem.getTrace("JDBCX");

    public synchronized Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        this.trace.debug("getObjectInstance obj=" + obj + " name=" + name + " nameCtx=" + nameCtx + " environment=" + environment);
        Reference ref = (Reference)obj;
        if (ref.getClassName().equals(JdbcDataSource.class.getName())) {
            JdbcDataSource dataSource = new JdbcDataSource();
            dataSource.setURL((String)ref.get("url").getContent());
            dataSource.setUser((String)ref.get("user").getContent());
            dataSource.setPassword((String)ref.get("password").getContent());
            String s = (String)ref.get("loginTimeout").getContent();
            dataSource.setLoginTimeout(Integer.parseInt(s));
            return dataSource;
        }
        return null;
    }

    TraceSystem getTraceSystem() {
        return traceSystem;
    }

    Trace getTrace() {
        return this.trace;
    }

    static {
        Driver.load();
        traceSystem = new TraceSystem(SysProperties.CLIENT_TRACE_DIRECTORY + "h2datasource" + ".trace.db", false);
        traceSystem.setLevelFile(SysProperties.DATASOURCE_TRACE_LEVEL);
    }
}

