/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.h2.message.Message;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueTimestamp
extends Value {
    public static final int PRECISION = 23;
    public static final int DISPLAY_SIZE = 23;
    public static final int DEFAULT_SCALE = 10;
    private final Timestamp value;

    private ValueTimestamp(Timestamp value) {
        this.value = value;
    }

    public Timestamp getTimestamp() {
        return (Timestamp)this.value.clone();
    }

    public Timestamp getTimestampNoCopy() {
        return this.value;
    }

    public String getSQL() {
        return "TIMESTAMP '" + this.getString() + "'";
    }

    public static Timestamp parseTimestamp(String s) throws SQLException {
        return (Timestamp)DateTimeUtils.parseDateTime(s, 11, 90011);
    }

    public int getType() {
        return 11;
    }

    protected int compareSecure(Value o, CompareMode mode) {
        ValueTimestamp v = (ValueTimestamp)o;
        int c = this.value.compareTo(v.value);
        return c == 0 ? 0 : (c < 0 ? -1 : 1);
    }

    public String getString() {
        return this.value.toString();
    }

    public long getPrecision() {
        return 23L;
    }

    public int getScale() {
        return 10;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object getObject() {
        return this.getTimestamp();
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setTimestamp(parameterIndex, this.value);
    }

    public static ValueTimestamp get(Timestamp timestamp) {
        timestamp = (Timestamp)timestamp.clone();
        return ValueTimestamp.getNoCopy(timestamp);
    }

    public static ValueTimestamp getNoCopy(Timestamp timestamp) {
        return (ValueTimestamp)Value.cache(new ValueTimestamp(timestamp));
    }

    public Value convertScale(boolean onlyToSmallerScale, int targetScale) throws SQLException {
        if (targetScale < 0 || targetScale > 10) {
            throw Message.getInvalidValueException("" + targetScale, "scale");
        }
        int nanos = this.value.getNanos();
        BigDecimal bd = new BigDecimal("" + nanos);
        bd = bd.movePointLeft(9);
        bd = MathUtils.setScale(bd, targetScale);
        int n2 = (bd = bd.movePointRight(9)).intValue();
        if (n2 == nanos) {
            return this;
        }
        long t = this.value.getTime();
        while (n2 >= 1000000000) {
            t += 1000L;
            n2 -= 1000000000;
        }
        Timestamp t2 = new Timestamp(t);
        t2.setNanos(n2);
        return ValueTimestamp.getNoCopy(t2);
    }

    public int getDisplaySize() {
        return 23;
    }

    protected boolean isEqual(Value v) {
        return v instanceof ValueTimestamp && this.value.equals(((ValueTimestamp)v).value);
    }
}

