/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.StringTokenizer;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleElement;
import org.h2.bnf.RuleFixed;
import org.h2.bnf.RuleHead;
import org.h2.bnf.RuleList;
import org.h2.bnf.RuleOptional;
import org.h2.bnf.RuleRepeat;
import org.h2.bnf.Sentence;
import org.h2.server.web.DbContextRule;
import org.h2.tools.Csv;
import org.h2.util.Resources;
import org.h2.util.StringCache;
import org.h2.util.StringUtils;

public class Bnf {
    static final boolean COMBINE_KEYWORDS = false;
    private static final String SEPARATORS = " [](){}|.,\r\n<>:-+*/=<\">!'";
    private static final long MAX_PARSE_TIME = 100L;
    private final Random random = new Random();
    private final HashMap ruleMap = new HashMap();
    private String syntax;
    private String currentToken;
    private String[] tokens;
    private char firstChar;
    private int index;
    private Rule lastRepeat;
    private ArrayList statements;
    private String currentTopic;

    public static Bnf getInstance(Reader csv) throws Exception {
        Bnf bnf = new Bnf();
        if (csv == null) {
            byte[] data = Resources.get("/org/h2/res/help.csv");
            csv = new InputStreamReader(new ByteArrayInputStream(data));
        }
        bnf.parse(csv);
        return bnf;
    }

    Bnf() {
        this.random.setSeed(1L);
    }

    void addFixedRule(String name, int fixedType) {
        RuleFixed rule = new RuleFixed(fixedType);
        this.addRule(name, 0, "Fixed", rule);
    }

    RuleHead addRule(String topic, int id, String section, Rule rule) {
        RuleHead head = new RuleHead(id, section, topic, rule);
        if (this.ruleMap.get(StringUtils.toLowerEnglish(topic)) != null) {
            throw new Error("already exists: " + topic);
        }
        this.ruleMap.put(StringUtils.toLowerEnglish(topic), head);
        return head;
    }

    public Random getRandom() {
        return this.random;
    }

    public HashMap getRuleMap() {
        return this.ruleMap;
    }

    public void parse(Reader csv) throws Exception {
        csv = new BufferedReader(csv);
        Rule functions = null;
        this.statements = new ArrayList();
        ResultSet rs = Csv.getInstance().read(csv, null);
        int id = 0;
        while (rs.next()) {
            String section = rs.getString("SECTION").trim();
            if (!section.startsWith("System")) {
                String topic = StringUtils.toLowerEnglish(rs.getString("TOPIC").trim());
                topic = StringUtils.replaceAll(topic, " ", "");
                topic = StringUtils.replaceAll(topic, "_", "");
                this.syntax = rs.getString("SYNTAX").trim();
                this.currentTopic = section;
                if (section.startsWith("Function")) {
                    int end = this.syntax.indexOf(58);
                    this.syntax = this.syntax.substring(0, end);
                }
                this.tokens = this.tokenize();
                this.index = 0;
                Rule rule = this.parseRule();
                if (section.startsWith("Command")) {
                    rule = new RuleList(rule, new RuleElement(";\n\n", this.currentTopic), false);
                }
                RuleHead head = this.addRule(topic, id, section, rule);
                if (section.startsWith("Function")) {
                    functions = functions == null ? rule : new RuleList(rule, functions, true);
                } else if (section.startsWith("Commands")) {
                    this.statements.add(head);
                }
            }
            ++id;
        }
        this.addRule("@func@", 0, "Function", functions);
        this.addFixedRule("@ymd@", 0);
        this.addFixedRule("@hms@", 1);
        this.addFixedRule("@nanos@", 2);
        this.addFixedRule("anythingExceptSingleQuote", 3);
        this.addFixedRule("anythingExceptDoubleQuote", 4);
        this.addFixedRule("anythingUntilEndOfLine", 5);
        this.addFixedRule("anythingUntilEndComment", 6);
        this.addFixedRule("anything", 7);
        this.addFixedRule("@hexStart@", 10);
        this.addFixedRule("@concat@", 11);
        this.addFixedRule("@az_@", 12);
        this.addFixedRule("@af@", 13);
        this.addFixedRule("@digit@", 14);
    }

    public String getSyntax(String rule, String syntax) {
        StringTokenizer tokenizer = new StringTokenizer(syntax, SEPARATORS, true);
        StringBuffer buff = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            if (s.length() == 1 || StringUtils.toUpperEnglish(s).equals(s)) {
                buff.append(s);
                continue;
            }
            String section = null;
            int id = -1;
            for (int i = 0; i < s.length(); ++i) {
                String test = StringUtils.toLowerEnglish(s.substring(i));
                RuleHead r = (RuleHead)this.ruleMap.get(test);
                if (r == null) continue;
                id = r.id;
                section = r.section;
                break;
            }
            if (id == -1) {
                buff.append(s);
                continue;
            }
            String page = "grammar.html";
            if (section.startsWith("Data Types")) {
                page = "datatypes.html";
            } else if (section.startsWith("Functions")) {
                page = "functions.html";
            }
            buff.append("<a href=\"" + page + "#sql" + id + "\">");
            buff.append(s);
            buff.append("</a>");
        }
        return buff.toString();
    }

    private Rule parseRule() {
        this.read();
        return this.parseOr();
    }

    private Rule parseOr() {
        Rule r = this.parseList();
        if (this.firstChar == '|') {
            this.read();
            r = new RuleList(r, this.parseOr(), true);
        }
        this.lastRepeat = r;
        return r;
    }

    private Rule parseList() {
        Rule r = this.parseToken();
        if (this.firstChar != '|' && this.firstChar != ']' && this.firstChar != '}' && this.firstChar != '\u0000') {
            r = new RuleList(r, this.parseList(), false);
        }
        this.lastRepeat = r;
        return r;
    }

    private Rule parseToken() {
        Rule r;
        if (this.firstChar >= 'A' && this.firstChar <= 'Z' || this.firstChar >= 'a' && this.firstChar <= 'z') {
            r = new RuleElement(this.currentToken, this.currentTopic);
        } else if (this.firstChar == '[') {
            this.read();
            Rule r2 = this.parseOr();
            boolean repeat = false;
            if (r2.last() instanceof RuleRepeat) {
                repeat = true;
            }
            r = new RuleOptional(r2, repeat);
            if (this.firstChar != ']') {
                throw new Error("expected ], got " + this.currentToken + " syntax:" + this.syntax);
            }
        } else if (this.firstChar == '{') {
            this.read();
            r = this.parseOr();
            if (this.firstChar != '}') {
                throw new Error("expected }, got " + this.currentToken + " syntax:" + this.syntax);
            }
        } else if ("@commaDots@".equals(this.currentToken)) {
            r = new RuleList(new RuleElement(",", this.currentTopic), this.lastRepeat, false);
            r = new RuleRepeat(r);
        } else {
            r = "@dots@".equals(this.currentToken) ? new RuleRepeat(this.lastRepeat) : new RuleElement(this.currentToken, this.currentTopic);
        }
        this.lastRepeat = r;
        this.read();
        return r;
    }

    private void read() {
        if (this.index < this.tokens.length) {
            this.currentToken = this.tokens[this.index++];
            this.firstChar = this.currentToken.charAt(0);
        } else {
            this.currentToken = "";
            this.firstChar = '\u0000';
        }
    }

    private String[] tokenize() {
        ArrayList<String> list = new ArrayList<String>();
        this.syntax = StringUtils.replaceAll(this.syntax, "yyyy-MM-dd", "@ymd@");
        this.syntax = StringUtils.replaceAll(this.syntax, "hh:mm:ss", "@hms@");
        this.syntax = StringUtils.replaceAll(this.syntax, "nnnnnnnnn", "@nanos@");
        this.syntax = StringUtils.replaceAll(this.syntax, "function", "@func@");
        this.syntax = StringUtils.replaceAll(this.syntax, "0x", "@hexStart@");
        this.syntax = StringUtils.replaceAll(this.syntax, ",...", "@commaDots@");
        this.syntax = StringUtils.replaceAll(this.syntax, "...", "@dots@");
        this.syntax = StringUtils.replaceAll(this.syntax, "||", "@concat@");
        this.syntax = StringUtils.replaceAll(this.syntax, "a-z|_", "@az_@");
        this.syntax = StringUtils.replaceAll(this.syntax, "A-Z|_", "@az_@");
        this.syntax = StringUtils.replaceAll(this.syntax, "a-f", "@af@");
        this.syntax = StringUtils.replaceAll(this.syntax, "A-F", "@af@");
        this.syntax = StringUtils.replaceAll(this.syntax, "0-9", "@digit@");
        StringTokenizer tokenizer = new StringTokenizer(this.syntax, SEPARATORS, true);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            if ((s = StringCache.get(s)).length() == 1 && " \r\n".indexOf(s.charAt(0)) >= 0) continue;
            list.add(s);
        }
        return list.toArray(new String[0]);
    }

    public HashMap getNextTokenList(String query) {
        HashMap next = new HashMap();
        Sentence sentence = new Sentence();
        sentence.next = next;
        sentence.text = query;
        for (int i = 0; i < this.statements.size(); ++i) {
            RuleHead head = (RuleHead)this.statements.get(i);
            if (!head.section.startsWith("Commands")) continue;
            sentence.max = System.currentTimeMillis() + 100L;
            head.getRule().addNextTokenList(query, sentence);
        }
        return next;
    }

    public void linkStatements() {
        HashMap ruleMap = this.getRuleMap();
        Iterator it = ruleMap.values().iterator();
        while (it.hasNext()) {
            RuleHead r = (RuleHead)it.next();
            r.getRule().setLinks(ruleMap);
        }
    }

    public void updateTopic(String topic, DbContextRule rule) {
        RuleHead head = (RuleHead)this.ruleMap.get(topic = StringUtils.toLowerEnglish(topic));
        if (head == null) {
            head = new RuleHead(0, "db", topic, rule);
            this.ruleMap.put(topic, head);
            this.statements.add(head);
        } else {
            head.rule = rule;
        }
    }

    public void updateTopic(String topic, String[] array) {
        topic = StringUtils.toLowerEnglish(topic);
        ArrayList<RuleElement> list = new ArrayList<RuleElement>();
        for (int i = 0; i < array.length; ++i) {
            list.add(new RuleElement(array[i], true, topic));
        }
        RuleList rule = new RuleList(list, true);
        RuleHead head = (RuleHead)this.ruleMap.get(topic);
        if (head == null) {
            head = new RuleHead(0, "db", topic, rule);
            this.ruleMap.put(topic, head);
            this.statements.add(head);
        } else {
            head.rule = rule;
        }
    }

    public ArrayList getStatements() {
        return this.statements;
    }
}

