/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.LinkedCursor;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.TableLink;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class LinkedIndex
extends BaseIndex {
    private TableLink link;
    private String targetTableName;

    public LinkedIndex(TableLink table, int id, IndexColumn[] columns, IndexType indexType) {
        super(table, id, null, columns, indexType);
        this.link = table;
        this.targetTableName = this.link.getQualifiedTable();
    }

    public String getCreateSQL() {
        return null;
    }

    public void close(Session session) throws SQLException {
    }

    private boolean isNull(Value v) {
        return v == null || v == ValueNull.INSTANCE;
    }

    public void add(Session session, Row row) throws SQLException {
        StringBuffer buff = new StringBuffer("INSERT INTO ");
        buff.append(this.targetTableName);
        buff.append(" VALUES(");
        int j = 0;
        for (int i = 0; i < row.getColumnCount(); ++i) {
            Value v = row.getValue(i);
            if (j > 0) {
                buff.append(',');
            }
            ++j;
            if (this.isNull(v)) {
                buff.append("NULL");
                continue;
            }
            buff.append('?');
        }
        buff.append(')');
        String sql = buff.toString();
        try {
            PreparedStatement prep = this.link.getPreparedStatement(sql);
            int j2 = 0;
            for (int i = 0; i < row.getColumnCount(); ++i) {
                Value v = row.getValue(i);
                if (v == null || v == ValueNull.INSTANCE) continue;
                v.set(prep, j2 + 1);
                ++j2;
            }
            prep.executeUpdate();
            ++this.rowCount;
        }
        catch (SQLException e) {
            throw this.wrapException(sql, e);
        }
    }

    public Cursor find(Session session, SearchRow first, SearchRow last) throws SQLException {
        Value v;
        int i;
        StringBuffer buff = new StringBuffer();
        for (i = 0; first != null && i < first.getColumnCount(); ++i) {
            v = first.getValue(i);
            if (v == null) continue;
            if (buff.length() != 0) {
                buff.append(" AND ");
            }
            buff.append(this.table.getColumn(i).getSQL());
            buff.append(">=?");
        }
        for (i = 0; last != null && i < last.getColumnCount(); ++i) {
            v = last.getValue(i);
            if (v == null) continue;
            if (buff.length() != 0) {
                buff.append(" AND ");
            }
            buff.append(this.table.getColumn(i).getSQL());
            buff.append("<=?");
        }
        if (buff.length() > 0) {
            buff.insert(0, " WHERE ");
        }
        buff.insert(0, "SELECT * FROM " + this.targetTableName + " T");
        String sql = buff.toString();
        try {
            Value v2;
            int i2;
            PreparedStatement prep = this.link.getPreparedStatement(sql);
            int j = 0;
            for (i2 = 0; first != null && i2 < first.getColumnCount(); ++i2) {
                v2 = first.getValue(i2);
                if (v2 == null) continue;
                v2.set(prep, j + 1);
                ++j;
            }
            for (i2 = 0; last != null && i2 < last.getColumnCount(); ++i2) {
                v2 = last.getValue(i2);
                if (v2 == null) continue;
                v2.set(prep, j + 1);
                ++j;
            }
            ResultSet rs = prep.executeQuery();
            return new LinkedCursor(this.table, rs, session);
        }
        catch (SQLException e) {
            throw this.wrapException(sql, e);
        }
    }

    public int getLookupCost(int rowCount) {
        int i = 0;
        int j = 1;
        while ((j *= 10) <= rowCount) {
            ++i;
        }
        return i + 1;
    }

    public double getCost(Session session, int[] masks) throws SQLException {
        return 100L + this.getCostRangeIndex(masks, this.rowCount + 1000L);
    }

    public void remove(Session session) throws SQLException {
    }

    public void truncate(Session session) throws SQLException {
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean needRebuild() {
        return false;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public SearchRow findFirstOrLast(Session session, boolean first) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void remove(Session session, Row row) throws SQLException {
        StringBuffer buff = new StringBuffer("DELETE FROM ");
        buff.append(this.targetTableName);
        buff.append(" WHERE ");
        for (int i = 0; i < row.getColumnCount(); ++i) {
            if (i > 0) {
                buff.append("AND ");
            }
            buff.append(this.table.getColumn(i).getSQL());
            Value v = row.getValue(i);
            if (this.isNull(v)) {
                buff.append(" IS NULL ");
                continue;
            }
            buff.append("=? ");
        }
        String sql = buff.toString();
        try {
            PreparedStatement prep = this.link.getPreparedStatement(sql);
            int j = 0;
            for (int i = 0; i < row.getColumnCount(); ++i) {
                Value v = row.getValue(i);
                if (this.isNull(v)) continue;
                v.set(prep, j + 1);
                ++j;
            }
            int count = prep.executeUpdate();
            this.rowCount -= (long)count;
        }
        catch (SQLException e) {
            throw this.wrapException(sql, e);
        }
    }

    public void update(Session session, Row oldRow, Row newRow) throws SQLException {
        int i;
        StringBuffer buff = new StringBuffer("UPDATE ");
        buff.append(this.targetTableName).append(" SET ");
        for (i = 0; i < newRow.getColumnCount(); ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.table.getColumn(i).getSQL()).append("=?");
        }
        buff.append(" WHERE ");
        for (i = 0; i < oldRow.getColumnCount(); ++i) {
            if (i > 0) {
                buff.append("AND ");
            }
            buff.append(this.table.getColumn(i).getSQL());
            Value v = oldRow.getValue(i);
            if (this.isNull(v)) {
                buff.append(" IS NULL ");
                continue;
            }
            buff.append("=? ");
        }
        String sql = buff.toString();
        try {
            int i2;
            int j = 1;
            PreparedStatement prep = this.link.getPreparedStatement(sql);
            for (i2 = 0; i2 < newRow.getColumnCount(); ++i2) {
                newRow.getValue(i2).set(prep, j);
                ++j;
            }
            for (i2 = 0; i2 < oldRow.getColumnCount(); ++i2) {
                Value v = oldRow.getValue(i2);
                if (this.isNull(v)) continue;
                v.set(prep, j);
                ++j;
            }
            int count = prep.executeUpdate();
            this.rowCount = this.rowCount + (long)count - (long)count;
        }
        catch (SQLException e) {
            throw this.wrapException(sql, e);
        }
    }

    private SQLException wrapException(String sql, SQLException e) {
        return Message.getSQLException(90111, new String[]{sql, e.toString()}, e);
    }
}

