/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;

public class Subquery
extends Expression {
    private Query query;

    public Subquery(Query query) {
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getValue(Session session) throws SQLException {
        this.query.setSession(session);
        LocalResult result = this.query.query(2);
        try {
            Value v;
            int rowcount = result.getRowCount();
            if (rowcount > 1) {
                throw Message.getSQLException(90053);
            }
            if (rowcount <= 0) {
                v = ValueNull.INSTANCE;
            } else {
                result.next();
                Value[] values = result.currentRow();
                v = result.getVisibleColumnCount() == 1 ? values[0] : ValueArray.get(values);
            }
            ValueNull valueNull = v;
            return valueNull;
        }
        finally {
            result.close();
        }
    }

    public int getType() {
        return this.getExpression().getType();
    }

    public void mapColumns(ColumnResolver resolver, int level) throws SQLException {
        this.query.mapColumns(resolver, level + 1);
    }

    public Expression optimize(Session session) throws SQLException {
        this.query.prepare();
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.query.setEvaluatable(tableFilter, b);
    }

    public int getScale() {
        return this.getExpression().getScale();
    }

    public long getPrecision() {
        return this.getExpression().getPrecision();
    }

    public int getDisplaySize() {
        return this.getExpression().getDisplaySize();
    }

    public String getSQL() {
        return "(" + this.query.getPlanSQL() + ")";
    }

    public void updateAggregate(Session session) throws SQLException {
        this.query.updateAggregate(session);
    }

    private Expression getExpression() {
        return (Expression)this.query.getExpressions().get(0);
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        return this.query.isEverything(visitor);
    }

    public Query getQuery() {
        return this.query;
    }

    public int getCost() {
        return 10 + (int)(10.0 * this.query.getCost());
    }
}

