/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.message.TraceSystem;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.MemoryFile;
import org.h2.util.SortedProperties;
import org.h2.util.StringUtils;

public class FileUtils {
    public static final String MEMORY_PREFIX = "memFS:";
    public static final String MEMORY_PREFIX_LZF = "memLZF:";
    private static final HashMap MEMORY_FILES = new HashMap();
    private static final boolean IS_FILE_SYSTEM_CASE_INSENSITIVE = File.separatorChar == '\\';

    public static RandomAccessFile openRandomAccessFile(String fileName, String mode) throws IOException {
        fileName = FileUtils.translateFileName(fileName);
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, mode);
            FileUtils.trace("openRandomAccessFile", fileName, file);
            return file;
        }
        catch (IOException e) {
            FileUtils.freeMemoryAndFinalize();
            return new RandomAccessFile(fileName, mode);
        }
    }

    public static void setLength(RandomAccessFile file, long newLength) throws IOException {
        try {
            FileUtils.trace("setLength", null, file);
            file.setLength(newLength);
        }
        catch (IOException e) {
            int write;
            long remaining;
            long length = file.length();
            if (newLength < length) {
                throw e;
            }
            long pos = file.getFilePointer();
            file.seek(length);
            int maxSize = 0x100000;
            int block = (int)Math.min(remaining, (long)maxSize);
            byte[] buffer = new byte[block];
            for (remaining = newLength - length; remaining > 0L; remaining -= (long)write) {
                write = (int)Math.min(remaining, (long)maxSize);
                file.write(buffer, 0, write);
            }
            file.seek(pos);
        }
    }

    public static FileWriter openFileWriter(String fileName, boolean append) throws IOException {
        fileName = FileUtils.translateFileName(fileName);
        try {
            return new FileWriter(fileName, append);
        }
        catch (IOException e) {
            FileUtils.freeMemoryAndFinalize();
            return new FileWriter(fileName, append);
        }
    }

    public static boolean fileStartsWith(String fileName, String prefix) {
        fileName = FileUtils.translateFileName(fileName);
        if (IS_FILE_SYSTEM_CASE_INSENSITIVE) {
            fileName = StringUtils.toUpperEnglish(fileName);
            prefix = StringUtils.toUpperEnglish(prefix);
        }
        return fileName.startsWith(prefix);
    }

    public static FileInputStream openFileInputStream(String fileName) throws IOException {
        fileName = FileUtils.translateFileName(fileName);
        FileInputStream in = new FileInputStream(fileName);
        FileUtils.trace("openFileInputStream", fileName, in);
        return in;
    }

    public static FileOutputStream openFileOutputStream(String fileName) throws IOException, SQLException {
        fileName = FileUtils.translateFileName(fileName);
        try {
            File file = new File(fileName);
            FileUtils.createDirs(file.getAbsolutePath());
            FileOutputStream out = new FileOutputStream(fileName);
            FileUtils.trace("openFileOutputStream", fileName, out);
            return out;
        }
        catch (IOException e) {
            FileUtils.freeMemoryAndFinalize();
            return new FileOutputStream(fileName);
        }
    }

    private static void freeMemoryAndFinalize() {
        FileUtils.trace("freeMemoryAndFinalize", null, null);
        Runtime rt = Runtime.getRuntime();
        long mem = rt.freeMemory();
        for (int i = 0; i < 16; ++i) {
            rt.gc();
            long now = rt.freeMemory();
            rt.runFinalization();
            if (now == mem) break;
            mem = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rename(String oldName, String newName) throws SQLException {
        oldName = FileUtils.translateFileName(oldName);
        newName = FileUtils.translateFileName(newName);
        if (FileUtils.isInMemory(oldName)) {
            MemoryFile f = FileUtils.getMemoryFile(oldName);
            f.setName(newName);
            HashMap hashMap = MEMORY_FILES;
            synchronized (hashMap) {
                MEMORY_FILES.put(newName, f);
            }
            return;
        }
        File oldFile = new File(oldName);
        File newFile = new File(newName);
        if (oldFile.getName().equals(newFile.getName())) {
            throw Message.getInternalError("rename file old=new");
        }
        if (!oldFile.exists()) {
            throw Message.getSQLException(90024, new String[]{oldName + " (not found)", newName});
        }
        if (newFile.exists()) {
            throw Message.getSQLException(90024, new String[]{oldName, newName + " (exists)"});
        }
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            FileUtils.trace("rename", oldName + " >" + newName, null);
            boolean ok = oldFile.renameTo(newFile);
            if (ok) {
                return;
            }
            FileUtils.wait(i);
        }
        throw Message.getSQLException(90024, new String[]{oldName, newName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Properties loadProperties(String fileName) throws IOException {
        fileName = FileUtils.translateFileName(fileName);
        SortedProperties prop = new SortedProperties();
        File file = new File(fileName);
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            try {
                prop.load(in);
            }
            finally {
                in.close();
            }
        }
        return prop;
    }

    public static boolean getBooleanProperty(Properties prop, String key, boolean def) {
        String value = prop.getProperty(key, "" + def);
        try {
            return Boolean.valueOf(value);
        }
        catch (Exception e) {
            TraceSystem.traceThrowable(e);
            return def;
        }
    }

    public static int getIntProperty(Properties prop, String key, int def) {
        String value = prop.getProperty(key, "" + def);
        try {
            return MathUtils.decodeInt(value);
        }
        catch (Exception e) {
            TraceSystem.traceThrowable(e);
            return def;
        }
    }

    public static void createDirs(String fileName) throws SQLException {
        File f = new File(fileName = FileUtils.translateFileName(fileName));
        if (!f.exists()) {
            String parent = f.getParent();
            if (parent == null) {
                return;
            }
            File dir = new File(parent);
            for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
                if (dir.exists() || dir.mkdirs()) {
                    return;
                }
                FileUtils.wait(i);
            }
            throw Message.getSQLException(90062, parent);
        }
    }

    public static boolean createNewFile(String fileName) throws SQLException {
        if (FileUtils.isInMemory(fileName = FileUtils.translateFileName(fileName))) {
            if (FileUtils.exists(fileName)) {
                return false;
            }
            FileUtils.getMemoryFile(fileName);
            return true;
        }
        File file = new File(fileName);
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            try {
                return file.createNewFile();
            }
            catch (IOException e) {
                FileUtils.wait(i);
                continue;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String fileName) throws SQLException {
        if (FileUtils.isInMemory(fileName = FileUtils.translateFileName(fileName))) {
            HashMap hashMap = MEMORY_FILES;
            synchronized (hashMap) {
                MEMORY_FILES.remove(fileName);
            }
            return;
        }
        File file = new File(fileName);
        if (file.exists()) {
            for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
                FileUtils.trace("delete", fileName, null);
                boolean ok = file.delete();
                if (ok) {
                    return;
                }
                FileUtils.wait(i);
            }
            throw Message.getSQLException(90025, fileName);
        }
    }

    private static void wait(int i) {
        if (i > 8) {
            System.gc();
        }
        try {
            long sleep = Math.min(256, i * i);
            Thread.sleep(sleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getFileName(String name) throws SQLException {
        String fullFileName;
        name = FileUtils.translateFileName(name);
        String separator = System.getProperty("file.separator");
        String path = FileUtils.getParent(name);
        if (!path.endsWith(separator)) {
            path = path + separator;
        }
        if (!(fullFileName = FileUtils.normalize(name)).startsWith(path)) {
            throw Message.getInternalError("file utils error: " + fullFileName + " does not start with " + path);
        }
        String fileName = fullFileName.substring(path.length());
        return fileName;
    }

    public static String getFileInUserHome(String fileName) {
        String userDir = System.getProperty("user.home");
        if (userDir == null) {
            return fileName;
        }
        File file = new File(userDir, fileName);
        return file.getAbsolutePath();
    }

    public static String normalize(String fileName) throws SQLException {
        if (FileUtils.isInMemory(fileName = FileUtils.translateFileName(fileName))) {
            return fileName;
        }
        File f = new File(fileName);
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            throw Message.convertIOException(e, fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryDelete(String fileName) {
        if (FileUtils.isInMemory(fileName = FileUtils.translateFileName(fileName))) {
            HashMap hashMap = MEMORY_FILES;
            synchronized (hashMap) {
                MEMORY_FILES.remove(fileName);
            }
            return;
        }
        FileUtils.trace("tryDelete", fileName, null);
        new File(fileName).delete();
    }

    public static boolean isReadOnly(String fileName) {
        if (FileUtils.isInMemory(fileName = FileUtils.translateFileName(fileName))) {
            return false;
        }
        File f = new File(fileName);
        return f.exists() && !f.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(String fileName) {
        if (FileUtils.isInMemory(fileName = FileUtils.translateFileName(fileName))) {
            HashMap hashMap = MEMORY_FILES;
            synchronized (hashMap) {
                return MEMORY_FILES.get(fileName) != null;
            }
        }
        return new File(fileName).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MemoryFile getMemoryFile(String fileName) {
        HashMap hashMap = MEMORY_FILES;
        synchronized (hashMap) {
            MemoryFile m = (MemoryFile)MEMORY_FILES.get(fileName);
            if (m == null) {
                boolean compress = fileName.startsWith(MEMORY_PREFIX_LZF);
                m = new MemoryFile(fileName, compress);
                MEMORY_FILES.put(fileName, m);
            }
            return m;
        }
    }

    public static long length(String fileName) {
        if (FileUtils.isInMemory(fileName = FileUtils.translateFileName(fileName))) {
            return FileUtils.getMemoryFile(fileName).length();
        }
        return new File(fileName).length();
    }

    public static boolean isInMemory(String fileName) {
        return fileName.startsWith(MEMORY_PREFIX) || fileName.startsWith(MEMORY_PREFIX_LZF);
    }

    public static String createTempFile(String name, String suffix, boolean deleteOnExit, boolean inTempDir) throws IOException, SQLException {
        File dir;
        name = FileUtils.translateFileName(name);
        if (FileUtils.isInMemory(name = name + ".")) {
            int i = 0;
            while (true) {
                String n;
                if (!FileUtils.exists(n = name + i + suffix)) {
                    FileUtils.getMemoryFile(n);
                    return n;
                }
                ++i;
            }
        }
        String prefix = new File(name).getName();
        if (inTempDir) {
            dir = null;
        } else {
            dir = new File(name).getAbsoluteFile().getParentFile();
            dir.mkdirs();
        }
        File f = File.createTempFile(prefix, suffix, dir);
        if (deleteOnExit) {
            f.deleteOnExit();
        }
        return f.getCanonicalPath();
    }

    public static String getParent(String fileName) {
        if (FileUtils.isInMemory(fileName = FileUtils.translateFileName(fileName))) {
            return MEMORY_PREFIX;
        }
        return new File(fileName).getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] listFiles(String path) throws SQLException {
        if (FileUtils.isInMemory(path = FileUtils.translateFileName(path))) {
            HashMap hashMap = MEMORY_FILES;
            synchronized (hashMap) {
                String[] list = new String[MEMORY_FILES.size()];
                MemoryFile[] l = new MemoryFile[MEMORY_FILES.size()];
                MEMORY_FILES.values().toArray(l);
                for (int i = 0; i < list.length; ++i) {
                    list[i] = l[i].getName();
                }
                return list;
            }
        }
        File f = new File(path);
        try {
            String[] list = f.list();
            if (list == null) {
                return new String[0];
            }
            String base = f.getCanonicalPath();
            if (!base.endsWith(File.separator)) {
                base = base + File.separator;
            }
            for (int i = 0; i < list.length; ++i) {
                list[i] = base + list[i];
            }
            return list;
        }
        catch (IOException e) {
            throw Message.convertIOException(e, path);
        }
    }

    public static boolean isDirectory(String fileName) {
        if (FileUtils.isInMemory(fileName = FileUtils.translateFileName(fileName))) {
            return false;
        }
        return new File(fileName).isDirectory();
    }

    public static void copy(String original, String copy) throws SQLException {
        original = FileUtils.translateFileName(original);
        copy = FileUtils.translateFileName(copy);
        FileOutputStream out = null;
        FileInputStream in = null;
        try {
            int len;
            out = FileUtils.openFileOutputStream(copy);
            in = FileUtils.openFileInputStream(original);
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            try {
                throw Message.convertIOException(e, "original: " + original + " copy: " + copy);
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(in);
                IOUtils.closeSilently(out);
                throw throwable;
            }
        }
        IOUtils.closeSilently(in);
        IOUtils.closeSilently(out);
    }

    public static void deleteRecursive(String fileName) throws SQLException {
        if (FileUtils.isDirectory(fileName = FileUtils.translateFileName(fileName))) {
            String[] list = FileUtils.listFiles(fileName);
            for (int i = 0; list != null && i < list.length; ++i) {
                FileUtils.deleteRecursive(list[i]);
            }
        }
        FileUtils.delete(fileName);
    }

    public static String translateFileName(String fileName) {
        if (fileName != null && fileName.startsWith("~")) {
            String userDir = System.getProperty("user.home");
            fileName = userDir + fileName.substring(1);
        }
        return fileName;
    }

    public static boolean isAbsolute(String fileName) {
        fileName = FileUtils.translateFileName(fileName);
        File file = new File(fileName);
        return file.isAbsolute();
    }

    public static String getAbsolutePath(String fileName) {
        fileName = FileUtils.translateFileName(fileName);
        File parent = new File(fileName).getAbsoluteFile();
        return parent.getAbsolutePath();
    }

    public static long getLastModified(String fileName) {
        fileName = FileUtils.translateFileName(fileName);
        return new File(fileName).lastModified();
    }

    public static Reader openFileReader(String fileName) throws IOException {
        fileName = FileUtils.translateFileName(fileName);
        return new FileReader(fileName);
    }

    public static boolean canWrite(String fileName) {
        fileName = FileUtils.translateFileName(fileName);
        return new File(fileName).canWrite();
    }

    static void trace(String method, String fileName, Object o) {
        if (SysProperties.TRACE_IO) {
            System.out.println("FileUtils." + method + " " + fileName + " " + o);
        }
    }
}

