/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public abstract class BaseIndex
extends SchemaObjectBase
implements Index {
    protected Column[] columns;
    protected int[] columnIndex;
    protected Table table;
    protected IndexType indexType;
    protected long rowCount;

    public BaseIndex(Table table, int id, String name, Column[] columns, IndexType indexType) {
        super(table.getSchema(), id, name, "index");
        this.indexType = indexType;
        this.table = table;
        if (columns != null) {
            this.columns = columns;
            this.columnIndex = new int[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                this.columnIndex[i] = columns[i].getColumnId();
            }
        }
    }

    public String getDropSQL() {
        return null;
    }

    public SQLException getDuplicateKeyException() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getName());
        buff.append(" ");
        buff.append(" ON ");
        buff.append(this.table.getSQL());
        buff.append("(");
        buff.append(this.getColumnListSQL());
        buff.append(")");
        return Message.getSQLException(23001, buff.toString());
    }

    public String getPlanSQL() {
        return this.getSQL();
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        this.table.removeIndex(this);
        this.remove(session);
    }

    public abstract void close(Session var1) throws SQLException;

    public abstract void add(Session var1, Row var2) throws SQLException;

    public abstract void remove(Session var1, Row var2) throws SQLException;

    public abstract Cursor find(Session var1, SearchRow var2, SearchRow var3) throws SQLException;

    public abstract double getCost(Session var1, int[] var2) throws SQLException;

    public abstract void remove(Session var1) throws SQLException;

    public abstract void truncate(Session var1) throws SQLException;

    public abstract boolean canGetFirstOrLast(boolean var1);

    public abstract SearchRow findFirstOrLast(Session var1, boolean var2) throws SQLException;

    public abstract boolean needRebuild();

    public long getRowCount(Session session) {
        return this.rowCount;
    }

    public int getLookupCost(long rowCount) {
        return 2;
    }

    public long getCostRangeIndex(int[] masks, long rowCount) throws SQLException {
        long cost = rowCount += 1000L;
        int totalSelectivity = 0;
        for (int i = 0; masks != null && i < this.columns.length; ++i) {
            long rowsSelected;
            Column column = this.columns[i];
            int index = column.getColumnId();
            int mask = masks[index];
            if ((mask & 1) == 1) {
                if (i == this.columns.length - 1 && this.getIndexType().isUnique()) {
                    cost = this.getLookupCost(rowCount) + 1;
                    break;
                }
                long distinctRows = rowCount * (long)(totalSelectivity = 100 - (100 - totalSelectivity) * (100 - column.getSelectivity()) / 100) / 100L;
                if (distinctRows <= 0L) {
                    distinctRows = 1L;
                }
                if ((rowsSelected = rowCount / distinctRows) < 1L) {
                    rowsSelected = 1L;
                }
            } else {
                if ((mask & 6) == 6) {
                    cost = (long)this.getLookupCost(rowCount) + rowCount / 4L;
                    break;
                }
                if ((mask & 2) == 2) {
                    cost = (long)this.getLookupCost(rowCount) + rowCount / 3L;
                    break;
                }
                if ((mask & 4) != 4) break;
                cost = rowCount / 3L;
                break;
            }
            cost = (long)this.getLookupCost(rowCount) + rowsSelected;
        }
        return cost;
    }

    public int compareRows(SearchRow rowData, SearchRow compare) throws SQLException {
        for (int i = 0; i < this.columns.length; ++i) {
            int index = this.columnIndex[i];
            Value v = compare.getValue(index);
            if (v == null) {
                return 0;
            }
            int c = this.compareValues(rowData.getValue(index), v);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public boolean isNull(Row newRow) {
        for (int i = 0; i < this.columns.length; ++i) {
            int index = this.columnIndex[i];
            Value v = newRow.getValue(index);
            if (v != ValueNull.INSTANCE) continue;
            return true;
        }
        return false;
    }

    public int compareKeys(SearchRow rowData, SearchRow compare) {
        int k2;
        int k1 = rowData.getPos();
        if (k1 == (k2 = compare.getPos())) {
            return 0;
        }
        return k1 > k2 ? 1 : -1;
    }

    private int compareValues(Value v1, Value v2) throws SQLException {
        if (v1 == null) {
            if (v2 == null) {
                return 0;
            }
            return 1;
        }
        if (v2 == null) {
            return -1;
        }
        return this.database.compareTypeSave(v1, v2);
    }

    public int getColumnIndex(Column col) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] != col) continue;
            return i;
        }
        return -1;
    }

    public String getColumnListSQL() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.columns[i].getSQL());
        }
        return buff.toString();
    }

    public String getCreateSQLForCopy(Table table, String quotedName) {
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE ");
        buff.append(this.indexType.getSQL());
        if (!this.indexType.isPrimaryKey()) {
            buff.append(' ');
            buff.append(quotedName);
        }
        buff.append(" ON ");
        buff.append(table.getSQL());
        if (this.comment != null) {
            buff.append(" COMMENT ");
            buff.append(StringUtils.quoteStringSQL(this.comment));
        }
        buff.append("(");
        buff.append(this.getColumnListSQL());
        buff.append(")");
        return buff.toString();
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public int getType() {
        return 1;
    }

    public Table getTable() {
        return this.table;
    }

    public void commit(int operation, Row row) throws SQLException {
    }
}

