/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Prepared;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.SchemaCommand;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;
import org.h2.value.DataType;

public class CreateTable
extends SchemaCommand {
    private String tableName;
    private ObjectArray constraintCommands = new ObjectArray();
    private ObjectArray columns = new ObjectArray();
    private String[] pkColumnNames;
    private boolean ifNotExists;
    private boolean persistent = true;
    private boolean hashPrimaryKey;
    private boolean temporary;
    private boolean globalTemporary;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;
    private Query asQuery;
    private String comment;
    private boolean clustered;

    public CreateTable(Session session, Schema schema) {
        super(session, schema);
    }

    public void setQuery(Query query) {
        this.asQuery = query;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public void addConstraintCommand(Prepared command) throws SQLException {
        if (command instanceof CreateIndex) {
            CreateIndex create = (CreateIndex)command;
            if (create.getPrimaryKey()) {
                this.setPrimaryKeyColumnNames(create.getColumnNames());
                this.setHashPrimaryKey(create.getHash());
            } else {
                this.constraintCommands.add(command);
            }
        } else {
            this.constraintCommands.add(command);
        }
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update() throws SQLException {
        block22: {
            Column c;
            int i;
            this.session.commit(true);
            Database db = this.session.getDatabase();
            if (!db.isPersistent()) {
                this.persistent = false;
            }
            if (this.getSchema().findTableOrView(this.session, this.tableName) != null) {
                if (this.ifNotExists) {
                    return 0;
                }
                throw Message.getSQLException(42101, this.tableName);
            }
            if (this.asQuery != null) {
                this.generateColumnFromQuery();
            }
            if (this.pkColumnNames != null) {
                int len = this.pkColumnNames.length;
                for (i = 0; i < this.columns.size(); ++i) {
                    c = (Column)this.columns.get(i);
                    for (int j = 0; j < len; ++j) {
                        if (!c.getName().equals(this.pkColumnNames[j])) continue;
                        c.setNullable(false);
                    }
                }
            }
            ObjectArray sequences = new ObjectArray();
            for (i = 0; i < this.columns.size(); ++i) {
                Sequence seq;
                c = (Column)this.columns.get(i);
                if (c.getAutoIncrement()) {
                    int objId = this.getObjectId(true, true);
                    c.convertAutoIncrementToSequence(this.session, this.getSchema(), objId, this.temporary);
                }
                if ((seq = c.getSequence()) == null) continue;
                sequences.add(seq);
            }
            int id = this.getObjectId(true, true);
            TableData table = this.getSchema().createTable(this.tableName, id, this.columns, this.persistent, this.clustered);
            table.setComment(this.comment);
            table.setTemporary(this.temporary);
            table.setGlobalTemporary(this.globalTemporary);
            if (this.temporary && !this.globalTemporary) {
                if (this.onCommitDrop) {
                    table.setOnCommitDrop(true);
                }
                if (this.onCommitTruncate) {
                    table.setOnCommitTruncate(true);
                }
                this.session.addLocalTempTable(table);
            } else {
                db.addSchemaObject(this.session, table);
            }
            try {
                int i2;
                for (int i3 = 0; i3 < this.columns.size(); ++i3) {
                    Column c2 = (Column)this.columns.get(i3);
                    c2.prepareExpression(this.session);
                }
                if (this.pkColumnNames != null) {
                    Column[] pk = table.getColumns(this.pkColumnNames);
                    int indexId = this.getObjectId(true, false);
                    table.addIndex(this.session, null, indexId, pk, IndexType.createPrimaryKey(this.persistent, this.hashPrimaryKey), -1, null);
                }
                for (i2 = 0; i2 < sequences.size(); ++i2) {
                    Sequence sequence = (Sequence)sequences.get(i2);
                    table.addSequence(sequence);
                }
                for (i2 = 0; i2 < this.constraintCommands.size(); ++i2) {
                    Prepared command = (Prepared)this.constraintCommands.get(i2);
                    command.update();
                }
                if (this.asQuery == null) break block22;
                boolean old = this.session.getUndoLogEnabled();
                try {
                    this.session.setUndoLogEnabled(false);
                    Insert insert = null;
                    insert = new Insert(this.session);
                    insert.setQuery(this.asQuery);
                    insert.setTable(table);
                    insert.prepare();
                    insert.update();
                }
                finally {
                    this.session.setUndoLogEnabled(old);
                }
            }
            catch (SQLException e) {
                db.checkPowerOff();
                db.removeSchemaObject(this.session, table);
                throw e;
            }
        }
        return 0;
    }

    private void generateColumnFromQuery() throws SQLException {
        this.asQuery.prepare();
        int columnCount = this.asQuery.getColumnCount();
        ObjectArray expressions = this.asQuery.getExpressions();
        for (int i = 0; i < columnCount; ++i) {
            int scale;
            Expression expr = (Expression)expressions.get(i);
            int type = expr.getType();
            String name = expr.getColumnName();
            long precision = expr.getPrecision();
            DataType dt = DataType.getDataType(type);
            if (precision > 0L && (dt.defaultPrecision == 0L || dt.defaultPrecision > precision && dt.defaultPrecision < 127L)) {
                precision = dt.defaultPrecision;
            }
            if ((scale = expr.getScale()) > 0 && (dt.defaultScale == 0 || dt.defaultScale > scale)) {
                precision = dt.defaultScale;
            }
            Column col = new Column(name, type, precision, scale);
            this.addColumn(col);
        }
    }

    public void setPrimaryKeyColumnNames(String[] colNames) throws SQLException {
        if (this.pkColumnNames != null) {
            if (colNames.length != this.pkColumnNames.length) {
                throw Message.getSQLException(90017);
            }
            for (int i = 0; i < colNames.length; ++i) {
                if (colNames[i].equals(this.pkColumnNames[i])) continue;
                throw Message.getSQLException(90017);
            }
        }
        this.pkColumnNames = colNames;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setHashPrimaryKey(boolean b) {
        this.hashPrimaryKey = b;
    }

    public void setGlobalTemporary(boolean globalTemporary) {
        this.globalTemporary = globalTemporary;
    }

    public void setOnCommitDrop() {
        this.onCommitDrop = true;
    }

    public void setOnCommitTruncate() {
        this.onCommitTruncate = true;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }
}

