/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.sql.SQLException;
import org.h2.tools.Server;
import org.h2.util.IOUtils;
import org.h2.util.StartBrowser;

public class Console
implements ActionListener,
MouseListener {
    private Font font;
    private Image icon;
    private Server web;

    public static void main(String[] args) throws Exception {
        new Console().run(args);
    }

    private void run(String[] args) {
        try {
            this.web = Server.createWebServer(args);
            this.web.start();
        }
        catch (SQLException e) {
            if (this.web == null) {
                e.printStackTrace();
            }
            System.out.println(this.web.getStatus());
        }
        Server tcp = null;
        Server pg = null;
        try {
            tcp = Server.createTcpServer(args);
            tcp.start();
        }
        catch (SQLException e) {
            if (tcp == null) {
                e.printStackTrace();
            }
            System.out.println(tcp.getStatus());
        }
        try {
            pg = Server.createPgServer(args);
            pg.start();
        }
        catch (SQLException e) {
            if (pg == null) {
                e.printStackTrace();
            }
            System.out.println(pg.getStatus());
        }
        if (!GraphicsEnvironment.isHeadless()) {
            this.font = new Font("Dialog", 0, 11);
            try {
                InputStream in = this.getClass().getResourceAsStream("/org/h2/res/h2.png");
                if (in != null) {
                    byte[] imageData = IOUtils.readBytesAndClose(in, -1);
                    this.icon = Toolkit.getDefaultToolkit().createImage(imageData);
                }
                if (!this.createTrayIcon()) {
                    this.showWindow(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        StartBrowser.openURL(this.web.getURL());
        if (!this.web.isRunning()) {
            System.exit(1);
        }
    }

    private boolean createTrayIcon() {
        try {
            Boolean supported = (Boolean)Class.forName("java.awt.SystemTray").getMethod("isSupported", new Class[0]).invoke(null, new Object[0]);
            if (!supported.booleanValue()) {
                return false;
            }
            PopupMenu menuConsole = new PopupMenu();
            MenuItem itemConsole = new MenuItem("H2 Console");
            itemConsole.setActionCommand("console");
            itemConsole.addActionListener(this);
            itemConsole.setFont(this.font);
            menuConsole.add(itemConsole);
            MenuItem itemStatus = new MenuItem("Status");
            itemStatus.setActionCommand("status");
            itemStatus.addActionListener(this);
            itemStatus.setFont(this.font);
            menuConsole.add(itemStatus);
            MenuItem itemExit = new MenuItem("Exit");
            itemExit.setFont(this.font);
            itemExit.setActionCommand("exit");
            itemExit.addActionListener(this);
            menuConsole.add(itemExit);
            Object trayIcon = Class.forName("java.awt.TrayIcon").getConstructor(Image.class, String.class, PopupMenu.class).newInstance(this.icon, "H2 Database Engine", menuConsole);
            Object tray = Class.forName("java.awt.SystemTray").getMethod("getSystemTray", new Class[0]).invoke(null, new Object[0]);
            trayIcon.getClass().getMethod("addMouseListener", MouseListener.class).invoke(trayIcon, this);
            tray.getClass().getMethod("add", Class.forName("java.awt.TrayIcon")).invoke(tray, trayIcon);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void showWindow(final boolean exit) {
        final Frame frame = new Frame("H2 Console");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                if (exit) {
                    System.exit(0);
                } else {
                    frame.dispose();
                }
            }
        });
        if (this.icon != null) {
            frame.setIconImage(this.icon);
        }
        frame.setResizable(false);
        frame.setBackground(SystemColor.control);
        GridBagLayout layout = new GridBagLayout();
        frame.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        c.insets.left = 2;
        c.insets.right = 2;
        c.insets.top = 2;
        c.insets.bottom = 2;
        Label label = new Label("H2 Console URL:", 0);
        label.setFont(this.font);
        c.anchor = 17;
        c.gridwidth = 13;
        frame.add((Component)label, c);
        TextField text = new TextField();
        text.setEditable(false);
        text.setFont(this.font);
        text.setText(this.web.getURL());
        text.setFocusable(false);
        c.anchor = 13;
        c.gridwidth = 0;
        frame.add((Component)text, c);
        Label label2 = new Label();
        c.anchor = 17;
        c.gridwidth = 13;
        frame.add((Component)label2, c);
        Button startBrowser = new Button("Start Browser");
        startBrowser.setFocusable(false);
        startBrowser.setActionCommand("console");
        startBrowser.addActionListener(this);
        startBrowser.setFont(this.font);
        c.anchor = 13;
        c.gridwidth = 0;
        frame.add((Component)startBrowser, c);
        int width = 250;
        int height = 120;
        frame.setSize(width, height);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((screenSize.width - width) / 2, (screenSize.height - height) / 2);
        frame.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("exit".equals(command)) {
            System.exit(0);
        } else if ("console".equals(command)) {
            this.startBrowser();
        } else if ("status".equals(command)) {
            this.showWindow(false);
        }
    }

    private void startBrowser() {
        if (this.web != null) {
            StartBrowser.openURL(this.web.getURL());
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            this.startBrowser();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

