/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.sql.SQLException;
import org.h2.tools.Server;
import org.h2.util.IOUtils;
import org.h2.util.StartBrowser;

public class Console
implements ActionListener,
MouseListener {
    private static final Font FONT = new Font("Dialog", 0, 11);
    private Server web;

    public static void main(String[] args) throws Exception {
        new Console().run(args);
    }

    private void run(String[] args) {
        try {
            this.web = Server.createWebServer(args);
            this.web.start();
            Server.createTcpServer(args).start();
            Server.createOdbcServer(args).start();
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 90061) {
                System.out.println("Port is in use, maybe another server server already running on " + this.web.getURL());
            }
            e.printStackTrace();
        }
        try {
            InputStream in = this.getClass().getResourceAsStream("/org/h2/res/h2.png");
            Image image = null;
            if (in != null) {
                byte[] imageData = IOUtils.readBytesAndClose(in, -1);
                image = Toolkit.getDefaultToolkit().createImage(imageData);
            }
            if (!this.createTrayIcon(image)) {
                this.showWindow(image);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StartBrowser.openURL(this.web.getURL());
        if (!this.web.isRunning()) {
            System.exit(1);
        }
    }

    private boolean createTrayIcon(Image image) {
        try {
            Boolean supported = (Boolean)Class.forName("java.awt.SystemTray").getMethod("isSupported", new Class[0]).invoke(null, new Object[0]);
            if (!supported.booleanValue()) {
                return false;
            }
            PopupMenu menuConsole = new PopupMenu();
            MenuItem itemConsole = new MenuItem("H2 Console");
            itemConsole.setActionCommand("console");
            itemConsole.addActionListener(this);
            itemConsole.setFont(FONT);
            menuConsole.add(itemConsole);
            MenuItem itemExit = new MenuItem("Exit");
            itemExit.setFont(FONT);
            itemExit.setActionCommand("exit");
            itemExit.addActionListener(this);
            menuConsole.add(itemExit);
            Object icon = Class.forName("java.awt.TrayIcon").getConstructor(Image.class, String.class, PopupMenu.class).newInstance(image, "H2 Database Engine", menuConsole);
            Object tray = Class.forName("java.awt.SystemTray").getMethod("getSystemTray", new Class[0]).invoke(null, new Object[0]);
            icon.getClass().getMethod("addMouseListener", MouseListener.class).invoke(icon, this);
            tray.getClass().getMethod("add", Class.forName("java.awt.TrayIcon")).invoke(tray, icon);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void showWindow(Image image) {
        Frame frame = new Frame("H2 Console");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        if (image != null) {
            frame.setIconImage(image);
        }
        frame.setResizable(false);
        frame.setBackground(SystemColor.control);
        GridBagLayout layout = new GridBagLayout();
        frame.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        c.insets.left = 2;
        c.insets.right = 2;
        c.insets.top = 2;
        c.insets.bottom = 2;
        Label label = new Label("H2 Console URL:", 0);
        label.setFont(FONT);
        c.anchor = 17;
        c.gridwidth = 13;
        frame.add((Component)label, c);
        TextField text = new TextField();
        text.setEditable(false);
        text.setFont(FONT);
        text.setText(this.web.getURL());
        text.setFocusable(false);
        c.anchor = 13;
        c.gridwidth = 0;
        frame.add((Component)text, c);
        Label label2 = new Label();
        c.anchor = 17;
        c.gridwidth = 13;
        frame.add((Component)label2, c);
        Button startBrowser = new Button("Start Browser");
        startBrowser.setFocusable(false);
        startBrowser.setActionCommand("console");
        startBrowser.addActionListener(this);
        startBrowser.setFont(FONT);
        c.anchor = 13;
        c.gridwidth = 0;
        frame.add((Component)startBrowser, c);
        int width = 250;
        int height = 120;
        frame.setSize(width, height);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((screenSize.width - width) / 2, (screenSize.height - height) / 2);
        frame.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("exit")) {
            System.exit(0);
        } else if (e.getActionCommand().equals("console")) {
            this.startBrowser();
        }
    }

    private void startBrowser() {
        if (this.web != null) {
            StartBrowser.openURL(this.web.getURL());
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            this.startBrowser();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

