/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import org.h2.command.dml.Select;
import org.h2.engine.Constants;
import org.h2.engine.Session;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexCondition;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.Value;

public class TableFilter
implements ColumnResolver {
    private Session session;
    private Table table;
    private String alias;
    private static final int BEFORE_FIRST = 0;
    private static final int FOUND = 1;
    private static final int AFTER_LAST = 2;
    private static final int NULL_ROW = 3;
    private Index index;
    private Cursor cursor;
    private int scanCount;
    private boolean used;
    private Select select;
    private ObjectArray indexConditions = new ObjectArray();
    private Expression filterCondition;
    private Expression joinCondition;
    private Row current;
    private int state;
    private ObjectArray joins;
    private boolean outerJoin;
    private boolean foundOne;
    private Expression fullCondition;
    private boolean rightsChecked;

    public TableFilter(Session session, Table table, String alias, boolean rightsChecked, Select select) {
        this.session = session;
        this.table = table;
        this.alias = alias;
        this.rightsChecked = rightsChecked;
        this.select = select;
    }

    public Select getSelect() {
        return this.select;
    }

    public Session getSession() {
        return this.session;
    }

    public Table getTable() {
        return this.table;
    }

    public void lock(Session session, boolean exclusive) throws SQLException {
        if (!this.rightsChecked) {
            session.getUser().checkRight(this.table, 1);
        }
        this.table.lock(session, exclusive);
        for (int i = 0; this.joins != null && i < this.joins.size(); ++i) {
            this.getTableFilter(i).lock(session, exclusive);
        }
    }

    private TableFilter getTableFilter(int i) {
        return (TableFilter)this.joins.get(i);
    }

    public PlanItem getBestPlanItem(Session session) throws SQLException {
        PlanItem item;
        if (this.indexConditions.size() == 0) {
            item = new PlanItem();
            item.setIndex(this.table.getScanIndex(session));
            item.cost = item.getIndex().getCost(null);
        } else {
            int len = this.table.getColumns().length;
            int[] masks = new int[len];
            for (int i = 0; i < this.indexConditions.size(); ++i) {
                int id;
                IndexCondition condition = (IndexCondition)this.indexConditions.get(i);
                if (!condition.isEvaluatable()) continue;
                if (condition.isAlwaysFalse()) {
                    masks = null;
                    break;
                }
                int n = id = condition.getColumn().getColumnId();
                masks[n] = masks[n] | condition.getMask();
            }
            item = this.table.getBestPlanItem(session, masks);
        }
        for (int i = 0; this.joins != null && i < this.joins.size(); ++i) {
            TableFilter join = this.getTableFilter(i);
            this.setEvaluatable(join);
            item.setJoinPlan(join.getBestPlanItem(session));
            item.cost += item.cost * item.getJoinPlan().cost;
        }
        return item;
    }

    private void setEvaluatable(TableFilter join) {
        do {
            Expression e;
            if ((e = join.getJoinCondition()) == null) continue;
            e.setEvaluatable(this, true);
        } while ((join = join.getJoin()) != null);
    }

    public void setPlanItem(PlanItem item) {
        this.index = item.getIndex();
        for (int i = 0; this.joins != null && i < this.joins.size(); ++i) {
            TableFilter join = this.getTableFilter(i);
            if (item.getJoinPlan() == null) continue;
            join.setPlanItem(item.getJoinPlan());
        }
    }

    public void prepare() {
        int i;
        for (i = 0; i < this.indexConditions.size(); ++i) {
            Column col;
            IndexCondition condition = (IndexCondition)this.indexConditions.get(i);
            if (condition.isAlwaysFalse() || this.index.getColumnIndex(col = condition.getColumn()) >= 0) continue;
            this.indexConditions.remove(i);
            --i;
        }
        for (i = 0; this.joins != null && i < this.joins.size(); ++i) {
            TableFilter join = this.getTableFilter(i);
            if (Constants.CHECK && join == this) {
                throw Message.getInternalError("self join");
            }
            join.prepare();
        }
    }

    public void startQuery() {
        this.scanCount = 0;
        for (int i = 0; this.joins != null && i < this.joins.size(); ++i) {
            TableFilter join = this.getTableFilter(i);
            join.startQuery();
        }
    }

    public void reset() throws SQLException {
        for (int i = 0; this.joins != null && i < this.joins.size(); ++i) {
            TableFilter join = this.getTableFilter(i);
            join.reset();
        }
        this.state = 0;
        this.foundOne = false;
    }

    public boolean next() throws SQLException {
        TableFilter join;
        boolean alwaysFalse = false;
        if (this.state == 2) {
            return false;
        }
        if (this.state == 0) {
            int i;
            Row start = null;
            Row end = null;
            for (i = 0; i < this.indexConditions.size(); ++i) {
                IndexCondition condition = (IndexCondition)this.indexConditions.get(i);
                if (condition.isAlwaysFalse()) {
                    alwaysFalse = true;
                    break;
                }
                Column column = condition.getColumn();
                int type = column.getType();
                int id = column.getColumnId();
                Value v = condition.getCurrentValue(this.session).convertTo(type);
                if (condition.isStart()) {
                    if (start == null) {
                        start = this.table.getTemplateRow();
                    }
                    start.setValue(id, v);
                }
                if (!condition.isEnd()) continue;
                if (end == null) {
                    end = this.table.getTemplateRow();
                }
                end.setValue(id, v);
            }
            if (!alwaysFalse) {
                this.cursor = this.index.find(this.session, start, end);
                for (i = 0; this.joins != null && i < this.joins.size(); ++i) {
                    join = this.getTableFilter(i);
                    join.reset();
                }
            }
        } else {
            boolean found = this.joins != null;
            for (int i = 0; this.joins != null && i < this.joins.size(); ++i) {
                TableFilter join2 = this.getTableFilter(i);
                if (join2.next()) continue;
                found = false;
                break;
            }
            if (found) {
                return true;
            }
        }
        while (this.state != 3) {
            if (alwaysFalse) {
                this.state = 2;
            } else {
                ++this.scanCount;
                if (this.cursor.next()) {
                    this.current = this.cursor.get();
                    this.state = 1;
                } else {
                    this.state = 2;
                }
            }
            if (this.state == 2) {
                if (!this.outerJoin || this.foundOne) break;
                this.state = 3;
                this.current = this.table.getNullRow();
            }
            if (!this.isOk(this.filterCondition)) continue;
            boolean joinConditionOk = this.isOk(this.joinCondition);
            if (this.state == 1 && joinConditionOk) {
                this.foundOne = true;
            }
            for (int i = 0; this.joins != null && i < this.joins.size(); ++i) {
                TableFilter join3 = this.getTableFilter(i);
                join3.reset();
            }
            boolean doContinue = false;
            for (int i = 0; this.joins != null && i < this.joins.size(); ++i) {
                join = this.getTableFilter(i);
                if (join.next()) continue;
                doContinue = true;
            }
            if (doContinue || this.state != 3 && !joinConditionOk) continue;
            return true;
        }
        this.state = 2;
        return false;
    }

    private boolean isOk(Expression condition) throws SQLException {
        if (condition == null) {
            return true;
        }
        return Boolean.TRUE.equals(condition.getBooleanValue(this.session));
    }

    public Row get() {
        return this.current;
    }

    public void set(Row current) {
        this.current = current;
    }

    public String getTableAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.table.getName();
    }

    public void addIndexCondition(IndexCondition condition) {
        this.indexConditions.add(condition);
    }

    public void addFilterCondition(Expression condition, boolean join) {
        if (join) {
            this.joinCondition = this.joinCondition == null ? condition : new ConditionAndOr(0, this.joinCondition, condition);
        } else {
            this.filterCondition = this.filterCondition == null ? condition : new ConditionAndOr(0, this.filterCondition, condition);
        }
    }

    public void addJoin(TableFilter filter, boolean outer, Expression on) throws SQLException {
        if (on != null) {
            on.mapColumns(this, 0);
        }
        if (this.joins == null) {
            this.joins = new ObjectArray();
            this.joins.add(filter);
            filter.outerJoin = outer;
            if (on != null) {
                filter.mapAndAddFilter(on);
            }
        } else {
            TableFilter join = this.getTableFilter(0);
            join.addJoin(filter, outer, on);
        }
        if (on != null) {
            on.optimize(this.session);
        }
    }

    private void mapAndAddFilter(Expression on) throws SQLException {
        on.mapColumns(this, 0);
        this.addFilterCondition(on, true);
        on.createIndexConditions(this);
        for (int i = 0; this.joins != null && i < this.joins.size(); ++i) {
            TableFilter join = this.getTableFilter(i);
            join.mapAndAddFilter(on);
        }
    }

    public TableFilter getJoin() {
        return this.joins == null ? null : this.getTableFilter(0);
    }

    public boolean isJoinOuter() {
        return this.outerJoin;
    }

    public String getPlanSQL(boolean join) {
        Object condition;
        StringBuffer buff = new StringBuffer();
        if (join) {
            if (this.outerJoin) {
                buff.append("LEFT OUTER JOIN ");
            } else {
                buff.append("INNER JOIN ");
            }
        }
        buff.append(this.table.getSQL());
        if (this.alias != null && !this.table.getName().equals(this.alias)) {
            buff.append(' ');
            buff.append(this.alias);
        }
        buff.append(" /* ");
        StringBuffer planBuff = new StringBuffer();
        planBuff.append(this.index.getPlanSQL());
        if (this.indexConditions.size() > 0) {
            planBuff.append(": ");
            for (int i = 0; i < this.indexConditions.size(); ++i) {
                condition = (IndexCondition)this.indexConditions.get(i);
                if (i > 0) {
                    planBuff.append(" AND ");
                }
                planBuff.append(((IndexCondition)condition).getSQL());
            }
        }
        String plan = planBuff.toString();
        plan = StringUtils.quoteRemarkSQL(plan);
        buff.append(plan);
        buff.append(" */");
        if (this.joinCondition != null) {
            buff.append(" ON ");
            buff.append(StringUtils.unEnclose(this.joinCondition.getSQL()));
        }
        if (this.filterCondition != null) {
            buff.append(" /* WHERE ");
            condition = StringUtils.unEnclose(this.filterCondition.getSQL());
            condition = StringUtils.quoteRemarkSQL((String)condition);
            buff.append((String)condition);
            buff.append("*/");
        }
        return buff.toString();
    }

    public void removeUnusableIndexConditions() {
        for (int i = 0; i < this.indexConditions.size(); ++i) {
            IndexCondition cond = (IndexCondition)this.indexConditions.get(i);
            if (cond.isEvaluatable()) continue;
            this.indexConditions.remove(i--);
        }
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public boolean getUsed() {
        return this.used;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void removeJoin() {
        this.joins = null;
    }

    public Expression getJoinCondition() {
        return this.joinCondition;
    }

    public void removeJoinCondition() {
        this.joinCondition = null;
    }

    public Expression getFilterCondition() {
        return this.filterCondition;
    }

    public void removeFilterCondition() {
        this.filterCondition = null;
    }

    public void setFullCondition(Expression condition) {
        this.fullCondition = condition;
        for (int i = 0; this.joins != null && i < this.joins.size(); ++i) {
            TableFilter join = this.getTableFilter(i);
            join.setFullCondition(condition);
        }
    }

    public void optimizeFullCondition(boolean fromOuterJoin) {
        if (this.fullCondition != null) {
            this.fullCondition.addFilterConditions(this, fromOuterJoin || this.outerJoin);
            for (int i = 0; this.joins != null && i < this.joins.size(); ++i) {
                TableFilter join = this.getTableFilter(i);
                join.optimizeFullCondition(fromOuterJoin || this.outerJoin);
            }
        }
    }

    public void setEvaluatable(TableFilter filter, boolean b) {
        if (this.filterCondition != null) {
            this.filterCondition.setEvaluatable(filter, b);
        }
        if (this.joinCondition != null) {
            this.joinCondition.setEvaluatable(filter, b);
        }
        for (int i = 0; this.joins != null && i < this.joins.size(); ++i) {
            TableFilter join = this.getTableFilter(i);
            join.setEvaluatable(filter, b);
        }
    }

    public String getSchemaName() {
        return this.table.getSchema().getName();
    }

    public Column[] getColumns() {
        return this.table.getColumns();
    }

    public Value getValue(Column column) {
        return this.current == null ? null : this.current.getValue(column.getColumnId());
    }

    public TableFilter getTableFilter() {
        return this;
    }
}

