/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.command.Parser;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.SequenceValue;
import org.h2.expression.ValueExpression;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.SingleColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public class Column {
    private Table table;
    private String name;
    private int type;
    private long precision;
    private int scale;
    private int columnId;
    private boolean nullable = true;
    private Expression defaultExpression;
    private Expression checkConstraint;
    private String checkConstraintSQL;
    private String originalSQL;
    private boolean autoIncrement;
    private long start;
    private long increment;
    private boolean convertNullToDefault;
    private Sequence sequence;
    private boolean isComputed;
    private TableFilter computeTableFilter;
    private int selectivity;
    private SingleColumnResolver resolver;
    private String comment;
    private boolean primaryKey;
    public static final int NOT_NULLABLE = 0;
    public static final int NULLABLE = 1;
    public static final int NULLABLE_UNKNOWN = 2;

    public Column(String name, int type, long precision, int scale) {
        this.name = name;
        this.type = type;
        this.precision = precision;
        this.scale = scale;
    }

    public Column getClone() {
        Column newColumn = new Column(this.name, this.type, this.precision, this.scale);
        newColumn.nullable = this.nullable;
        newColumn.defaultExpression = this.defaultExpression;
        newColumn.originalSQL = this.originalSQL;
        newColumn.convertNullToDefault = this.convertNullToDefault;
        newColumn.sequence = this.sequence;
        newColumn.comment = this.comment;
        newColumn.isComputed = this.isComputed;
        newColumn.selectivity = this.selectivity;
        newColumn.primaryKey = this.primaryKey;
        return newColumn;
    }

    public boolean getComputed() {
        return this.isComputed;
    }

    public Value computeValue(Session session, Row row) throws SQLException {
        this.computeTableFilter.setSession(session);
        this.computeTableFilter.set(row);
        return this.defaultExpression.getValue(session);
    }

    public void setComputed(boolean computed, Expression expression) {
        this.isComputed = computed;
        this.defaultExpression = expression;
    }

    void setTable(Table table, int columnId) {
        this.table = table;
        this.columnId = columnId;
    }

    public Table getTable() {
        return this.table;
    }

    public void setDefaultExpression(Session session, Expression defaultExpression) throws SQLException {
        if (defaultExpression != null && (defaultExpression = defaultExpression.optimize(session)).isConstant()) {
            defaultExpression = ValueExpression.get(defaultExpression.getValue(session));
        }
        this.defaultExpression = defaultExpression;
    }

    public int getColumnId() {
        return this.columnId;
    }

    public String getSQL() {
        return Parser.quoteIdentifier(this.name);
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public long getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setNullable(boolean b) {
        this.nullable = b;
    }

    public Value validateConvertUpdateSequence(Session session, Value value) throws SQLException {
        if (value == null) {
            if (this.defaultExpression == null) {
                value = ValueNull.INSTANCE;
            } else {
                value = this.defaultExpression.getValue(session).convertTo(this.type);
                if (this.primaryKey) {
                    session.setLastIdentity(value);
                }
            }
        }
        if (value == ValueNull.INSTANCE) {
            if (this.convertNullToDefault) {
                value = this.defaultExpression.getValue(session).convertTo(this.type);
            }
            if (value == ValueNull.INSTANCE && !this.nullable) {
                if (Mode.getCurrentMode().convertInsertNullToZero) {
                    DataType dt = DataType.getDataType(this.type);
                    value = dt.decimal ? ValueInt.get(0).convertTo(this.type) : (dt.type == 11 ? ValueTimestamp.getNoCopy(new Timestamp(System.currentTimeMillis())) : (dt.type == 9 ? ValueTime.get(Time.valueOf("0:0:0")) : (dt.type == 10 ? ValueTimestamp.getNoCopy(new Timestamp(System.currentTimeMillis())).convertTo(dt.type) : ValueString.get("").convertTo(this.type))));
                } else {
                    throw Message.getSQLException(90006, this.name);
                }
            }
        }
        if (this.checkConstraint != null) {
            this.resolver.setValue(value);
            Value v = this.checkConstraint.getValue(session);
            if (Boolean.FALSE.equals(v.getBoolean())) {
                throw Message.getSQLException(23000, this.checkConstraint.getSQL());
            }
        }
        value = value.convertScale(Mode.getCurrentMode().convertOnlyToSmallerScale, this.scale);
        if (this.precision > 0L && value.getPrecision() > this.precision) {
            throw Message.getSQLException(90005, this.name);
        }
        this.updateSequenceIfRequired(session, value);
        return value;
    }

    private void updateSequenceIfRequired(Session session, Value value) throws SQLException {
        if (this.sequence != null) {
            long current = this.sequence.getCurrentValue();
            long increment = this.sequence.getIncrement();
            long now = value.getLong();
            boolean update = false;
            if (increment > 0L && now > current) {
                update = true;
            } else if (increment < 0L && now < current) {
                update = true;
            }
            if (update) {
                this.sequence.setStartValue(now + increment);
                session.setLastIdentity(ValueLong.get(now));
                this.sequence.flush();
            }
        }
    }

    public void convertAutoIncrementToSequence(Session session, Schema schema, int id, boolean temporary) throws SQLException {
        String sequenceName;
        if (!this.autoIncrement) {
            throw Message.getInternalError();
        }
        if (this.originalSQL.equals("IDENTITY")) {
            this.originalSQL = "BIGINT";
        }
        int i = 0;
        while (true) {
            ValueUuid uuid = ValueUuid.getNewRandom();
            String s = uuid.getString();
            s = s.replace('-', '_').toUpperCase();
            sequenceName = "SYSTEM_SEQUENCE_" + s;
            if (schema.findSequence(sequenceName) == null) break;
            ++i;
        }
        Sequence sequence = new Sequence(schema, id, sequenceName, true);
        sequence.setStartValue(this.start);
        sequence.setIncrement(this.increment);
        if (!temporary) {
            session.getDatabase().addSchemaObject(session, sequence);
        }
        this.setAutoIncrement(false, 0L, 0L);
        SequenceValue seq = new SequenceValue(sequence);
        this.setDefaultExpression(session, seq);
        this.setSequence(sequence);
    }

    public void prepareExpression(Session session) throws SQLException {
        if (this.defaultExpression != null) {
            this.computeTableFilter = new TableFilter(session, this.table, null, false, null);
            this.defaultExpression.mapColumns(this.computeTableFilter, 0);
            this.defaultExpression = this.defaultExpression.optimize(session);
        }
    }

    public String getCreateSQL() {
        String sql;
        StringBuffer buff = new StringBuffer();
        if (this.name != null) {
            buff.append(Parser.quoteIdentifier(this.name));
            buff.append(' ');
        }
        if (this.originalSQL != null) {
            buff.append(this.originalSQL);
        } else {
            buff.append(DataType.getDataType((int)this.type).name);
            switch (this.type) {
                case 6: {
                    buff.append("(");
                    buff.append(this.precision);
                    buff.append(", ");
                    buff.append(this.scale);
                    buff.append(")");
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 21: {
                    if (this.precision >= Integer.MAX_VALUE) break;
                    buff.append("(");
                    buff.append(this.precision);
                    buff.append(")");
                }
            }
        }
        if (this.defaultExpression != null && (sql = this.defaultExpression.getSQL()) != null) {
            if (this.isComputed) {
                buff.append(" AS ");
                buff.append(sql);
            } else if (this.defaultExpression != null) {
                buff.append(" DEFAULT ");
                buff.append(sql);
            }
        }
        if (!this.nullable) {
            buff.append(" NOT NULL");
        }
        if (this.convertNullToDefault) {
            buff.append(" NULL_TO_DEFAULT");
        }
        if (this.sequence != null) {
            buff.append(" SEQUENCE ");
            buff.append(this.sequence.getSQL());
        }
        if (this.selectivity != 0) {
            buff.append(" SELECTIVITY ");
            buff.append(this.selectivity);
        }
        if (this.checkConstraint != null) {
            buff.append(" CHECK ");
            buff.append(this.checkConstraintSQL);
        }
        if (this.comment != null) {
            buff.append(" COMMENT ");
            buff.append(StringUtils.quoteStringSQL(this.comment));
        }
        return buff.toString();
    }

    public boolean getNullable() {
        return this.nullable;
    }

    public void setOriginalSQL(String original) {
        this.originalSQL = original;
    }

    public String getOriginalSQL() {
        return this.originalSQL;
    }

    public Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    public boolean getAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoInc, long start, long increment) {
        this.autoIncrement = autoInc;
        this.start = start;
        this.increment = increment;
        this.nullable = false;
        if (autoInc) {
            this.convertNullToDefault = true;
        }
    }

    public void setConvertNullToDefault(boolean convert) {
        this.convertNullToDefault = convert;
    }

    public void rename(String newName) {
        this.name = newName;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public int getSelectivity() {
        return this.selectivity == 0 ? 50 : this.selectivity;
    }

    public void setSelectivity(int selectivity) {
        this.selectivity = selectivity = selectivity < 0 ? 0 : (selectivity > 100 ? 100 : selectivity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCheckConstraint(Session session, Expression expr) throws SQLException {
        this.resolver = new SingleColumnResolver(this);
        Column column = this;
        synchronized (column) {
            String oldName = this.name;
            if (this.name == null) {
                this.name = "VALUE";
            }
            expr.mapColumns(this.resolver, 0);
            this.name = oldName;
        }
        expr = expr.optimize(session);
        this.resolver.setValue(ValueNull.INSTANCE);
        expr.getValue(session);
        this.checkConstraint = this.checkConstraint == null ? expr : new ConditionAndOr(0, this.checkConstraint, expr);
        this.checkConstraintSQL = this.getCheckConstraintSQL(session, this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getCheckConstraint(Session session, String asColumnName) throws SQLException {
        String sql;
        if (this.checkConstraint == null) {
            return null;
        }
        Parser parser = new Parser(session);
        Column column = this;
        synchronized (column) {
            String oldName = this.name;
            this.name = asColumnName;
            sql = this.checkConstraint.getSQL();
            this.name = oldName;
        }
        Expression expr = parser.parseExpression(sql);
        return expr;
    }

    public String getDefaultSQL() {
        return this.defaultExpression == null ? "" : this.defaultExpression.getSQL();
    }

    public int getPrecisionAsInt() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    public DataType getDataType() {
        return DataType.getDataType(this.type);
    }

    public String getCheckConstraintSQL(Session session, String name) throws SQLException {
        Expression constraint = this.getCheckConstraint(session, name);
        return constraint == null ? "" : constraint.getSQL();
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }
}

