/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.RangeCursor;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.RangeTable;
import org.h2.value.Value;
import org.h2.value.ValueLong;

public class RangeIndex
extends Index {
    private long min;
    private long max;

    public RangeIndex(RangeTable table, Column[] columns, long min, long max) {
        super(table, 0, "RANGE_INDEX", columns, IndexType.createNonUnique(true));
        this.min = min;
        this.max = max;
    }

    public void close(Session session) throws SQLException {
    }

    public void add(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void remove(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Cursor find(Session session, SearchRow first, SearchRow last) throws SQLException {
        long start = Math.max(this.min, first == null ? this.min : first.getValue(0).getLong());
        long end = Math.min(this.max, last == null ? this.max : last.getValue(0).getLong());
        return new RangeCursor(start, end);
    }

    public long getCost(int[] masks) throws SQLException {
        return 1L;
    }

    public String getCreateSQL() {
        return null;
    }

    public void remove(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean needRebuild() {
        return false;
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean canGetFirstOrLast(boolean first) {
        return true;
    }

    public Value findFirstOrLast(Session session, boolean first) throws SQLException {
        return ValueLong.get(first ? this.min : this.max);
    }
}

