/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.SQLException;
import org.h2.command.Prepared;
import org.h2.command.dml.ScriptBase;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.util.ScriptReader;
import org.h2.util.StringUtils;

public class RunScriptCommand
extends ScriptBase {
    private String charset = StringUtils.getDefaultCharset();

    public RunScriptCommand(Session session) {
        super(session);
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        int count = 0;
        try {
            String sql;
            this.openInput();
            InputStreamReader reader = new InputStreamReader(this.in, this.charset);
            ScriptReader r = new ScriptReader(reader);
            while ((sql = r.readStatement()) != null) {
                this.execute(sql);
                ++count;
            }
            ((Reader)reader).close();
        }
        catch (IOException e) {
            throw Message.convertIOException(e, null);
        }
        finally {
            this.closeIO();
        }
        return count;
    }

    private void execute(String sql) throws SQLException {
        try {
            Prepared command = this.session.prepare(sql);
            if (command.isQuery()) {
                command.query(0);
            } else {
                command.update();
            }
            if (this.session.getAutoCommit()) {
                this.session.commit();
            }
        }
        catch (SQLException e) {
            throw Message.addSQL(e, sql);
        }
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

