/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.UserDataType;
import org.h2.message.Message;

public class DropUserDataType
extends DefineCommand {
    private String typeName;
    private boolean ifExists;

    public DropUserDataType(Session session) {
        super(session);
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit();
        Database db = this.session.getDatabase();
        UserDataType type = db.findUserDataType(this.typeName);
        if (type == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(90120, this.typeName);
            }
        } else {
            db.removeDatabaseObject(this.session, type);
        }
        return 0;
    }

    public void setTypeName(String name) {
        this.typeName = name;
    }
}

