/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import org.h2.engine.Constants;
import org.h2.message.Message;

public class IntArray {
    private int[] data;
    private int size;
    private int hash;

    public IntArray() {
        this.data = new int[10];
    }

    public IntArray(int[] data) {
        this.data = data;
        this.size = data.length;
    }

    public static int[] clone(int[] array) {
        if (array == null) {
            return null;
        }
        int[] copy = new int[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static boolean equals(int[] a, int[] b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public void add(int value) {
        this.checkCapacity();
        this.data[this.size++] = value;
    }

    public int get(int i) {
        if (Constants.CHECK && i >= this.size) {
            throw new ArrayIndexOutOfBoundsException("i=" + i + " size=" + this.size);
        }
        return this.data[i];
    }

    public int remove(int i) {
        if (Constants.CHECK && i >= this.size) {
            throw new ArrayIndexOutOfBoundsException("i=" + i + " size=" + this.size);
        }
        int value = this.data[i];
        System.arraycopy(this.data, i + 1, this.data, i, this.size - i - 1);
        --this.size;
        return value;
    }

    private void checkCapacity() {
        if (this.size >= this.data.length) {
            int[] d = new int[this.data.length * 2];
            System.arraycopy(this.data, 0, d, 0, this.data.length);
            this.data = d;
        }
    }

    public void add(int i, int value) {
        if (Constants.CHECK && i > this.size) {
            throw new ArrayIndexOutOfBoundsException("i=" + i + " size=" + this.size);
        }
        this.checkCapacity();
        if (i == this.size) {
            this.add(value);
        } else {
            System.arraycopy(this.data, i, this.data, i + 1, this.size - i);
            this.data[i] = value;
            ++this.size;
        }
    }

    public void set(int i, int value) {
        if (Constants.CHECK && i >= this.size) {
            throw new ArrayIndexOutOfBoundsException("i=" + i + " size=" + this.size);
        }
        this.data[i] = value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IntArray)) {
            return false;
        }
        IntArray other = (IntArray)obj;
        if (this.hashCode() != other.hashCode() || this.size != other.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == other.data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int h = this.size + 1;
        for (int i = 0; i < this.size; ++i) {
            h = h * 31 + this.data[i];
        }
        this.hash = h;
        return h;
    }

    public int size() {
        return this.size;
    }

    public void addValueSorted(int value) {
        int l = 0;
        int r = this.size;
        while (l < r) {
            int i = l + r >>> 1;
            int d = this.data[i];
            if (d == value) {
                return;
            }
            if (d > value) {
                r = i;
                continue;
            }
            l = i + 1;
        }
        this.add(l, value);
    }

    public void removeValue(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            this.remove(i);
            return;
        }
        throw Message.getInternalError();
    }

    public int findNextValueIndex(int value) {
        int l = 0;
        int r = this.size;
        while (l < r) {
            int i = l + r >>> 1;
            int d = this.data[i];
            if (d >= value) {
                r = i;
                continue;
            }
            l = i + 1;
        }
        return l;
    }

    public void sort() {
        for (int i = 1; i < this.size(); ++i) {
            int j;
            int t = this.get(i);
            for (j = i - 1; j >= 0 && this.get(j) > t; --j) {
                this.set(j + 1, this.get(j));
            }
            this.set(j + 1, t);
        }
    }

    public void toArray(int[] array) {
        System.arraycopy(this.data, 0, array, 0, this.size);
    }
}

