/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.h2.Driver;
import org.h2.message.Message;
import org.h2.store.FileLister;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;

public class Backup {
    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " -url <url> -user <user> [-password <pwd>] [-script <file>] [-options <option> ...]");
    }

    public static void main(String[] args) throws SQLException {
        new Backup().run(args);
    }

    private void run(String[] args) throws SQLException {
        String url = null;
        String user = null;
        String password = "";
        String script = "backup.sql";
        String options1 = null;
        String options2 = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equals("-url")) {
                url = args[++i];
                continue;
            }
            if (args[i].equals("-user")) {
                user = args[++i];
                continue;
            }
            if (args[i].equals("-password")) {
                password = args[++i];
                continue;
            }
            if (args[i].equals("-script")) {
                script = args[++i];
                continue;
            }
            if (args[i].equals("-options")) {
                StringBuffer buff1 = new StringBuffer();
                StringBuffer buff2 = new StringBuffer();
                ++i;
                while (i < args.length) {
                    String a = args[i];
                    String upper = StringUtils.toUpperEnglish(a);
                    if (upper.startsWith("NO") || upper.equals("DROP")) {
                        buff1.append(' ');
                        buff1.append(args[i]);
                    } else {
                        buff2.append(' ');
                        buff2.append(args[i]);
                    }
                    ++i;
                }
                options1 = buff1.toString();
                options2 = buff2.toString();
                continue;
            }
            this.showUsage();
            return;
        }
        if (url == null || user == null || script == null) {
            this.showUsage();
            return;
        }
        if (options1 != null) {
            Backup.executeScript(url, user, password, script, options1, options2);
        } else {
            Backup.execute(url, user, password, script);
        }
    }

    public static void executeScript(String url, String user, String password, String fileName, String options1, String options2) throws SQLException {
        Connection conn = null;
        Statement stat = null;
        try {
            Driver.load();
            conn = DriverManager.getConnection(url, user, password);
            stat = conn.createStatement();
            String sql = "SCRIPT " + options1 + " TO '" + fileName + "' " + options2;
            stat.execute(sql);
        }
        catch (Exception e) {
            try {
                throw Message.convert(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeSilently(stat);
                JdbcUtils.closeSilently(conn);
                throw throwable;
            }
        }
        JdbcUtils.closeSilently(stat);
        JdbcUtils.closeSilently(conn);
    }

    public static void execute(String url, String user, String password, String script) throws SQLException {
        Connection conn = null;
        Statement stat = null;
        FileWriter fileWriter = null;
        try {
            Driver.load();
            conn = DriverManager.getConnection(url, user, password);
            stat = conn.createStatement();
            fileWriter = new FileWriter(script);
            PrintWriter writer = new PrintWriter(new BufferedWriter(fileWriter));
            ResultSet rs = stat.executeQuery("SCRIPT");
            while (rs.next()) {
                String s = rs.getString(1);
                writer.println(s + ";");
            }
            writer.close();
        }
        catch (Exception e) {
            try {
                throw Message.convert(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeSilently(stat);
                JdbcUtils.closeSilently(conn);
                IOUtils.closeSilently(fileWriter);
                throw throwable;
            }
        }
        JdbcUtils.closeSilently(stat);
        JdbcUtils.closeSilently(conn);
        IOUtils.closeSilently(fileWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backupFiles(String zipFileName, String directory, String db) throws IOException, SQLException {
        File file = new File(zipFileName);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            ZipOutputStream zipOut = new ZipOutputStream(out);
            ArrayList list = FileLister.getDatabaseFiles(directory, db, true);
            for (int i = 0; i < list.size(); ++i) {
                String fileName = (String)list.get(i);
                ZipEntry entry = new ZipEntry(FileUtils.getFileName(fileName));
                zipOut.putNextEntry(entry);
                FileInputStream in = null;
                try {
                    in = new FileInputStream(fileName);
                    IOUtils.copyAndCloseInput(in, zipOut);
                }
                catch (Throwable throwable) {
                    IOUtils.closeSilently(in);
                    throw throwable;
                }
                IOUtils.closeSilently(in);
                zipOut.closeEntry();
            }
            zipOut.closeEntry();
            zipOut.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeSilently(out);
            throw throwable;
        }
        IOUtils.closeSilently(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreFiles(String zipFileName, String directory) throws IOException, SQLException {
        File file = new File(zipFileName);
        if (!file.exists()) {
            throw new IOException("File not found: " + zipFileName);
        }
        FileInputStream in = null;
        try {
            ZipEntry entry;
            in = new FileInputStream(file);
            ZipInputStream zipIn = new ZipInputStream(in);
            while ((entry = zipIn.getNextEntry()) != null) {
                String fileName = entry.getName();
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(new File(directory, fileName));
                    IOUtils.copy(zipIn, out);
                }
                catch (Throwable throwable) {
                    IOUtils.closeSilently(out);
                    throw throwable;
                }
                IOUtils.closeSilently(out);
                zipIn.closeEntry();
            }
            zipIn.closeEntry();
            zipIn.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeSilently(in);
            throw throwable;
        }
        IOUtils.closeSilently(in);
    }
}

