/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import java.util.HashMap;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.table.PlanItem;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;

public class Plan {
    private TableFilter[] filters;
    private HashMap planItems = new HashMap();
    private Expression[] allConditions;
    private TableFilter[] allFilters;

    public Plan(TableFilter[] filters, int count, Expression condition) {
        this.filters = new TableFilter[count];
        System.arraycopy(filters, 0, this.filters, 0, count);
        ObjectArray allCond = new ObjectArray();
        ObjectArray all = new ObjectArray();
        if (condition != null) {
            allCond.add(condition);
        }
        for (int i = 0; i < count; ++i) {
            TableFilter f = filters[i];
            do {
                all.add(f);
                if (f.getJoinCondition() == null) continue;
                allCond.add(f.getJoinCondition());
            } while ((f = f.getJoin()) != null);
        }
        this.allConditions = new Expression[allCond.size()];
        allCond.toArray(this.allConditions);
        this.allFilters = new TableFilter[all.size()];
        all.toArray(this.allFilters);
    }

    public PlanItem getItem(TableFilter filter) {
        return (PlanItem)this.planItems.get(filter);
    }

    public TableFilter[] getFilters() {
        return this.filters;
    }

    public void removeUnusableIndexConditions() {
        TableFilter f;
        int i;
        for (i = 0; i < this.allFilters.length; ++i) {
            f = this.allFilters[i];
            this.setEvaluatable(f, true);
            if (i < this.allFilters.length - 1) {
                f.optimizeFullCondition(false);
            }
            f.removeUnusableIndexConditions();
        }
        for (i = 0; i < this.allFilters.length; ++i) {
            f = this.allFilters[i];
            this.setEvaluatable(f, false);
        }
    }

    public double calculateCost(Session session) throws SQLException {
        int i;
        double cost = 1.0;
        boolean invalidPlan = false;
        for (i = 0; i < this.allFilters.length; ++i) {
            TableFilter tableFilter = this.allFilters[i];
            PlanItem item = tableFilter.getBestPlanItem(session);
            this.planItems.put(tableFilter, item);
            cost += cost * item.cost;
            this.setEvaluatable(tableFilter, true);
            Expression on = tableFilter.getJoinCondition();
            if (on == null || on.isEverything(3)) continue;
            invalidPlan = true;
            break;
        }
        if (invalidPlan) {
            cost = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < this.allFilters.length; ++i) {
            this.setEvaluatable(this.allFilters[i], false);
        }
        return cost;
    }

    private void setEvaluatable(TableFilter filter, boolean b) {
        for (int j = 0; j < this.allConditions.length; ++j) {
            this.allConditions[j].setEvaluatable(filter, b);
        }
    }
}

