/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.table.Table;
import org.h2.value.Value;

public class UndoLogRecord {
    public static final short INSERT = 0;
    public static final short DELETE = 1;
    private static final int IN_MEMORY = 0;
    private static final int STORED = 1;
    private static final int IN_MEMORY_READ_POS = 2;
    private Table table;
    private Row row;
    private short operation;
    private short state;
    private int filePos;

    public boolean isStored() {
        return this.state == 1;
    }

    public boolean canStore() {
        return this.table.getUniqueIndex() != null;
    }

    public UndoLogRecord(Table table, short op, Row row) {
        this.table = table;
        this.row = row;
        this.operation = op;
        this.state = 0;
    }

    public void undo(Session session) throws SQLException {
        switch (this.operation) {
            case 0: {
                if (this.state == 2) {
                    Index index = this.table.getUniqueIndex();
                    Cursor cursor = index.find(session, this.row, this.row);
                    cursor.next();
                    int pos = cursor.getPos();
                    this.row.setPos(pos);
                    this.state = 0;
                }
                if (session.getDatabase().getLockMode() == 0 && this.row.getDeleted()) {
                    return;
                }
                try {
                    this.table.removeRow(session, this.row);
                    break;
                }
                catch (SQLException e) {
                    if (session.getDatabase().getLockMode() == 0 && e.getErrorCode() == 90112) break;
                    throw e;
                }
            }
            case 1: {
                try {
                    this.row.setPos(0);
                    this.table.addRow(session, this.row);
                    break;
                }
                catch (SQLException e) {
                    if (session.getDatabase().getLockMode() == 0 && e.getErrorCode() == 23001) break;
                    throw e;
                }
            }
            default: {
                throw Message.getInternalError("op=" + this.operation);
            }
        }
    }

    public void save(DataPage buff, FileStore file) throws SQLException {
        buff.reset();
        buff.writeInt(0);
        buff.writeInt(this.operation);
        buff.writeInt(this.row.getColumnCount());
        for (int i = 0; i < this.row.getColumnCount(); ++i) {
            buff.writeValue(this.row.getValue(i));
        }
        buff.fillAligned();
        buff.setInt(0, buff.length() / 16);
        buff.updateChecksum();
        this.filePos = (int)(file.getFilePointer() / 16L);
        file.write(buff.getBytes(), 0, buff.length());
        this.row = null;
        this.state = 1;
    }

    public void seek(FileStore file) throws SQLException {
        file.seek(this.filePos * 16);
    }

    public void load(DataPage buff, FileStore file, Session session) throws SQLException {
        int min = 16;
        this.seek(file);
        buff.reset();
        file.readFully(buff.getBytes(), 0, min);
        int len = buff.readInt() * 16;
        buff.checkCapacity(len);
        if (len - min > 0) {
            file.readFully(buff.getBytes(), min, len - min);
        }
        buff.check(len);
        int op = buff.readInt();
        if (Constants.CHECK && this.operation != op) {
            throw Message.getInternalError("operation=" + this.operation + " op=" + op);
        }
        int columnCount = buff.readInt();
        Value[] values = new Value[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            values[i] = buff.readValue();
        }
        this.row = new Row(values);
        this.state = (short)2;
    }

    public Table getTable() {
        return this.table;
    }
}

