/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.util.FileUtils;
import org.h2.util.MemoryFile;

public class MemoryFileStore
extends FileStore {
    private MemoryFile memFile;

    public MemoryFileStore(DataHandler handler, String name, byte[] magic) throws SQLException {
        super(handler, magic);
        this.name = name;
        this.memFile = FileUtils.getMemoryFile(name);
        this.memFile.setMagic(magic);
    }

    public void close() {
    }

    public long getFilePointer() {
        return this.memFile.getFilePointer();
    }

    public long length() {
        return this.memFile.length();
    }

    public void readFully(byte[] b, int off, int len) throws SQLException {
        this.checkPowerOff();
        this.memFile.readFully(b, off, len);
    }

    public void seek(long pos) {
        this.memFile.seek(pos);
    }

    public void setLength(long newLength) throws SQLException {
        this.checkPowerOff();
        this.memFile.setLength(newLength);
    }

    public void write(byte[] b, int off, int len) throws SQLException {
        this.checkPowerOff();
        this.memFile.write(b, off, len);
    }
}

