/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.h2.bnf.Bnf;
import org.h2.bnf.Rule;
import org.h2.bnf.Sentence;
import org.h2.command.Parser;
import org.h2.message.Message;
import org.h2.server.web.DbContents;
import org.h2.server.web.DbSchema;
import org.h2.server.web.DbTableOrView;
import org.h2.util.StringUtils;

public class DbContextRule
implements Rule {
    DbContents contents;
    int type;
    static final int COLUMN = 0;
    static final int TABLE = 1;
    static final int TABLE_ALIAS = 2;
    public static final int NEW_TABLE_ALIAS = 3;
    public static final int COLUMN_ALIAS = 4;
    private static boolean SUGGEST_TABLE_ALIAS;

    DbContextRule(DbContents contents, int type) {
        this.contents = contents;
        this.type = type;
    }

    public String name() {
        return null;
    }

    public String random(Bnf config, int level) {
        return null;
    }

    public Rule last() {
        return this;
    }

    public void setLinks(HashMap ruleMap) {
    }

    public void addNextTokenList(String query, Sentence sentence) {
        switch (this.type) {
            case 1: {
                this.addTable(query, sentence);
                break;
            }
            case 3: {
                this.addNewTableAlias(query, sentence);
                break;
            }
            case 2: {
                this.addTableAlias(query, sentence);
                break;
            }
            case 0: 
            case 4: {
                this.addColumn(query, sentence);
            }
        }
    }

    private void addTableAlias(String query, Sentence sentence) {
        HashSet tables;
        String q = StringUtils.toUpperEnglish(query.trim());
        HashMap map = sentence.getAliases();
        HashSet<String> set = new HashSet<String>();
        if (map != null) {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String alias = (String)entry.getKey();
                DbTableOrView table = (DbTableOrView)entry.getValue();
                set.add(StringUtils.toUpperEnglish(table.name));
                if (q.length() != 0 && !alias.startsWith(q) || q.length() >= alias.length()) continue;
                sentence.add(alias + ".", alias.substring(q.length()) + ".", 0);
            }
        }
        if ((tables = sentence.getTables()) != null) {
            Iterator it = tables.iterator();
            while (it.hasNext()) {
                DbTableOrView table = (DbTableOrView)it.next();
                String tableName = StringUtils.toUpperEnglish(table.name);
                if (set.contains(tableName) || q.length() != 0 && !tableName.startsWith(q) || q.length() >= tableName.length()) continue;
                sentence.add(tableName + ".", tableName.substring(q.length()) + ".", 0);
            }
        }
    }

    private void addNewTableAlias(String query, Sentence sentence) {
        if (SUGGEST_TABLE_ALIAS) {
            String q;
            if (query.length() > 3) {
                return;
            }
            String lastTableName = StringUtils.toUpperEnglish(sentence.getLastTable().name);
            if (lastTableName == null) {
                return;
            }
            HashMap map = sentence.getAliases();
            String shortName = lastTableName.substring(0, 1);
            if (map != null && map.containsKey(shortName)) {
                int result = 0;
                int i = 1;
                while (true) {
                    if (!map.containsKey(shortName + i)) break;
                    ++i;
                }
                result = i;
                shortName = shortName + result;
            }
            if (((q = StringUtils.toUpperEnglish(query.trim())).length() == 0 || StringUtils.toUpperEnglish(shortName).startsWith(q)) && q.length() < shortName.length()) {
                sentence.add(shortName, shortName.substring(q.length()), 0);
            }
        }
    }

    private void addTable(String query, Sentence sentence) {
        DbSchema schema = this.contents.defaultSchema;
        String text = StringUtils.toUpperEnglish(sentence.text).trim();
        if (text.endsWith(".")) {
            for (int i = 0; i < this.contents.schemas.length; ++i) {
                if (!text.endsWith(StringUtils.toUpperEnglish(this.contents.schemas[i].name) + ".")) continue;
                schema = this.contents.schemas[i];
                break;
            }
        }
        String q = StringUtils.toUpperEnglish(query.trim());
        DbTableOrView[] tables = schema.tables;
        for (int i = 0; i < tables.length; ++i) {
            DbTableOrView table = tables[i];
            if (q.length() != 0 && !StringUtils.toUpperEnglish(table.name).startsWith(q) || q.length() >= table.quotedName.length()) continue;
            sentence.add(table.quotedName, table.quotedName.substring(q.length()), 0);
        }
    }

    private void addColumn(String query, Sentence sentence) {
        String tableName = query;
        String columnPattern = "";
        if (query.trim().length() == 0) {
            tableName = null;
            if (sentence.text.trim().endsWith(".")) {
                return;
            }
        } else {
            tableName = StringUtils.toUpperEnglish(query.trim());
            if (tableName.endsWith(".")) {
                tableName = tableName.substring(0, tableName.length() - 1);
            } else {
                columnPattern = StringUtils.toUpperEnglish(query.trim());
                tableName = null;
            }
        }
        HashSet set = null;
        HashMap aliases = sentence.getAliases();
        if (tableName == null && sentence.getTables() != null) {
            set = sentence.getTables();
        }
        DbTableOrView table = null;
        if (tableName != null && aliases != null && aliases.get(tableName) != null) {
            table = (DbTableOrView)aliases.get(tableName);
            tableName = StringUtils.toUpperEnglish(table.name);
        }
        if (tableName == null) {
            if (set == null && aliases == null) {
                return;
            }
            if (set != null && set.size() > 1 || aliases != null && aliases.size() > 1) {
                return;
            }
        }
        if (table == null) {
            DbTableOrView[] tables = this.contents.defaultSchema.tables;
            for (int i = 0; i < tables.length; ++i) {
                DbTableOrView tab = tables[i];
                String t = StringUtils.toUpperEnglish(tab.name);
                if (tableName != null && !tableName.equals(t) || set != null && !set.contains(tab)) continue;
                table = tab;
                break;
            }
        }
        if (table != null) {
            for (int j = 0; j < table.columns.length; ++j) {
                String columnName = table.columns[j].name;
                if (!StringUtils.toUpperEnglish(columnName).startsWith(columnPattern) || columnPattern.length() >= columnName.length()) continue;
                sentence.add(columnName, columnName.substring(columnPattern.length()), 0);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public String matchRemove(String query, Sentence sentence) {
        void var3_3;
        if (query.length() == 0) {
            return null;
        }
        switch (this.type) {
            case 1: {
                String s = this.matchTable(query, sentence);
                break;
            }
            case 3: {
                String s = this.matchTableAlias(query, sentence, true);
                break;
            }
            case 2: {
                String s = this.matchTableAlias(query, sentence, false);
                break;
            }
            case 4: {
                String s = this.matchColumnAlias(query, sentence, false);
                break;
            }
            case 0: {
                String s = this.matchColumn(query, sentence);
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.type);
            }
        }
        return var3_3;
    }

    public String matchTable(String query, Sentence sentence) {
        String up = StringUtils.toUpperEnglish(query);
        DbTableOrView[] tables = this.contents.defaultSchema.tables;
        String best = null;
        DbTableOrView bestTable = null;
        for (int i = 0; i < tables.length; ++i) {
            DbTableOrView table = tables[i];
            String tableName = StringUtils.toUpperEnglish(table.name);
            if (!up.startsWith(tableName) || best != null && tableName.length() <= best.length()) continue;
            best = tableName;
            bestTable = table;
        }
        if (best == null) {
            return null;
        }
        sentence.addTable(bestTable);
        query = query.substring(best.length());
        return query;
    }

    public String matchColumnAlias(String query, Sentence sentence, boolean add) {
        char ch;
        int i;
        String up = StringUtils.toUpperEnglish(query);
        if (query.indexOf(32) < 0) {
            return null;
        }
        for (i = 0; i < up.length() && ((ch = up.charAt(i)) == '_' || Character.isLetterOrDigit(ch)); ++i) {
        }
        if (i == 0) {
            return null;
        }
        String alias = up.substring(0, i);
        if (Parser.isKeyword(alias)) {
            return null;
        }
        return query.substring(alias.length());
    }

    public String matchTableAlias(String query, Sentence sentence, boolean add) {
        HashMap map;
        char ch;
        int i;
        String up = StringUtils.toUpperEnglish(query);
        if (query.indexOf(32) < 0) {
            return null;
        }
        for (i = 0; i < up.length() && ((ch = up.charAt(i)) == '_' || Character.isLetterOrDigit(ch)); ++i) {
        }
        if (i == 0) {
            return null;
        }
        String alias = up.substring(0, i);
        if (Parser.isKeyword(alias)) {
            return null;
        }
        if (add) {
            sentence.addAlias(alias, sentence.getLastTable());
        }
        if ((map = sentence.getAliases()) != null && map.containsKey(alias) || sentence.getLastTable() == null) {
            if (add && query.length() == alias.length()) {
                return query;
            }
            query = query.substring(alias.length());
            return query;
        }
        HashSet tables = sentence.getTables();
        if (tables != null) {
            String best = null;
            Iterator it = tables.iterator();
            while (it.hasNext()) {
                DbTableOrView table = (DbTableOrView)it.next();
                String tableName = StringUtils.toUpperEnglish(table.name);
                if (!alias.startsWith(tableName) || best != null && tableName.length() <= best.length()) continue;
                best = tableName;
            }
            if (best != null) {
                query = query.substring(best.length());
                return query;
            }
        }
        return null;
    }

    public String matchColumn(String query, Sentence sentence) {
        String up = StringUtils.toUpperEnglish(query);
        HashSet set = sentence.getTables();
        DbTableOrView[] tables = this.contents.defaultSchema.tables;
        String best = null;
        for (int i = 0; i < tables.length; ++i) {
            DbTableOrView table = tables[i];
            if (set != null && !set.contains(table)) continue;
            for (int j = 0; j < table.columns.length; ++j) {
                String name = StringUtils.toUpperEnglish(table.columns[j].name);
                if (!up.startsWith(name)) continue;
                String b = query.substring(name.length());
                if (best != null && b.length() >= best.length()) continue;
                best = b;
            }
        }
        return best;
    }
}

