/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.command.dml.Query;
import org.h2.command.dml.SelectUnion;
import org.h2.engine.Session;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.ViewCursor;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.TableView;
import org.h2.util.IntArray;
import org.h2.util.ObjectArray;
import org.h2.util.SmallLRUCache;
import org.h2.value.Value;

public class ViewIndex
extends Index {
    private String querySQL;
    private ObjectArray originalParameters;
    private Parameter[] params;
    private SmallLRUCache costCache = new SmallLRUCache(64);
    private Value[] lastParameters;
    private long lastEvaluated;
    private LocalResult lastResult;
    private boolean recursive;
    private int recurseLevel;
    private LocalResult recursiveResult;

    public ViewIndex(TableView view, String querySQL, ObjectArray originalParameters, boolean recursive) {
        super(view, 0, null, null, IndexType.createNonUnique(false));
        this.querySQL = querySQL;
        this.originalParameters = originalParameters;
        this.recursive = recursive;
        this.columns = new Column[0];
        this.params = new Parameter[0];
    }

    public String getPlanSQL() {
        return this.querySQL;
    }

    public void close(Session session) throws SQLException {
    }

    public void add(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void remove(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    private int getComparisonType(int mask) {
        if ((mask & 1) == 1) {
            return 0;
        }
        if ((mask & 6) == 6) {
            return 1;
        }
        if ((mask & 2) == 2) {
            return 1;
        }
        if ((mask & 4) == 4) {
            return 3;
        }
        throw Message.getInternalError("unsupported mask " + mask);
    }

    public double getCost(Session session, int[] masks) throws SQLException {
        long time;
        if (this.recursive) {
            return 10.0;
        }
        IntArray masksArray = new IntArray(masks == null ? new int[]{} : masks);
        CostElement cachedCost = (CostElement)this.costCache.get(masksArray);
        if (cachedCost != null && (time = System.currentTimeMillis()) < cachedCost.evaluatedAt + 10000L) {
            return cachedCost.cost;
        }
        Query query = (Query)session.prepare(this.querySQL, true);
        if (masks == null) {
            this.columns = new Column[0];
            this.params = new Parameter[0];
        } else {
            IntArray paramIndex = new IntArray();
            for (int i = 0; i < masks.length; ++i) {
                int mask = masks[i];
                if (mask == 0) continue;
                paramIndex.add(i);
            }
            int len = paramIndex.size();
            this.columns = new Column[len];
            this.params = new Parameter[len];
            for (int i = 0; i < len; ++i) {
                Parameter param;
                Column col;
                int idx = paramIndex.get(i);
                this.columns[i] = col = this.table.getColumn(idx);
                this.params[i] = param = new Parameter(0);
                int mask = masks[idx];
                int comparisonType = this.getComparisonType(mask);
                query.addGlobalCondition(param, idx, comparisonType);
            }
            if (this.recursive) {
                return 10.0;
            }
            String sql = query.getSQL();
            query = (Query)session.prepare(sql);
        }
        double cost = query.getCost();
        cachedCost = new CostElement();
        cachedCost.evaluatedAt = System.currentTimeMillis();
        cachedCost.cost = cost;
        this.costCache.put(masksArray, cachedCost);
        return cost;
    }

    public Cursor find(Session session, SearchRow first, SearchRow last) throws SQLException {
        Value v;
        int i;
        Query query = (Query)session.prepare(this.querySQL, true);
        if (this.recursive) {
            SelectUnion union = (SelectUnion)query;
            Query left = union.getLeftQuery();
            Query right = union.getRightQuery();
            if (this.recurseLevel == 0) {
                LocalResult result;
                LocalResult completeResult = result = left.query(0);
                this.recurseLevel = 1;
                result = left.query(0);
                block0: while (true) {
                    this.recursiveResult = result;
                    ++this.recurseLevel;
                    result = right.query(0);
                    if (result.getRowCount() == 0) break;
                    result = right.query(0);
                    while (true) {
                        if (!result.next()) continue block0;
                        completeResult.addRow(result.currentRow());
                    }
                    break;
                }
                completeResult.done();
                this.recurseLevel = 0;
                return new ViewCursor(this.table, completeResult);
            }
            return new ViewCursor(this.table, this.recursiveResult);
        }
        ObjectArray paramList = query.getParameters();
        for (i = 0; first != null && i < first.getColumnCount(); ++i) {
            v = first.getValue(i);
            if (v == null) continue;
            query.addGlobalCondition(ValueExpression.get(v), i, 1);
        }
        for (i = 0; last != null && i < last.getColumnCount(); ++i) {
            v = last.getValue(i);
            if (v == null) continue;
            query.addGlobalCondition(ValueExpression.get(v), i, 3);
        }
        for (i = 0; this.originalParameters != null && i < this.originalParameters.size(); ++i) {
            Parameter orig = (Parameter)this.originalParameters.get(i);
            Parameter param = (Parameter)paramList.get(i);
            Value value = orig.getValue(session);
            param.setValue(value);
        }
        boolean canReuse = first == null && last == null;
        long now = session.getDatabase().getModificationDataId();
        Value[] params = query.getParameterValues();
        if (session.getDatabase().getOptimizeReuseResults() && this.lastResult != null && canReuse && query.sameResultAsLast(session, params, this.lastParameters, this.lastEvaluated)) {
            this.lastResult = this.lastResult.createShallowCopy(session);
            if (this.lastResult != null) {
                this.lastResult.reset();
                return new ViewCursor(this.table, this.lastResult);
            }
        }
        query.setSession(session);
        LocalResult result = query.query(0);
        if (canReuse) {
            this.lastResult = result;
            this.lastParameters = params;
            this.lastEvaluated = now;
        }
        return new ViewCursor(this.table, result);
    }

    public int getCost(int[] masks) throws SQLException {
        if (masks != null) {
            throw Message.getUnsupportedException();
        }
        return Integer.MAX_VALUE;
    }

    public void remove(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean needRebuild() {
        return false;
    }

    public boolean canGetFirstOrLast(boolean first) {
        return false;
    }

    public Value findFirstOrLast(Session session, boolean first) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void setRecursive(boolean value) {
        this.recursive = value;
    }

    private static class CostElement {
        long evaluatedAt;
        double cost;

        private CostElement() {
        }
    }
}

