/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.command.dml.Optimizer;
import org.h2.command.dml.Query;
import org.h2.engine.Constants;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.expression.Wildcard;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;

public class Select
extends Query {
    private TableFilter topTableFilter;
    private ObjectArray filters = new ObjectArray();
    private ObjectArray topFilters = new ObjectArray();
    private ObjectArray expressions;
    private Expression having;
    private Expression condition;
    private int visibleColumnCount;
    private int distinctColumnCount;
    private ObjectArray orderList;
    private ObjectArray group;
    private int[] groupIndex;
    private boolean[] groupByExpression;
    private boolean distinct;
    private HashMap currentGroup;
    private int havingIndex;
    private boolean isGroupQuery;
    private boolean isForUpdate;
    private double cost;
    private boolean isQuickQuery;
    private boolean isPrepared;
    private boolean checkInit;
    private SortOrder sort;

    public Select(Session session) {
        super(session);
    }

    public void addTableFilter(TableFilter filter, boolean isTop) {
        this.filters.add(filter);
        if (isTop) {
            this.topFilters.add(filter);
        }
    }

    public ObjectArray getTopFilters() {
        return this.topFilters;
    }

    public void setExpressions(ObjectArray expressions) {
        this.expressions = expressions;
    }

    public void setGroupQuery() {
        this.isGroupQuery = true;
    }

    public void setGroupBy(ObjectArray group) {
        this.group = group;
    }

    public HashMap getCurrentGroup() {
        return this.currentGroup;
    }

    public void setOrder(ObjectArray order) {
        this.orderList = order;
    }

    public void addCondition(Expression cond) {
        this.condition = this.condition == null ? cond : new ConditionAndOr(0, cond, this.condition);
    }

    private void queryGroup(int columnCount, LocalResult result) throws SQLException {
        ValueHashMap groups = new ValueHashMap(this.session.getDatabase());
        int rowNumber = 0;
        this.setCurrentRowNumber(0);
        ValueArray defaultGroup = ValueArray.get(new Value[0]);
        while (this.topTableFilter.next()) {
            Expression expr;
            ValueArray key;
            this.checkCancelled();
            this.setCurrentRowNumber(rowNumber + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            ++rowNumber;
            if (this.groupIndex == null) {
                key = defaultGroup;
            } else {
                Value[] keyValues = new Value[this.groupIndex.length];
                for (int i = 0; i < this.groupIndex.length; ++i) {
                    int idx = this.groupIndex[i];
                    expr = (Expression)this.expressions.get(idx);
                    keyValues[i] = expr.getValue(this.session);
                }
                key = ValueArray.get(keyValues);
            }
            HashMap values = (HashMap)groups.get(key);
            if (values == null) {
                values = new HashMap();
                groups.put(key, values);
            }
            this.currentGroup = values;
            int len = columnCount;
            for (int i = 0; i < len; ++i) {
                if (this.groupByExpression != null && this.groupByExpression[i]) continue;
                expr = (Expression)this.expressions.get(i);
                expr.updateAggregate(this.session);
            }
            if (this.sampleSize <= 0 || rowNumber < this.sampleSize) continue;
            break;
        }
        if (this.groupIndex == null && groups.size() == 0) {
            groups.put(defaultGroup, new HashMap());
        }
        ObjectArray keys = groups.keys();
        for (int i = 0; i < keys.size(); ++i) {
            Value v;
            int j;
            ValueArray key = (ValueArray)keys.get(i);
            this.currentGroup = (HashMap)groups.get(key);
            Value[] keyValues = key.getList();
            Value[] row = new Value[columnCount];
            for (j = 0; this.groupIndex != null && j < this.groupIndex.length; ++j) {
                row[this.groupIndex[j]] = keyValues[j];
            }
            for (j = 0; j < columnCount; ++j) {
                if (this.groupByExpression != null && this.groupByExpression[j]) continue;
                Expression expr = (Expression)this.expressions.get(j);
                row[j] = expr.getValue(this.session);
            }
            if (this.havingIndex > 0 && ((v = row[this.havingIndex]) == ValueNull.INSTANCE || !Boolean.TRUE.equals(v.getBoolean()))) continue;
            if (columnCount != this.distinctColumnCount) {
                Value[] r2 = new Value[this.distinctColumnCount];
                System.arraycopy(row, 0, r2, 0, this.distinctColumnCount);
                row = r2;
            }
            result.addRow(row);
        }
    }

    private Index getSortIndex() throws SQLException {
        if (this.sort == null) {
            return null;
        }
        int[] sortTypes = this.sort.getSortTypes();
        for (int i = 0; i < sortTypes.length; ++i) {
            if ((sortTypes[i] & 5) == 0) continue;
            return null;
        }
        int[] indexes = this.sort.getIndexes();
        ObjectArray sortColumns = new ObjectArray();
        for (int i = 0; i < indexes.length; ++i) {
            int idx = indexes[i];
            if (idx < 0 || idx >= this.expressions.size()) {
                throw Message.getInvalidValueException("order by", "" + idx);
            }
            Expression expr = (Expression)this.expressions.get(idx);
            if ((expr = expr.getNonAliasExpression()).isConstant()) continue;
            if (!(expr instanceof ExpressionColumn)) {
                return null;
            }
            Column col = ((ExpressionColumn)expr).getColumn();
            if (col.getTable() != this.topTableFilter.getTable()) {
                return null;
            }
            sortColumns.add(col);
        }
        Object[] sortCols = new Column[sortColumns.size()];
        sortColumns.toArray(sortCols);
        if (sortCols.length == 0) {
            return this.topTableFilter.getTable().getScanIndex(this.session);
        }
        ObjectArray list = this.topTableFilter.getTable().getIndexes();
        for (int i = 0; list != null && i < list.size(); ++i) {
            Column[] indexCols;
            Index index = (Index)list.get(i);
            if (index.getCreateSQL() == null || index.indexType.isHash() || (indexCols = index.getColumns()).length < sortCols.length) continue;
            boolean ok = true;
            for (int j = 0; j < sortCols.length; ++j) {
                if (indexCols[j] == sortCols[j]) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return index;
        }
        return null;
    }

    private void queryFlat(int columnCount, LocalResult result) throws SQLException {
        int limitRows;
        if (this.limit == null) {
            limitRows = 0;
        } else {
            limitRows = this.limit.getValue(this.session).getInt();
            if (this.offset != null) {
                limitRows += this.offset.getValue(this.session).getInt();
            }
        }
        int rowNumber = 0;
        this.setCurrentRowNumber(0);
        while (this.topTableFilter.next()) {
            this.checkCancelled();
            this.setCurrentRowNumber(rowNumber + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            Value[] row = new Value[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                Expression expr = (Expression)this.expressions.get(i);
                row[i] = expr.getValue(this.session);
            }
            result.addRow(row);
            if ((this.sort != null || limitRows == 0 || result.getRowCount() < limitRows) && (this.sampleSize <= 0 || ++rowNumber < this.sampleSize)) continue;
            break;
        }
    }

    private void queryQuick(int columnCount, LocalResult result) throws SQLException {
        Value[] row = new Value[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            Expression expr = (Expression)this.expressions.get(i);
            row[i] = expr.getValue(this.session);
        }
        result.addRow(row);
    }

    public LocalResult queryWithoutCache(int maxrows) throws SQLException {
        if (maxrows != 0) {
            if (this.limit != null) {
                maxrows = Math.min(this.limit.getValue(this.session).getInt(), maxrows);
            }
            this.limit = ValueExpression.get(ValueInt.get(maxrows));
        }
        int columnCount = this.expressions.size();
        LocalResult result = new LocalResult(this.session, this.expressions, this.visibleColumnCount);
        result.setSortOrder(this.sort);
        if (this.distinct) {
            result.setDistinct();
        }
        this.topTableFilter.startQuery();
        this.topTableFilter.reset();
        this.topTableFilter.lock(this.session, this.isForUpdate);
        if (this.isQuickQuery) {
            this.queryQuick(columnCount, result);
        } else if (this.isGroupQuery) {
            this.queryGroup(columnCount, result);
        } else {
            this.queryFlat(columnCount, result);
        }
        if (this.offset != null) {
            result.setOffset(this.offset.getValue(this.session).getInt());
        }
        if (this.limit != null) {
            result.setLimit(this.limit.getValue(this.session).getInt());
        }
        result.done();
        return result;
    }

    private void expandColumnList() throws SQLException {
        for (int i = 0; i < this.expressions.size(); ++i) {
            int j;
            Expression expr = (Expression)this.expressions.get(i);
            if (!expr.isWildcard()) continue;
            String tableAlias = expr.getTableAlias();
            if (tableAlias == null) {
                int temp = i;
                this.expressions.remove(i);
                for (j = 0; j < this.filters.size(); ++j) {
                    TableFilter filter = (TableFilter)this.filters.get(j);
                    Wildcard c2 = new Wildcard(filter.getTable().getSchema().getName(), filter.getTableAlias());
                    this.expressions.add(i++, c2);
                }
                i = temp - 1;
                continue;
            }
            TableFilter filter = null;
            for (j = 0; j < this.filters.size(); ++j) {
                TableFilter f = (TableFilter)this.filters.get(j);
                if (!tableAlias.equals(f.getTableAlias())) continue;
                filter = f;
                break;
            }
            if (filter == null) {
                throw Message.getSQLException(42102, tableAlias);
            }
            Table t = filter.getTable();
            String alias = filter.getTableAlias();
            this.expressions.remove(i);
            Column[] columns = t.getColumns();
            for (int j2 = 0; j2 < columns.length; ++j2) {
                Column c = columns[j2];
                ExpressionColumn ec = new ExpressionColumn(this.session.getDatabase(), this, null, alias, c.getName());
                this.expressions.add(i++, ec);
            }
            --i;
        }
    }

    public void init() throws SQLException {
        if (Constants.CHECK && this.checkInit) {
            throw Message.getInternalError();
        }
        this.checkInit = true;
        this.expandColumnList();
        this.visibleColumnCount = this.expressions.size();
        if (this.orderList != null) {
            this.sort = this.initOrder(this.expressions, this.orderList, this.visibleColumnCount, this.distinct);
            this.orderList = null;
        }
        this.distinctColumnCount = this.expressions.size();
        if (this.having != null) {
            this.expressions.add(this.having);
            this.havingIndex = this.expressions.size() - 1;
            this.having = null;
        } else {
            this.havingIndex = -1;
        }
        if (this.group != null) {
            String sql;
            Expression expr;
            int i;
            this.groupIndex = new int[this.group.size()];
            ObjectArray expressionSQL = new ObjectArray();
            for (i = 0; i < this.expressions.size(); ++i) {
                expr = (Expression)this.expressions.get(i);
                expr = expr.getNonAliasExpression();
                sql = expr.getSQL();
                expressionSQL.add(sql);
            }
            for (i = 0; i < this.group.size(); ++i) {
                expr = (Expression)this.group.get(i);
                sql = expr.getSQL();
                int found = -1;
                for (int j = 0; j < expressionSQL.size(); ++j) {
                    String s2 = (String)expressionSQL.get(j);
                    if (!s2.equals(sql)) continue;
                    found = j;
                    break;
                }
                if (found < 0) {
                    int index;
                    this.groupIndex[i] = index = this.expressions.size();
                    this.expressions.add(expr);
                    continue;
                }
                this.groupIndex[i] = found;
            }
            this.groupByExpression = new boolean[this.expressions.size()];
            for (i = 0; i < this.groupIndex.length; ++i) {
                this.groupByExpression[this.groupIndex[i]] = true;
            }
            this.group = null;
        }
        for (int i = 0; i < this.filters.size(); ++i) {
            TableFilter f = (TableFilter)this.filters.get(i);
            for (int j = 0; j < this.expressions.size(); ++j) {
                Expression expr = (Expression)this.expressions.get(j);
                expr.mapColumns(f, 0);
            }
            if (this.condition == null) continue;
            this.condition.mapColumns(f, 0);
        }
    }

    public void prepare() throws SQLException {
        if (this.isPrepared) {
            return;
        }
        if (Constants.CHECK && !this.checkInit) {
            throw Message.getInternalError("already prepared");
        }
        this.isPrepared = true;
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression e = (Expression)this.expressions.get(i);
            this.expressions.set(i, e.optimize(this.session));
        }
        if (this.condition != null) {
            this.condition = this.condition.optimize(this.session);
            for (int j = 0; j < this.filters.size(); ++j) {
                TableFilter f = (TableFilter)this.filters.get(j);
                this.condition.createIndexConditions(f);
            }
        }
        if (this.condition == null && this.isGroupQuery && this.groupIndex == null && this.havingIndex < 0 && this.filters.size() == 1) {
            ExpressionVisitor optimizable = ExpressionVisitor.get(1);
            optimizable.table = ((TableFilter)this.filters.get(0)).getTable();
            this.isQuickQuery = this.isEverything(optimizable);
        }
        this.cost = this.preparePlan();
        if (!(this.sort == null || this.isQuickQuery || this.isGroupQuery || this.distinct)) {
            Index index = this.getSortIndex();
            Index current = this.topTableFilter.getIndex();
            if (index != null && (current.indexType.isScan() || current == index)) {
                this.topTableFilter.setIndex(index);
                this.sort = null;
            }
        }
    }

    public double getCost() {
        return this.cost;
    }

    public HashSet getTables() {
        HashSet<Table> set = new HashSet<Table>();
        for (int i = 0; i < this.filters.size(); ++i) {
            TableFilter filter = (TableFilter)this.filters.get(i);
            set.add(filter.getTable());
        }
        return set;
    }

    private double preparePlan() throws SQLException {
        Object[] topArray = new TableFilter[this.topFilters.size()];
        this.topFilters.toArray(topArray);
        for (int i = 0; i < topArray.length; ++i) {
            ((TableFilter)topArray[i]).setFullCondition(this.condition);
        }
        Optimizer optimizer = new Optimizer((TableFilter[])topArray, this.condition, this.session);
        optimizer.optimize();
        this.topTableFilter = optimizer.getTopFilter();
        double cost = optimizer.getCost();
        for (TableFilter f = this.topTableFilter; f != null; f = f.getJoin()) {
            Expression on;
            f.setEvaluatable(f, true);
            if (this.condition != null) {
                this.condition.setEvaluatable(f, true);
            }
            if ((on = f.getJoinCondition()) != null && !on.isEverything(3)) {
                f.removeJoinCondition();
                this.addCondition(on);
            }
            if ((on = f.getFilterCondition()) == null || on.isEverything(3)) continue;
            f.removeFilterCondition();
            this.addCondition(on);
        }
        this.topTableFilter.prepare();
        return cost;
    }

    public String getPlan() {
        if (this.topTableFilter == null) {
            return this.sql;
        }
        StringBuffer buff = new StringBuffer();
        Object[] exprList = new Expression[this.expressions.size()];
        this.expressions.toArray(exprList);
        buff.append("SELECT ");
        if (this.distinct) {
            buff.append("DISTINCT ");
        }
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            Object expr = exprList[i];
            buff.append(StringUtils.unEnclose(((Expression)expr).getSQL()));
        }
        buff.append("\nFROM ");
        TableFilter filter = this.topTableFilter;
        boolean join = false;
        int id = 0;
        do {
            if (id > 0) {
                buff.append("\n");
            }
            buff.append(filter.getPlanSQL(join));
            ++id;
            join = true;
        } while ((filter = filter.getJoin()) != null);
        if (this.condition != null) {
            buff.append("\nWHERE " + StringUtils.unEnclose(this.condition.getSQL()));
        }
        if (this.groupIndex != null) {
            buff.append("\nGROUP BY ");
            for (int i = 0; i < this.groupIndex.length; ++i) {
                Object g = exprList[this.groupIndex[i]];
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(StringUtils.unEnclose(((Expression)g).getSQL()));
            }
        }
        if (this.havingIndex >= 0) {
            Object h = exprList[this.havingIndex];
            buff.append("\nHAVING " + StringUtils.unEnclose(((Expression)h).getSQL()));
        }
        if (this.sort != null) {
            buff.append("\nORDER BY ");
            buff.append(this.sort.getSQL((Expression[])exprList, this.visibleColumnCount));
        }
        if (this.limit != null) {
            buff.append("\nLIMIT ");
            buff.append(StringUtils.unEnclose(this.limit.getSQL()));
            if (this.offset != null) {
                buff.append(" OFFSET ");
                buff.append(StringUtils.unEnclose(this.offset.getSQL()));
            }
        }
        if (this.isForUpdate) {
            buff.append("\nFOR UPDATE");
        }
        return buff.toString();
    }

    public void setDistinct(boolean b) {
        this.distinct = b;
    }

    public void setHaving(Expression having) {
        this.having = having;
    }

    public int getColumnCount() {
        return this.visibleColumnCount;
    }

    public TableFilter getTopTableFilter() {
        return this.topTableFilter;
    }

    public ObjectArray getExpressions() {
        return this.expressions;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public ObjectArray getGroupBy() {
        return this.group;
    }

    public void setForUpdate(boolean b) {
        this.isForUpdate = b;
    }

    public void mapColumns(ColumnResolver resolver, int level) throws SQLException {
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression e = (Expression)this.expressions.get(i);
            e.mapColumns(resolver, level);
        }
        if (this.condition != null) {
            this.condition.mapColumns(resolver, level);
        }
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression e = (Expression)this.expressions.get(i);
            e.setEvaluatable(tableFilter, b);
        }
        if (this.condition != null) {
            this.condition.setEvaluatable(tableFilter, b);
        }
    }

    public boolean isQuickQuery() {
        return this.isQuickQuery;
    }

    public void addGlobalCondition(Expression expr, int columnId, int comparisonType) throws SQLException {
        Expression col = (Expression)this.expressions.get(columnId);
        Expression comp = new Comparison(this.session, comparisonType, col, expr);
        comp = ((Expression)comp).optimize(this.session);
        if (this.isGroupQuery) {
            this.having = this.having == null ? comp : new ConditionAndOr(0, this.having, comp);
        } else {
            this.condition = this.condition == null ? comp : new ConditionAndOr(0, this.condition, comp);
        }
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        if (visitor.type == 4) {
            for (int i = 0; i < this.filters.size(); ++i) {
                TableFilter f = (TableFilter)this.filters.get(i);
                long m = f.getTable().getMaxDataModificationId();
                visitor.addDataModificationId(m);
            }
        }
        if (visitor.type == 3) {
            return false;
        }
        if (visitor.type != 3) {
            visitor.queryLevel(1);
        }
        boolean result = true;
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression e = (Expression)this.expressions.get(i);
            if (e.isEverything(visitor)) continue;
            result = false;
            break;
        }
        if (result && this.condition != null && !this.condition.isEverything(visitor)) {
            result = false;
        }
        if (result && this.having != null && !this.having.isEverything(visitor)) {
            result = false;
        }
        if (visitor.type != 3) {
            visitor.queryLevel(-1);
        }
        return result;
    }

    public boolean isReadOnly() {
        return this.isEverything(5);
    }
}

