/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.result.Row;
import org.h2.store.UndoLogRecord;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;

public class Delete
extends Prepared {
    private Expression condition;
    private TableFilter tableFilter;

    public Delete(Session session) {
        super(session);
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.tableFilter = tableFilter;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public int update() throws SQLException {
        int i;
        Row row;
        this.tableFilter.startQuery();
        this.tableFilter.reset();
        Table table = this.tableFilter.getTable();
        this.session.getUser().checkRight(table, 2);
        table.fireBefore(this.session);
        table.lock(this.session, true);
        ObjectArray rows = new ObjectArray();
        this.setCurrentRowNumber(0);
        while (this.tableFilter.next()) {
            this.checkCancelled();
            this.setCurrentRowNumber(rows.size() + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            Row row2 = this.tableFilter.get();
            rows.add(row2);
        }
        if (table.fireRow()) {
            for (int i2 = 0; i2 < rows.size(); ++i2) {
                this.checkCancelled();
                row = (Row)rows.get(i2);
                table.fireBeforeRow(this.session, row, null);
            }
        }
        for (i = 0; i < rows.size(); ++i) {
            this.checkCancelled();
            row = (Row)rows.get(i);
            table.removeRow(this.session, row);
            this.session.log(new UndoLogRecord(table, 1, row));
        }
        if (table.fireRow()) {
            for (i = 0; i < rows.size(); ++i) {
                this.checkCancelled();
                row = (Row)rows.get(i);
                table.fireAfterRow(this.session, row, null);
            }
        }
        table.fireAfter(this.session);
        return rows.size();
    }

    public String getPlan() {
        StringBuffer buff = new StringBuffer();
        buff.append("DELETE FROM ");
        buff.append(this.tableFilter.getPlanSQL(false));
        if (this.condition != null) {
            buff.append("\nWHERE " + StringUtils.unEnclose(this.condition.getSQL()));
        }
        return buff.toString();
    }

    public void prepare() throws SQLException {
        if (this.condition != null) {
            this.condition.mapColumns(this.tableFilter, 0);
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.tableFilter);
        }
        PlanItem item = this.tableFilter.getBestPlanItem(this.session);
        this.tableFilter.setPlanItem(item);
        this.tableFilter.prepare();
    }

    public boolean isTransactional() {
        return true;
    }
}

