/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.table.TableLink;

public class CreateLinkedTable
extends SchemaCommand {
    private String tableName;
    private String driver;
    private String url;
    private String user;
    private String password;
    private String originalTable;
    private boolean ifNotExists;
    private String comment;

    public CreateLinkedTable(Session session, Schema schema) {
        super(session, schema);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setOriginalTable(String originalTable) {
        this.originalTable = originalTable;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public int update() throws SQLException {
        this.session.commit();
        Database db = this.session.getDatabase();
        this.session.getUser().checkAdmin();
        if (this.getSchema().findTableOrView(this.session, this.tableName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(42101, this.tableName);
        }
        int id = this.getObjectId(false, true);
        TableLink table = new TableLink(this.getSchema(), id, this.tableName, this.driver, this.url, this.user, this.password, this.originalTable);
        table.setComment(this.comment);
        db.addSchemaObject(this.session, table);
        return 0;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

