/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.ftp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.h2.Driver;
import org.h2.server.Service;
import org.h2.server.ftp.FileObject;
import org.h2.server.ftp.FileObjectDatabase;
import org.h2.server.ftp.FileObjectNative;
import org.h2.server.ftp.FileSystemDatabase;
import org.h2.server.ftp.FtpControl;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;

public class FtpServer
implements Service {
    public static final String DEFAULT_ROOT = "ftp";
    public static final String DEFAULT_READ = "guest";
    public static final String DEFAULT_WRITE = "sa";
    public static final String DEFAULT_WRITE_PASSWORD = "sa";
    private ServerSocket serverSocket;
    private int port = 8021;
    private int openConnectionCount;
    private int maxConnectionCount = 100;
    private SimpleDateFormat dateFormatNew = new SimpleDateFormat("MMM dd HH:mm", Locale.ENGLISH);
    private SimpleDateFormat dateFormatOld = new SimpleDateFormat("MMM dd  yyyy", Locale.ENGLISH);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private String root = "ftp";
    private String writeUserName = "sa";
    private String writePassword = "sa";
    private String readUserName = "guest";
    private FileSystemDatabase db;
    private boolean log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen() {
        try {
            while (this.serverSocket != null) {
                boolean stop;
                Socket s = this.serverSocket.accept();
                FtpServer ftpServer = this;
                synchronized (ftpServer) {
                    ++this.openConnectionCount;
                    stop = this.openConnectionCount > this.maxConnectionCount;
                }
                FtpControl c = new FtpControl(s, this, stop);
                c.start();
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeConnection() {
        FtpServer ftpServer = this;
        synchronized (ftpServer) {
            --this.openConnectionCount;
        }
    }

    public ServerSocket createDataSocket() throws IOException {
        ServerSocket dataSocket = new ServerSocket(0);
        return dataSocket;
    }

    void appendFile(StringBuffer buff, FileObject f) {
        buff.append(f.isDirectory() ? (char)'d' : '-');
        buff.append(f.canRead() ? (char)'r' : '-');
        buff.append(f.canWrite() ? (char)'w' : '-');
        buff.append("------- 1 owner group ");
        String size = String.valueOf(f.length());
        for (int i = size.length(); i < 15; ++i) {
            buff.append(' ');
        }
        buff.append(size);
        buff.append(' ');
        Date now = new Date();
        Date mod = new Date(f.lastModified());
        if (mod.after(now) || Math.abs((now.getTime() - mod.getTime()) / 1000L / 60L / 60L / 24L) > 180L) {
            buff.append(this.dateFormatOld.format(mod));
        } else {
            buff.append(this.dateFormatNew.format(mod));
        }
        buff.append(' ');
        buff.append(f.getName());
        buff.append("\r\n");
    }

    String formatLastModified(FileObject file) {
        return this.dateFormat.format(new Date(file.lastModified()));
    }

    FileObject getFile(String path) {
        if (path.indexOf("..") > 0) {
            path = "/";
        }
        while (path.startsWith("/") && this.root.endsWith("/")) {
            path = path.substring(1);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this.log("file: " + this.root + path);
        if (this.db != null) {
            return FileObjectDatabase.get(this.db, this.root + path);
        }
        return FileObjectNative.get(this.root + path);
    }

    String getDirectoryListing(FileObject directory, boolean listDirectories) {
        FileObject[] list = directory.listFiles();
        StringBuffer buff = new StringBuffer();
        for (int i = 0; list != null && i < list.length; ++i) {
            FileObject f = list[i];
            if (!f.isFile() && (!f.isDirectory() || !listDirectories)) continue;
            this.appendFile(buff, f);
        }
        return buff.toString();
    }

    public boolean checkUserPassword(String userName, String param) {
        return userName.equals(this.writeUserName) && this.writePassword.equals(this.writePassword);
    }

    public boolean checkUserPasswordReadOnly(String userName, String param) {
        return userName.equals(this.readUserName);
    }

    public void init(String[] args) throws Exception {
        for (int i = 0; args != null && i < args.length; ++i) {
            if ("-ftpPort".equals(args[i])) {
                this.port = MathUtils.decodeInt(args[++i]);
                continue;
            }
            if ("-ftpDir".equals(args[i])) {
                this.root = args[++i];
                continue;
            }
            if ("-ftpRead".equals(args[i])) {
                this.readUserName = args[++i];
                continue;
            }
            if ("-ftpWrite".equals(args[i])) {
                this.writeUserName = args[++i];
                continue;
            }
            if ("-ftpWritePassword".equals(args[i])) {
                this.writePassword = args[++i];
                continue;
            }
            if (!"-log".equals(args[i])) continue;
            this.log = Boolean.valueOf(args[++i]);
        }
        if (this.root.startsWith("jdbc:")) {
            Driver.load();
            Connection conn = DriverManager.getConnection(this.root);
            this.db = new FileSystemDatabase(conn, this.log);
            this.root = "/";
        }
    }

    public String getURL() {
        return "ftp://localhost:" + this.port;
    }

    public void start() throws SQLException {
        this.getFile("").mkdirs();
        this.serverSocket = NetUtils.createServerSocket(this.port, false);
    }

    public void stop() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            this.logError(e);
        }
        this.serverSocket = null;
    }

    public boolean isRunning() {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket s = NetUtils.createLoopbackSocket(this.port, false);
            s.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean getAllowOthers() {
        return true;
    }

    public String getType() {
        return "FTP";
    }

    void log(String s) {
        if (this.log) {
            System.out.println(s);
        }
    }

    void logError(Throwable e) {
        if (this.log) {
            e.printStackTrace();
        }
    }
}

