/*
 * Decompiled with CFR 0.152.
 */
package org.h2.fulltext;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.h2.api.Trigger;
import org.h2.fulltext.FullTextSettings;
import org.h2.fulltext.IndexInfo;
import org.h2.tools.SimpleResultSet;
import org.h2.util.ByteUtils;
import org.h2.util.StringUtils;

public class FullText
implements Trigger {
    private static final String TRIGGER_PREFIX = "FT_";
    private static final String SCHEMA = "FT";
    private static final String FIELD_QUERY = "query";
    private IndexInfo index;
    private int[] dataTypes;
    private PreparedStatement prepInsertWord;
    private PreparedStatement prepInsertRow;
    private PreparedStatement prepInsertMap;
    private PreparedStatement prepDeleteRow;
    private PreparedStatement prepDeleteMap;
    private PreparedStatement prepSelectRow;

    public static void createIndex(Connection conn, String schema, String table, String columnList) throws SQLException {
        FullText.init(conn);
        PreparedStatement prep = conn.prepareStatement("INSERT INTO FT.INDEXES(SCHEMA, TABLE, COLUMNS) VALUES(?, ?, ?)");
        prep.setString(1, schema);
        prep.setString(2, table);
        prep.setString(3, columnList);
        prep.execute();
        FullText.createTrigger(conn, schema, table);
        FullText.indexExistingRows(conn, schema, table);
    }

    private static void createTrigger(Connection conn, String schema, String table) throws SQLException {
        Statement stat = conn.createStatement();
        String trigger = StringUtils.quoteIdentifier(schema) + "." + StringUtils.quoteIdentifier(TRIGGER_PREFIX + table);
        stat.execute("DROP TRIGGER IF EXISTS " + trigger);
        StringBuffer buff = new StringBuffer("CREATE TRIGGER IF NOT EXISTS ");
        buff.append(trigger);
        buff.append(" AFTER INSERT, UPDATE, DELETE ON ");
        buff.append(StringUtils.quoteIdentifier(schema) + "." + StringUtils.quoteIdentifier(table));
        buff.append(" FOR EACH ROW CALL \"");
        buff.append(FullText.class.getName());
        buff.append("\"");
        stat.execute(buff.toString());
    }

    private static void indexExistingRows(Connection conn, String schema, String table) throws SQLException {
        FullText existing = new FullText();
        existing.init(conn, schema, null, table);
        StringBuffer buff = new StringBuffer("SELECT * FROM ");
        buff.append(StringUtils.quoteIdentifier(schema) + "." + StringUtils.quoteIdentifier(table));
        ResultSet rs = conn.createStatement().executeQuery(buff.toString());
        int columnCount = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            Object[] row = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                row[i] = rs.getObject(i + 1);
            }
            existing.fire(conn, null, row);
        }
    }

    public static void reindex(Connection conn) throws SQLException {
        FullText.init(conn);
        FullText.removeAllTriggers(conn);
        FullTextSettings setting = FullTextSettings.getInstance(conn);
        setting.getWordList().clear();
        Statement stat = conn.createStatement();
        stat.execute("TRUNCATE TABLE FT.WORDS");
        stat.execute("TRUNCATE TABLE FT.ROWS");
        stat.execute("TRUNCATE TABLE FT.MAP");
        ResultSet rs = stat.executeQuery("SELECT * FROM FT.INDEXES");
        while (rs.next()) {
            String schema = rs.getString("SCHEMA");
            String table = rs.getString("TABLE");
            FullText.createTrigger(conn, schema, table);
            FullText.indexExistingRows(conn, schema, table);
        }
    }

    public static void setIgnoreList(Connection conn, String commaSeparatedList) throws SQLException {
        FullText.init(conn);
        FullTextSettings setting = FullTextSettings.getInstance(conn);
        FullText.setIgnoreList(setting, commaSeparatedList);
        Statement stat = conn.createStatement();
        stat.execute("TRUNCATE TABLE FT.IGNORELIST");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO FT.IGNORELIST VALUES(?)");
        prep.setString(1, commaSeparatedList);
        prep.execute();
    }

    private static void setIgnoreList(FullTextSettings setting, String commaSeparatedList) {
        String[] list = StringUtils.arraySplit(commaSeparatedList, ',', true);
        HashSet set = setting.getIgnoreList();
        for (int i = 0; i < list.length; ++i) {
            String word = list[i];
            if ((word = setting.convertWord(word)) == null) continue;
            set.add(list[i]);
        }
    }

    private static void removeAllTriggers(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.TRIGGERS");
        Statement stat2 = conn.createStatement();
        while (rs.next()) {
            String schema = rs.getString("TRIGGER_SCHEMA");
            String name = rs.getString("TRIGGER_NAME");
            if (!name.startsWith(TRIGGER_PREFIX)) continue;
            name = StringUtils.quoteIdentifier(schema) + "." + StringUtils.quoteIdentifier(name);
            stat2.execute("DROP TRIGGER " + name);
        }
    }

    public static void dropAll(Connection conn) throws SQLException {
        FullText.init(conn);
        Statement stat = conn.createStatement();
        stat.execute("DROP SCHEMA IF EXISTS FT");
        FullText.removeAllTriggers(conn);
        FullTextSettings setting = FullTextSettings.getInstance(conn);
        setting.getIgnoreList().clear();
        setting.getWordList().clear();
    }

    public static void init(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("CREATE SCHEMA IF NOT EXISTS FT");
        stat.execute("CREATE TABLE IF NOT EXISTS FT.INDEXES(ID INT AUTO_INCREMENT PRIMARY KEY, SCHEMA VARCHAR, TABLE VARCHAR, COLUMNS VARCHAR, UNIQUE(SCHEMA, TABLE))");
        stat.execute("CREATE MEMORY TABLE IF NOT EXISTS FT.WORDS(ID INT AUTO_INCREMENT PRIMARY KEY, NAME VARCHAR, UNIQUE(NAME))");
        stat.execute("CREATE TABLE IF NOT EXISTS FT.ROWS(ID IDENTITY, HASH INT, INDEXID INT, KEY VARCHAR, UNIQUE(HASH, INDEXID, KEY))");
        stat.execute("CREATE TABLE IF NOT EXISTS FT.MAP(ROWID INT, WORDID INT, PRIMARY KEY(WORDID, ROWID))");
        stat.execute("CREATE TABLE IF NOT EXISTS FT.IGNORELIST(LIST VARCHAR)");
        stat.execute("CREATE ALIAS IF NOT EXISTS FT_CREATE_INDEX FOR \"" + FullText.class.getName() + ".createIndex\"");
        stat.execute("CREATE ALIAS IF NOT EXISTS FT_SEARCH FOR \"" + FullText.class.getName() + ".search\"");
        stat.execute("CREATE ALIAS IF NOT EXISTS FT_REINDEX FOR \"" + FullText.class.getName() + ".reindex\"");
        stat.execute("CREATE ALIAS IF NOT EXISTS FT_DROP_ALL FOR \"" + FullText.class.getName() + ".dropAll\"");
        FullTextSettings setting = FullTextSettings.getInstance(conn);
        ResultSet rs = stat.executeQuery("SELECT * FROM FT.IGNORELIST");
        while (rs.next()) {
            String commaSeparatedList = rs.getString(1);
            FullText.setIgnoreList(setting, commaSeparatedList);
        }
        rs = stat.executeQuery("SELECT * FROM FT.WORDS");
        HashMap map = setting.getWordList();
        while (rs.next()) {
            String word = rs.getString("NAME");
            long id = rs.getLong("ID");
            if ((word = setting.convertWord(word)) == null) continue;
            map.put(word, new Long(id));
        }
    }

    public void init(Connection conn, String schemaName, String triggerName, String tableName) throws SQLException {
        FullText.init(conn);
        FullTextSettings setting = FullTextSettings.getInstance(conn);
        ArrayList<String> keyList = new ArrayList<String>();
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getColumns(null, schemaName, tableName, null);
        ArrayList<String> columnList = new ArrayList<String>();
        while (rs.next()) {
            columnList.add(rs.getString("COLUMN_NAME"));
        }
        this.dataTypes = new int[columnList.size()];
        this.index = new IndexInfo();
        this.index.schemaName = schemaName;
        this.index.tableName = tableName;
        this.index.columnNames = new String[columnList.size()];
        columnList.toArray(this.index.columnNames);
        rs = meta.getColumns(null, schemaName, tableName, null);
        int i = 0;
        while (rs.next()) {
            this.dataTypes[i] = rs.getInt("DATA_TYPE");
            ++i;
        }
        if (keyList.size() == 0) {
            rs = meta.getPrimaryKeys(null, schemaName, tableName);
            while (rs.next()) {
                keyList.add(rs.getString("COLUMN_NAME"));
            }
        }
        if (keyList.size() == 0) {
            throw new SQLException("No primary key for table " + tableName);
        }
        ArrayList<String> indexList = new ArrayList<String>();
        PreparedStatement prep = conn.prepareStatement("SELECT ID, COLUMNS FROM FT.INDEXES WHERE SCHEMA=? AND TABLE=?");
        prep.setString(1, schemaName);
        prep.setString(2, tableName);
        rs = prep.executeQuery();
        if (rs.next()) {
            this.index.id = rs.getInt(1);
            String columns = rs.getString(2);
            if (columns != null) {
                String[] list = StringUtils.arraySplit(columns, ',', true);
                for (int i2 = 0; i2 < list.length; ++i2) {
                    indexList.add(list[i2]);
                }
            }
        }
        if (indexList.size() == 0) {
            indexList.addAll(columnList);
        }
        this.index.keys = new int[keyList.size()];
        this.setColumns(this.index.keys, keyList, columnList);
        this.index.indexColumns = new int[indexList.size()];
        this.setColumns(this.index.indexColumns, indexList, columnList);
        setting.addIndexInfo(this.index);
        this.prepInsertWord = conn.prepareStatement("INSERT INTO FT.WORDS(NAME) VALUES(?)");
        this.prepInsertRow = conn.prepareStatement("INSERT INTO FT.ROWS(HASH, INDEXID, KEY) VALUES(?, ?, ?)");
        this.prepInsertMap = conn.prepareStatement("INSERT INTO FT.MAP(ROWID, WORDID) VALUES(?, ?)");
        this.prepDeleteRow = conn.prepareStatement("DELETE FROM FT.ROWS WHERE HASH=? AND INDEXID=? AND KEY=?");
        this.prepDeleteMap = conn.prepareStatement("DELETE FROM FT.MAP WHERE ROWID=? AND WORDID=?");
        this.prepSelectRow = conn.prepareStatement("SELECT ID FROM FT.ROWS WHERE HASH=? AND INDEXID=? AND KEY=?");
        PreparedStatement prepSelectMapByWordId = conn.prepareStatement("SELECT ROWID FROM FT.MAP WHERE WORDID=?");
        PreparedStatement prepSelectRowById = conn.prepareStatement("SELECT KEY, INDEXID FROM FT.ROWS WHERE ID=?");
        setting.setPrepSelectMapByWordId(prepSelectMapByWordId);
        setting.setPrepSelectRowById(prepSelectRowById);
    }

    private void setColumns(int[] index, ArrayList keys, ArrayList columns) throws SQLException {
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            int found = -1;
            for (int j = 0; found == -1 && j < columns.size(); ++j) {
                String column = (String)columns.get(j);
                if (!column.equals(key)) continue;
                found = j;
            }
            if (found < 0) {
                throw new SQLException("FULLTEXT", "Column not found: " + key);
            }
            index[i] = found;
        }
    }

    public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
        FullTextSettings setting = FullTextSettings.getInstance(conn);
        if (oldRow != null) {
            this.delete(setting, oldRow);
        }
        if (newRow != null) {
            this.insert(setting, newRow);
        }
    }

    private String getKey(Object[] row) throws SQLException {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.index.keys.length; ++i) {
            if (i > 0) {
                buff.append(" AND ");
            }
            int columnIndex = this.index.keys[i];
            buff.append(StringUtils.quoteIdentifier(this.index.columnNames[columnIndex]));
            Object o = row[columnIndex];
            if (o == null) {
                buff.append(" IS NULL");
                continue;
            }
            buff.append("=");
            buff.append(this.quoteSQL(o, this.dataTypes[columnIndex]));
        }
        String key = buff.toString();
        return key;
    }

    private String quoteString(String data) {
        if (data.indexOf(39) < 0) {
            return "'" + data + "'";
        }
        StringBuffer buff = new StringBuffer(data.length() + 2);
        buff.append('\'');
        for (int i = 0; i < data.length(); ++i) {
            char ch = data.charAt(i);
            if (ch == '\'') {
                buff.append(ch);
            }
            buff.append(ch);
        }
        buff.append('\'');
        return buff.toString();
    }

    private String quoteBinary(byte[] data) {
        return "'" + ByteUtils.convertBytesToString(data) + "'";
    }

    private String asString(Object data, int type) throws SQLException {
        if (data == null) {
            return "NULL";
        }
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                return data.toString();
            }
            case -4: 
            case -3: 
            case -2: 
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                throw new SQLException("FULLTEXT", "Unsupported column data type: " + type);
            }
        }
        return "";
    }

    private String quoteSQL(Object data, int type) throws SQLException {
        if (data == null) {
            return "NULL";
        }
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                return data.toString();
            }
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return this.quoteString(data.toString());
            }
            case -4: 
            case -3: 
            case -2: {
                return this.quoteBinary((byte[])data);
            }
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                throw new SQLException("FULLTEXT", "Unsupported key data type: " + type);
            }
        }
        return "";
    }

    private static void addWords(FullTextSettings setting, HashSet set, String text) {
        StringTokenizer tokenizer = new StringTokenizer(text, " \t\n\r\f+\"*%&/()=?'!,.;:-_#@|^~`{}[]");
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if ((word = setting.convertWord(word)) == null) continue;
            set.add(word);
        }
    }

    private int[] getWordIds(FullTextSettings setting, Object[] row) throws SQLException {
        HashSet words = new HashSet();
        for (int i = 0; i < this.index.indexColumns.length; ++i) {
            int idx = this.index.indexColumns[i];
            String data = this.asString(row[idx], this.dataTypes[idx]);
            FullText.addWords(setting, words, data);
        }
        HashMap allWords = setting.getWordList();
        int[] wordIds = new int[words.size()];
        Iterator it = words.iterator();
        int i = 0;
        while (it.hasNext()) {
            int wordId;
            String word = (String)it.next();
            Integer wId = (Integer)allWords.get(word);
            if (wId == null) {
                this.prepInsertWord.setString(1, word);
                this.prepInsertWord.execute();
                ResultSet rs = this.prepInsertWord.getGeneratedKeys();
                rs.next();
                wordId = rs.getInt(1);
                allWords.put(word, new Integer(wordId));
            } else {
                wordId = wId;
            }
            wordIds[i] = wordId;
            ++i;
        }
        Arrays.sort(wordIds);
        return wordIds;
    }

    private void insert(FullTextSettings setting, Object[] row) throws SQLException {
        String key = this.getKey(row);
        int hash = key.hashCode();
        this.prepInsertRow.setInt(1, hash);
        this.prepInsertRow.setLong(2, this.index.id);
        this.prepInsertRow.setString(3, key);
        this.prepInsertRow.execute();
        ResultSet rs = this.prepInsertRow.getGeneratedKeys();
        rs.next();
        long rowId = rs.getLong(1);
        this.prepInsertMap.setLong(1, rowId);
        int[] wordIds = this.getWordIds(setting, row);
        for (int i = 0; i < wordIds.length; ++i) {
            this.prepInsertMap.setInt(2, wordIds[i]);
            this.prepInsertMap.execute();
        }
    }

    private void delete(FullTextSettings setting, Object[] row) throws SQLException {
        String key = this.getKey(row);
        int hash = key.hashCode();
        this.prepSelectRow.setInt(1, hash);
        this.prepSelectRow.setLong(2, this.index.id);
        this.prepSelectRow.setString(3, key);
        ResultSet rs = this.prepSelectRow.executeQuery();
        if (rs.next()) {
            long rowId = rs.getLong(1);
            this.prepDeleteMap.setLong(1, rowId);
            int[] wordIds = this.getWordIds(setting, row);
            for (int i = 0; i < wordIds.length; ++i) {
                this.prepDeleteMap.setInt(2, wordIds[i]);
                this.prepDeleteMap.executeUpdate();
            }
            this.prepDeleteRow.setInt(1, hash);
            this.prepDeleteRow.setLong(2, this.index.id);
            this.prepDeleteRow.setString(3, key);
            this.prepDeleteRow.executeUpdate();
        }
    }

    public static ResultSet search(Connection conn, String text, int limit, int offset) throws SQLException {
        SimpleResultSet result = new SimpleResultSet();
        result.addColumn(FIELD_QUERY, 12, 0, 0);
        if (text == null) {
            return result;
        }
        FullTextSettings setting = FullTextSettings.getInstance(conn);
        HashSet words = new HashSet();
        FullText.addWords(setting, words, text);
        HashSet<Long> rIds = null;
        HashSet<Long> lastRowIds = null;
        HashMap allWords = setting.getWordList();
        PreparedStatement prepSelectMapByWordId = setting.getPrepSelectMapByWordId();
        Iterator it = words.iterator();
        while (it.hasNext()) {
            lastRowIds = rIds;
            rIds = new HashSet<Long>();
            String word = (String)it.next();
            Integer wId = (Integer)allWords.get(word);
            if (wId == null) continue;
            prepSelectMapByWordId.setInt(1, wId);
            ResultSet rs = prepSelectMapByWordId.executeQuery();
            while (rs.next()) {
                Long rId = new Long(rs.getLong(1));
                if (lastRowIds != null && !lastRowIds.contains(rId)) continue;
                rIds.add(rId);
            }
        }
        if (rIds == null || rIds.size() == 0) {
            return result;
        }
        PreparedStatement prepSelectRowById = setting.getPrepSelectRowById();
        int rowCount = 0;
        Iterator it2 = rIds.iterator();
        while (it2.hasNext()) {
            long rowId = (Long)it2.next();
            prepSelectRowById.setLong(1, rowId);
            ResultSet rs = prepSelectRowById.executeQuery();
            if (!rs.next()) continue;
            if (offset > 0) {
                --offset;
                continue;
            }
            String key = rs.getString(1);
            long indexId = rs.getLong(2);
            IndexInfo index = setting.getIndexInfo(indexId);
            String query = StringUtils.quoteIdentifier(index.schemaName) + "." + StringUtils.quoteIdentifier(index.tableName);
            query = query + " WHERE " + key;
            result.addRow(new String[]{query});
            if (limit <= 0 || ++rowCount < limit) continue;
            break;
        }
        return result;
    }
}

