/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget.controller;

import android.annotation.TargetApi;
import android.graphics.PointF;
import android.view.MotionEvent;
import android.view.View;

public class TouchController {
    private PointF rotatePoint(PointF A, PointF B, float degree) {
        float radian = (float)Math.toRadians(degree);
        float cos = (float)Math.cos(radian);
        float sin = (float)Math.sin(radian);
        float x = (A.x - B.x) * cos + (A.y - B.y) * sin + B.x;
        float y = -(A.x - B.x) * sin + (A.y - B.y) * cos + B.y;
        return new PointF(x, y);
    }

    @TargetApi(value=14)
    public MotionEvent obtainTouchEvent(MotionEvent ev, int view_w, int view_h, int cur_degree) {
        MotionEvent.PointerProperties[] preo = new MotionEvent.PointerProperties[ev.getPointerCount()];
        MotionEvent.PointerCoords[] coor = new MotionEvent.PointerCoords[ev.getPointerCount()];
        for (int i = 0; i < ev.getPointerCount(); ++i) {
            preo[i] = new MotionEvent.PointerProperties();
            coor[i] = new MotionEvent.PointerCoords();
            ev.getPointerProperties(i, preo[i]);
            ev.getPointerCoords(i, coor[i]);
            PointF newPoint = this.rotatePoint(new PointF(coor[i].x, coor[i].y), new PointF((float)view_w / 2.0f, (float)view_h / 2.0f), -cur_degree);
            coor[i].x = newPoint.x;
            coor[i].y = newPoint.y;
        }
        MotionEvent newEvent = MotionEvent.obtain((long)ev.getDownTime(), (long)ev.getEventTime(), (int)ev.getAction(), (int)ev.getPointerCount(), (MotionEvent.PointerProperties[])preo, (MotionEvent.PointerCoords[])coor, (int)ev.getMetaState(), (int)ev.getButtonState(), (float)ev.getXPrecision(), (float)ev.getYPrecision(), (int)ev.getDeviceId(), (int)ev.getEdgeFlags(), (int)ev.getSource(), (int)ev.getFlags());
        return newEvent;
    }

    public static interface OnDispatchTouchEventListener {
        public void onDispatchTouchEvent(View var1, MotionEvent var2);
    }
}

