/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget.controller;

import android.graphics.Canvas;
import android.graphics.PointF;
import android.view.MotionEvent;
import android.view.View;

public abstract class AbstractController
implements View.OnTouchListener {
    protected ControllerListener mListener;
    protected PointF mCurPointDown;
    protected PointF mCurPointMidd;
    protected float mPreDistance;
    protected float mPreDegree;
    protected final float PRECISION = 0.001f;

    public AbstractController(ControllerListener mListener) {
        this.mListener = mListener;
        this.mCurPointDown = new PointF();
        this.mCurPointMidd = new PointF();
        this.mPreDistance = 0.0f;
        this.mPreDegree = 0.0f;
    }

    public abstract void initialize(float var1, float var2, float var3, float var4);

    public abstract void beforeDraw(Canvas var1);

    public abstract void afterDraw(Canvas var1);

    protected float getDistance(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    protected float getRotation(MotionEvent event) {
        double radians = Math.atan2(event.getY(0) - event.getY(1), event.getX(0) - event.getX(1));
        return (float)Math.toDegrees(radians);
    }

    protected float getRotation(PointF A, PointF B) {
        double radians = Math.atan2(A.y - B.y, A.x - B.x);
        return (float)Math.toDegrees(radians);
    }

    protected float getRotation(PointF A, PointF B, PointF Center) {
        PointF VCA = new PointF(A.x - Center.x, A.y - Center.y);
        PointF VCB = new PointF(B.x - Center.x, B.y - Center.y);
        float AXB = VCA.x * VCB.y - VCA.y * VCB.x;
        double ABS_VA = Math.hypot(VCA.x, VCA.y);
        double ABS_VB = Math.hypot(VCB.x, VCB.y);
        double radians = Math.asin((double)AXB / (ABS_VA * ABS_VB));
        return (float)Math.toDegrees(radians);
    }

    public static interface ControllerListener {
        public void invalidate();

        public PointF getCenterPoint();
    }
}

