/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget;

import android.content.Context;
import android.graphics.ImageFormat;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.guo.android_extend.tools.FrameHelper;
import com.guo.android_extend.widget.CameraFrameData;
import com.guo.android_extend.widget.CameraGLSurfaceView;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class CameraSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback,
Camera.PreviewCallback,
CameraGLSurfaceView.OnRenderListener {
    private final String TAG = this.getClass().getSimpleName();
    private Camera mCamera;
    private int mWidth;
    private int mHeight;
    private int mFormat;
    private OnCameraListener mOnCameraListener;
    private FrameHelper mFrameHelper;
    private CameraGLSurfaceView mGLSurfaceView;
    private BlockingQueue<CameraFrameData> mImageDataBuffers;

    public CameraSurfaceView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.onCreate();
    }

    public CameraSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.onCreate();
    }

    public CameraSurfaceView(Context context) {
        super(context);
        this.onCreate();
    }

    private void onCreate() {
        SurfaceHolder arg0 = this.getHolder();
        arg0.setType(3);
        arg0.addCallback((SurfaceHolder.Callback)this);
        this.mFrameHelper = new FrameHelper();
        this.mImageDataBuffers = new LinkedBlockingQueue<CameraFrameData>();
        this.mGLSurfaceView = null;
    }

    public boolean startPreview() {
        Camera.Size imageSize = this.mCamera.getParameters().getPreviewSize();
        int lineBytes = imageSize.width * ImageFormat.getBitsPerPixel((int)this.mCamera.getParameters().getPreviewFormat()) / 8;
        this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        this.mCamera.addCallbackBuffer(new byte[lineBytes * imageSize.height]);
        this.mCamera.addCallbackBuffer(new byte[lineBytes * imageSize.height]);
        this.mCamera.addCallbackBuffer(new byte[lineBytes * imageSize.height]);
        this.mCamera.startPreview();
        return true;
    }

    public boolean stopPreview() {
        this.mCamera.setPreviewCallbackWithBuffer(null);
        this.mCamera.stopPreview();
        return true;
    }

    public boolean resetCamera() {
        if (this.closeCamera() && this.openCamera()) {
            return true;
        }
        Log.e((String)this.TAG, (String)"resetCamera fail!");
        return false;
    }

    private boolean openCamera() {
        try {
            if (this.mCamera != null) {
                this.mCamera.reconnect();
            } else if (this.mOnCameraListener != null) {
                this.mCamera = this.mOnCameraListener.setupCamera();
            }
            if (this.mCamera != null) {
                this.mCamera.setPreviewDisplay(this.getHolder());
                Camera.Size imageSize = this.mCamera.getParameters().getPreviewSize();
                this.mWidth = imageSize.width;
                this.mHeight = imageSize.height;
                this.mFormat = this.mCamera.getParameters().getPreviewFormat();
                if (this.mGLSurfaceView != null) {
                    this.mGLSurfaceView.setImageConfig(this.mWidth, this.mHeight, this.mFormat);
                    this.mGLSurfaceView.setAspectRatio(this.mWidth, this.mHeight);
                    int lineBytes = imageSize.width * ImageFormat.getBitsPerPixel((int)this.mFormat) / 8;
                    this.mImageDataBuffers.offer(new CameraFrameData(this.mWidth, this.mHeight, this.mFormat, lineBytes * this.mHeight));
                    this.mImageDataBuffers.offer(new CameraFrameData(this.mWidth, this.mHeight, this.mFormat, lineBytes * this.mHeight));
                    this.mImageDataBuffers.offer(new CameraFrameData(this.mWidth, this.mHeight, this.mFormat, lineBytes * this.mHeight));
                }
                if (this.mOnCameraListener != null) {
                    if (this.mOnCameraListener.startPreviewImmediately()) {
                        this.startPreview();
                    } else {
                        Log.w((String)this.TAG, (String)"Camera not start preview!");
                    }
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean closeCamera() {
        try {
            if (this.mCamera != null) {
                this.mCamera.setPreviewCallbackWithBuffer(null);
                this.mCamera.stopPreview();
                this.mCamera.release();
                this.mCamera = null;
            }
            this.mImageDataBuffers.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        if (this.mOnCameraListener != null) {
            this.mOnCameraListener.setupChanged(format, width, height);
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.openCamera()) {
            Log.e((String)this.TAG, (String)"camera start fail!");
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        if (!this.closeCamera()) {
            Log.e((String)this.TAG, (String)"camera close fail!");
        }
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        long timestamp = System.nanoTime();
        this.mFrameHelper.printFPS();
        if (this.mGLSurfaceView != null) {
            CameraFrameData imageData = (CameraFrameData)this.mImageDataBuffers.poll();
            if (imageData != null) {
                byte[] buffer = imageData.mData;
                System.arraycopy(data, 0, buffer, 0, buffer.length);
                if (this.mOnCameraListener != null) {
                    imageData.mParams = this.mOnCameraListener.onPreview(buffer, this.mWidth, this.mHeight, this.mFormat, timestamp);
                }
                this.mGLSurfaceView.requestRender(imageData);
            }
        } else if (this.mOnCameraListener != null) {
            this.mOnCameraListener.onPreview((byte[])data.clone(), this.mWidth, this.mHeight, this.mFormat, timestamp);
        }
        if (this.mCamera != null) {
            this.mCamera.addCallbackBuffer(data);
        }
    }

    @Override
    public void onBeforeRender(CameraFrameData data) {
        if (this.mOnCameraListener != null) {
            data.mTimeStamp = System.nanoTime();
            this.mOnCameraListener.onBeforeRender(data);
        }
    }

    @Override
    public void onAfterRender(CameraFrameData data) {
        if (this.mOnCameraListener != null) {
            data.mTimeStamp = System.nanoTime();
            this.mOnCameraListener.onAfterRender(data);
        }
        if (!this.mImageDataBuffers.offer(data)) {
            Log.e((String)this.TAG, (String)"PREVIEW QUEUE FULL!");
        }
    }

    public void setOnCameraListener(OnCameraListener l) {
        this.mOnCameraListener = l;
    }

    public void setupGLSurafceView(CameraGLSurfaceView glv, boolean autofit, int mirror, int render_egree) {
        this.mGLSurfaceView = glv;
        this.mGLSurfaceView.setOnRenderListener(this);
        this.mGLSurfaceView.setRenderConfig(render_egree, mirror);
        this.mGLSurfaceView.setAutoFitMax(autofit);
    }

    public void debug_print_fps(boolean preview, boolean render) {
        if (this.mGLSurfaceView != null) {
            this.mGLSurfaceView.debug_print_fps(render);
        }
        this.mFrameHelper.enable(preview);
    }

    public static interface OnCameraListener {
        public Camera setupCamera();

        public void setupChanged(int var1, int var2, int var3);

        public boolean startPreviewImmediately();

        public Object onPreview(byte[] var1, int var2, int var3, int var4, long var5);

        public void onBeforeRender(CameraFrameData var1);

        public void onAfterRender(CameraFrameData var1);
    }
}

